/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.transforms;

import com.sas.ComponentException;
import com.sas.GlobalInfoTable;
import com.sas.beans.Introspector;
import com.sas.util.transforms.BooleanToByteTransform;
import com.sas.util.transforms.BooleanToCharacterTransform;
import com.sas.util.transforms.BooleanToDoubleTransform;
import com.sas.util.transforms.BooleanToFloatTransform;
import com.sas.util.transforms.BooleanToIntegerTransform;
import com.sas.util.transforms.BooleanToLongTransform;
import com.sas.util.transforms.BooleanToShortTransform;
import com.sas.util.transforms.CharacterToBooleanTransform;
import com.sas.util.transforms.ColorToStringTransform;
import com.sas.util.transforms.IdentityTransform;
import com.sas.util.transforms.NumberToBooleanTransform;
import com.sas.util.transforms.NumberToByteTransform;
import com.sas.util.transforms.NumberToDoubleTransform;
import com.sas.util.transforms.NumberToFloatTransform;
import com.sas.util.transforms.NumberToIntegerTransform;
import com.sas.util.transforms.NumberToLongTransform;
import com.sas.util.transforms.NumberToShortTransform;
import com.sas.util.transforms.ObjectArrayToStringArrayTransform;
import com.sas.util.transforms.ObjectToAnalysisVariableTransform;
import com.sas.util.transforms.ObjectToClassificationVariableTransform;
import com.sas.util.transforms.ObjectToPlotVariableTransform;
import com.sas.util.transforms.ObjectToStringTransform;
import com.sas.util.transforms.ObjectToVariableTransform;
import com.sas.util.transforms.StaticDictionaryInterfaceToStringTransform;
import com.sas.util.transforms.StaticOrderedCollectionInterfaceToStringTransform;
import com.sas.util.transforms.StringArrayToStringTransform;
import com.sas.util.transforms.StringArrayToVectorTransform;
import com.sas.util.transforms.StringListInterfaceToStringTransform;
import com.sas.util.transforms.StringToBooleanTransform;
import com.sas.util.transforms.StringToByteTransform;
import com.sas.util.transforms.StringToColorTransform;
import com.sas.util.transforms.StringToDictionaryInterfaceTransform;
import com.sas.util.transforms.StringToDoubleTransform;
import com.sas.util.transforms.StringToFloatTransform;
import com.sas.util.transforms.StringToFontTransform;
import com.sas.util.transforms.StringToIntegerTransform;
import com.sas.util.transforms.StringToLongTransform;
import com.sas.util.transforms.StringToOneElementStringArrayTransform;
import com.sas.util.transforms.StringToOrderedCollectionInterfaceTransform;
import com.sas.util.transforms.StringToShortTransform;
import com.sas.util.transforms.StringToStringListInterfaceTransform;
import com.sas.util.transforms.TransformInterface;
import com.sas.util.transforms.VectorToStringArrayTransform;
import java.awt.Color;
import java.awt.Font;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Transforms {
    protected static boolean defaultTransformsRegistered;
    protected static Hashtable inputClasses;

    public static void registerDefaultTransforms() {
        if (defaultTransformsRegistered) {
            return;
        }
        defaultTransformsRegistered = true;
        Transforms.registerTransform(Object.class, String.class, (TransformInterface)ObjectToStringTransform.defaultInstance);
        Transforms.registerTransform(Byte.class, String.class, (TransformInterface)ObjectToStringTransform.defaultInstance);
        Transforms.registerTransform(String.class, Byte.class, (TransformInterface)StringToByteTransform.defaultInstance);
        Transforms.registerTransform(String.class, Byte.TYPE, (TransformInterface)StringToByteTransform.defaultInstance);
        Transforms.registerTransform(Double.class, String.class, (TransformInterface)ObjectToStringTransform.defaultInstance);
        Transforms.registerTransform(String.class, Double.class, (TransformInterface)StringToDoubleTransform.defaultInstance);
        Transforms.registerTransform(String.class, Double.TYPE, (TransformInterface)StringToDoubleTransform.defaultInstance);
        Transforms.registerTransform(Float.class, String.class, (TransformInterface)ObjectToStringTransform.defaultInstance);
        Transforms.registerTransform(String.class, Float.class, (TransformInterface)StringToFloatTransform.defaultInstance);
        Transforms.registerTransform(String.class, Float.TYPE, (TransformInterface)StringToFloatTransform.defaultInstance);
        Transforms.registerTransform(Integer.class, String.class, (TransformInterface)ObjectToStringTransform.defaultInstance);
        Transforms.registerTransform(String.class, Integer.class, (TransformInterface)StringToIntegerTransform.defaultInstance);
        Transforms.registerTransform(String.class, Integer.TYPE, (TransformInterface)StringToIntegerTransform.defaultInstance);
        Transforms.registerTransform(Long.class, String.class, (TransformInterface)ObjectToStringTransform.defaultInstance);
        Transforms.registerTransform(String.class, Long.class, (TransformInterface)StringToLongTransform.defaultInstance);
        Transforms.registerTransform(String.class, Long.TYPE, (TransformInterface)StringToLongTransform.defaultInstance);
        Transforms.registerTransform(Short.class, String.class, (TransformInterface)ObjectToStringTransform.defaultInstance);
        Transforms.registerTransform(String.class, Short.class, (TransformInterface)StringToShortTransform.defaultInstance);
        Transforms.registerTransform(String.class, Short.TYPE, (TransformInterface)StringToShortTransform.defaultInstance);
        Transforms.registerTransform(Boolean.class, String.class, (TransformInterface)ObjectToStringTransform.defaultInstance);
        Transforms.registerTransform(String.class, Boolean.class, (TransformInterface)StringToBooleanTransform.defaultInstance);
        Transforms.registerTransform(String.class, Boolean.TYPE, (TransformInterface)StringToBooleanTransform.defaultInstance);
        Transforms.registerTransform(String.class, String[].class, (TransformInterface)StringToOneElementStringArrayTransform.defaultInstance);
        Transforms.registerTransform(String[].class, String.class, (TransformInterface)StringArrayToStringTransform.defaultInstance);
        Transforms.registerTransform(Boolean.class, Character.class, (TransformInterface)BooleanToCharacterTransform.defaultInstance);
        Transforms.registerTransform(Boolean.class, Character.TYPE, (TransformInterface)BooleanToCharacterTransform.defaultInstance);
        Transforms.registerTransform(Boolean.TYPE, Character.class, (TransformInterface)BooleanToCharacterTransform.defaultInstance);
        Transforms.registerTransform(Boolean.TYPE, Character.TYPE, (TransformInterface)BooleanToCharacterTransform.defaultInstance);
        Transforms.registerTransform(Character.class, Boolean.class, (TransformInterface)CharacterToBooleanTransform.defaultInstance);
        Transforms.registerTransform(Character.TYPE, Boolean.class, (TransformInterface)CharacterToBooleanTransform.defaultInstance);
        Transforms.registerTransform(Character.class, Boolean.TYPE, (TransformInterface)CharacterToBooleanTransform.defaultInstance);
        Transforms.registerTransform(Character.TYPE, Boolean.TYPE, (TransformInterface)CharacterToBooleanTransform.defaultInstance);
        Transforms.registerTransform(Boolean.class, Byte.class, (TransformInterface)BooleanToByteTransform.defaultInstance);
        Transforms.registerTransform(Boolean.TYPE, Byte.class, (TransformInterface)BooleanToByteTransform.defaultInstance);
        Transforms.registerTransform(Boolean.class, Byte.TYPE, (TransformInterface)BooleanToByteTransform.defaultInstance);
        Transforms.registerTransform(Boolean.TYPE, Byte.TYPE, (TransformInterface)BooleanToByteTransform.defaultInstance);
        Transforms.registerTransform(Byte.class, Boolean.class, (TransformInterface)NumberToBooleanTransform.defaultInstance);
        Transforms.registerTransform(Byte.TYPE, Boolean.class, (TransformInterface)NumberToBooleanTransform.defaultInstance);
        Transforms.registerTransform(Byte.class, Boolean.TYPE, (TransformInterface)NumberToBooleanTransform.defaultInstance);
        Transforms.registerTransform(Byte.TYPE, Boolean.TYPE, (TransformInterface)NumberToBooleanTransform.defaultInstance);
        Transforms.registerTransform(Boolean.class, Double.class, (TransformInterface)BooleanToDoubleTransform.defaultInstance);
        Transforms.registerTransform(Boolean.TYPE, Double.class, (TransformInterface)BooleanToDoubleTransform.defaultInstance);
        Transforms.registerTransform(Boolean.class, Double.TYPE, (TransformInterface)BooleanToDoubleTransform.defaultInstance);
        Transforms.registerTransform(Boolean.TYPE, Double.TYPE, (TransformInterface)BooleanToDoubleTransform.defaultInstance);
        Transforms.registerTransform(Double.class, Boolean.class, (TransformInterface)NumberToBooleanTransform.defaultInstance);
        Transforms.registerTransform(Double.TYPE, Boolean.class, (TransformInterface)NumberToBooleanTransform.defaultInstance);
        Transforms.registerTransform(Double.class, Boolean.TYPE, (TransformInterface)NumberToBooleanTransform.defaultInstance);
        Transforms.registerTransform(Double.TYPE, Boolean.TYPE, (TransformInterface)NumberToBooleanTransform.defaultInstance);
        Transforms.registerTransform(Boolean.class, Float.class, (TransformInterface)BooleanToFloatTransform.defaultInstance);
        Transforms.registerTransform(Boolean.TYPE, Float.class, (TransformInterface)BooleanToFloatTransform.defaultInstance);
        Transforms.registerTransform(Boolean.class, Float.TYPE, (TransformInterface)BooleanToFloatTransform.defaultInstance);
        Transforms.registerTransform(Boolean.TYPE, Float.TYPE, (TransformInterface)BooleanToFloatTransform.defaultInstance);
        Transforms.registerTransform(Float.class, Boolean.class, (TransformInterface)NumberToBooleanTransform.defaultInstance);
        Transforms.registerTransform(Float.TYPE, Boolean.class, (TransformInterface)NumberToBooleanTransform.defaultInstance);
        Transforms.registerTransform(Float.class, Boolean.TYPE, (TransformInterface)NumberToBooleanTransform.defaultInstance);
        Transforms.registerTransform(Float.TYPE, Boolean.TYPE, (TransformInterface)NumberToBooleanTransform.defaultInstance);
        Transforms.registerTransform(Boolean.class, Integer.class, (TransformInterface)BooleanToIntegerTransform.defaultInstance);
        Transforms.registerTransform(Boolean.TYPE, Integer.class, (TransformInterface)BooleanToIntegerTransform.defaultInstance);
        Transforms.registerTransform(Boolean.class, Integer.TYPE, (TransformInterface)BooleanToIntegerTransform.defaultInstance);
        Transforms.registerTransform(Boolean.TYPE, Integer.TYPE, (TransformInterface)BooleanToIntegerTransform.defaultInstance);
        Transforms.registerTransform(Integer.class, Boolean.class, (TransformInterface)NumberToBooleanTransform.defaultInstance);
        Transforms.registerTransform(Integer.TYPE, Boolean.class, (TransformInterface)NumberToBooleanTransform.defaultInstance);
        Transforms.registerTransform(Integer.class, Boolean.TYPE, (TransformInterface)NumberToBooleanTransform.defaultInstance);
        Transforms.registerTransform(Integer.TYPE, Boolean.TYPE, (TransformInterface)NumberToBooleanTransform.defaultInstance);
        Transforms.registerTransform(Boolean.class, Long.class, (TransformInterface)BooleanToLongTransform.defaultInstance);
        Transforms.registerTransform(Boolean.TYPE, Long.class, (TransformInterface)BooleanToLongTransform.defaultInstance);
        Transforms.registerTransform(Boolean.class, Long.TYPE, (TransformInterface)BooleanToLongTransform.defaultInstance);
        Transforms.registerTransform(Boolean.TYPE, Long.TYPE, (TransformInterface)BooleanToLongTransform.defaultInstance);
        Transforms.registerTransform(Long.class, Boolean.class, (TransformInterface)NumberToBooleanTransform.defaultInstance);
        Transforms.registerTransform(Long.TYPE, Boolean.class, (TransformInterface)NumberToBooleanTransform.defaultInstance);
        Transforms.registerTransform(Long.class, Boolean.TYPE, (TransformInterface)NumberToBooleanTransform.defaultInstance);
        Transforms.registerTransform(Long.TYPE, Boolean.TYPE, (TransformInterface)NumberToBooleanTransform.defaultInstance);
        Transforms.registerTransform(Boolean.class, Short.class, (TransformInterface)BooleanToShortTransform.defaultInstance);
        Transforms.registerTransform(Boolean.TYPE, Short.class, (TransformInterface)BooleanToShortTransform.defaultInstance);
        Transforms.registerTransform(Boolean.class, Short.TYPE, (TransformInterface)BooleanToShortTransform.defaultInstance);
        Transforms.registerTransform(Boolean.TYPE, Short.TYPE, (TransformInterface)BooleanToShortTransform.defaultInstance);
        Transforms.registerTransform(Short.class, Boolean.class, (TransformInterface)NumberToBooleanTransform.defaultInstance);
        Transforms.registerTransform(Short.TYPE, Boolean.class, (TransformInterface)NumberToBooleanTransform.defaultInstance);
        Transforms.registerTransform(Short.class, Boolean.TYPE, (TransformInterface)NumberToBooleanTransform.defaultInstance);
        Transforms.registerTransform(Short.TYPE, Boolean.TYPE, (TransformInterface)NumberToBooleanTransform.defaultInstance);
        Transforms.registerTransform(Vector.class, String[].class, (TransformInterface)VectorToStringArrayTransform.defaultInstance);
        Transforms.registerTransform(String[].class, Vector.class, (TransformInterface)StringArrayToVectorTransform.defaultInstance);
        Transforms.registerTransform(Object[].class, String[].class, (TransformInterface)ObjectArrayToStringArrayTransform.defaultInstance);
        Transforms.registerTransform(Color.class, String.class, (TransformInterface)ColorToStringTransform.defaultInstance);
        Transforms.registerTransform(String.class, Color.class, (TransformInterface)StringToColorTransform.defaultInstance);
        Transforms.registerTransform(String.class, Font.class, (TransformInterface)StringToFontTransform.defaultInstance);
        Transforms.registerTransform(String.class, GlobalInfoTable._loadClass((String)"com.sas.collection.StringListInterface"), (TransformInterface)StringToStringListInterfaceTransform.defaultInstance);
        Transforms.registerTransform(GlobalInfoTable._loadClass((String)"com.sas.collection.StringListInterface"), String.class, (TransformInterface)StringListInterfaceToStringTransform.defaultInstance);
        Transforms.registerTransform(String.class, GlobalInfoTable._loadClass((String)"com.sas.collection.DictionaryInterface"), (TransformInterface)StringToDictionaryInterfaceTransform.defaultInstance);
        Transforms.registerTransform(String.class, GlobalInfoTable._loadClass((String)"com.sas.collection.OrderedCollectionInterface"), StringToOrderedCollectionInterfaceTransform.defaultInstance);
        Transforms.registerTransform(GlobalInfoTable._loadClass((String)"com.sas.collection.StaticOrderedCollectionInterface"), String.class, StaticOrderedCollectionInterfaceToStringTransform.defaultInstance);
        Transforms.registerTransform(GlobalInfoTable._loadClass((String)"com.sas.collection.StaticDictionaryInterface"), String.class, (TransformInterface)StaticDictionaryInterfaceToStringTransform.defaultInstance);
        Transforms.registerTransform(Object.class, GlobalInfoTable._loadClass((String)"com.sas.graphics.components.Variable"), ObjectToVariableTransform.defaultInstance);
        Transforms.registerTransform(Object.class, GlobalInfoTable._loadClass((String)"com.sas.graphics.components.ClassificationVariable"), ObjectToClassificationVariableTransform.defaultInstance);
        Transforms.registerTransform(Object.class, GlobalInfoTable._loadClass((String)"com.sas.graphics.components.AnalysisVariable"), ObjectToAnalysisVariableTransform.defaultInstance);
        Transforms.registerTransform(Object.class, GlobalInfoTable._loadClass((String)"com.sas.graphics.components.PlotVariable"), ObjectToPlotVariableTransform.defaultInstance);
        Class[][] numericClassLists = new Class[][]{{Number.class}, {Byte.class, Byte.TYPE}, {Double.class, Double.TYPE}, {Float.class, Float.TYPE}, {Integer.class, Integer.TYPE}, {Long.class, Long.TYPE}, {Short.class, Short.TYPE}};
        TransformInterface[] numericTransforms = new TransformInterface[]{IdentityTransform.identityTransform, NumberToByteTransform.defaultInstance, NumberToDoubleTransform.defaultInstance, NumberToFloatTransform.defaultInstance, NumberToIntegerTransform.defaultInstance, NumberToLongTransform.defaultInstance, NumberToShortTransform.defaultInstance};
        for (int listNum = 0; listNum < numericClassLists.length; ++listNum) {
            Class[] numericClasses = numericClassLists[listNum];
            for (int j = 0; j < numericClasses.length; ++j) {
                Transforms.registerTransform(numericClasses[j], Number.class, (TransformInterface)IdentityTransform.identityTransform);
                Transforms.registerTransformsForClasses(numericClassLists, numericClasses[j], numericTransforms[listNum]);
            }
        }
    }

    protected static void registerTransformsForClasses(Class[][] sourceClassLists, Class destClass, TransformInterface transform) {
        for (int listNum = 0; listNum < sourceClassLists.length; ++listNum) {
            Class[] numericClasses = sourceClassLists[listNum];
            for (int j = 0; j < numericClasses.length; ++j) {
                Transforms.registerTransform(numericClasses[j], destClass, transform);
            }
        }
    }

    public static void registerTransform(Class inputClass, Class outputClass, TransformInterface converterClass) {
        Transforms.registerDefaultTransforms();
        if (inputClasses.containsKey(inputClass)) {
            Hashtable outputClasses = (Hashtable)inputClasses.get(inputClass);
            outputClasses.put(outputClass, converterClass);
        } else {
            Hashtable<Class, TransformInterface> outputClasses = new Hashtable<Class, TransformInterface>();
            outputClasses.put(outputClass, converterClass);
            inputClasses.put(inputClass, outputClasses);
        }
    }

    public static void unregisterTransform(Class inputClass, Class outputClass, TransformInterface converterClass) {
        Hashtable outputClasses;
        Transforms.registerDefaultTransforms();
        if (inputClasses.containsKey(inputClass) && (outputClasses = (Hashtable)inputClasses.get(inputClass)).containsKey(outputClass)) {
            outputClasses.remove(outputClass);
        }
    }

    private static boolean isTrivialTransform(Class inputClass, Class outputClass) {
        return inputClass == outputClass || outputClass == Object.class || outputClass.isAssignableFrom(inputClass);
    }

    public static boolean isTransformable(Class inputClass, Class outputClass) {
        if (Transforms.isTrivialTransform(inputClass, outputClass)) {
            return true;
        }
        return Transforms.lookupTransform(inputClass, outputClass) != null;
    }

    public static TransformInterface lookupTransform(Class inputClass, Class outputClass) {
        if (Transforms.isTrivialTransform(inputClass, outputClass)) {
            return null;
        }
        Transforms.registerDefaultTransforms();
        while (inputClass != null) {
            Hashtable outputClasses;
            if (inputClasses.containsKey(inputClass) && (outputClasses = (Hashtable)inputClasses.get(inputClass)) != null && outputClasses.containsKey(outputClass)) {
                Object outputClassNameOrObject = outputClasses.get(outputClass);
                if (outputClassNameOrObject instanceof TransformInterface) {
                    return (TransformInterface)outputClassNameOrObject;
                }
                if (outputClassNameOrObject instanceof String) {
                    try {
                        Class transformClass = GlobalInfoTable.loadClass((String)((String)outputClassNameOrObject));
                        TransformInterface transform = (TransformInterface)transformClass.newInstance();
                        return transform;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            inputClass = inputClass.getSuperclass();
        }
        return null;
    }

    public static TransformInterface[] getRegisteredTransforms() {
        Transforms.registerDefaultTransforms();
        Vector<TransformInterface> transformNames = new Vector<TransformInterface>();
        Enumeration inputEnum = inputClasses.keys();
        while (inputEnum.hasMoreElements()) {
            Class inputClass = (Class)inputEnum.nextElement();
            Hashtable outputClasses = (Hashtable)inputClasses.get(inputClass);
            Enumeration outputEnum = outputClasses.keys();
            while (outputEnum.hasMoreElements()) {
                Class outputClass = (Class)outputEnum.nextElement();
                TransformInterface transform = (TransformInterface)outputClasses.get(outputClass);
                if (transformNames.contains(transform)) continue;
                transformNames.addElement(transform);
            }
        }
        Object[] transformArray = new TransformInterface[transformNames.size()];
        transformNames.copyInto(transformArray);
        return transformArray;
    }

    public static Hashtable getRegisteredSourceTransforms(Class inputClass) {
        Transforms.registerDefaultTransforms();
        Hashtable sourceTransforms = new Hashtable();
        if (inputClasses.containsKey(inputClass)) {
            sourceTransforms = (Hashtable)inputClasses.get(inputClass);
        }
        return sourceTransforms;
    }

    public static Hashtable getRegisteredTargetTransforms(Class targetClass) {
        Transforms.registerDefaultTransforms();
        Hashtable targetTransforms = new Hashtable();
        Enumeration inputClassesEnum = inputClasses.keys();
        Enumeration outputClassesEnum = inputClasses.elements();
        while (inputClassesEnum.hasMoreElements()) {
            Class inputClass = (Class)inputClassesEnum.nextElement();
            Hashtable outputClasses = (Hashtable)outputClassesEnum.nextElement();
            if (!outputClasses.containsKey(targetClass)) continue;
            targetTransforms.put(inputClass, outputClasses.get(targetClass));
        }
        return targetTransforms;
    }

    public static Enumeration getRegisteredSourceClasses() {
        Transforms.registerDefaultTransforms();
        return inputClasses.keys();
    }

    public static Enumeration getRegisteredSourceClassesForTransform(TransformInterface transform) {
        Transforms.registerDefaultTransforms();
        Vector<Class> classes = new Vector<Class>();
        Enumeration inputClassesEnum = inputClasses.keys();
        Enumeration outputClassesEnum = inputClasses.elements();
        while (inputClassesEnum.hasMoreElements()) {
            Class inputClass = (Class)inputClassesEnum.nextElement();
            Enumeration transformClassesEnum = ((Hashtable)outputClassesEnum.nextElement()).elements();
            while (transformClassesEnum.hasMoreElements()) {
                if (transformClassesEnum.nextElement().getClass() != transform.getClass()) continue;
                classes.add(inputClass);
            }
        }
        return classes.elements();
    }

    public static boolean isTransformable(Object source, String sourceProperty, Object target, String targetProperty) {
        Class<?> sourceType = null;
        Class<?> targetType = null;
        PropertyDescriptor targetPropertyDescriptor = null;
        try {
            BeanInfo sourceBeanInfo = Introspector.getBeanInfo(source.getClass());
            PropertyDescriptor sourcePropertyDescriptor = Introspector.getPropertyDescriptor((String)sourceProperty, (BeanInfo)sourceBeanInfo);
            if (sourcePropertyDescriptor == null) {
                throw new ComponentException("Transforms::isTransformable(): Unable to get property descriptor for source property : " + sourceProperty);
            }
            sourceType = sourcePropertyDescriptor.getPropertyType();
            BeanInfo targetBeanInfo = Introspector.getBeanInfo(target.getClass());
            targetPropertyDescriptor = Introspector.getPropertyDescriptor((String)targetProperty, (BeanInfo)targetBeanInfo);
            if (targetPropertyDescriptor == null) {
                System.out.println("Transforms::isTransformable(): Unable to get property descriptor for target property : " + targetProperty);
                throw new ComponentException("Transforms::isTransformable(): Unable to get property descriptor for target property : " + targetProperty);
            }
            targetType = targetPropertyDescriptor.getPropertyType();
            if (sourcePropertyDescriptor.getReadMethod() == null || targetPropertyDescriptor.getWriteMethod() == null) {
                return false;
            }
        }
        catch (Exception e) {
            System.out.println("Transforms::isTransformable(): Exception thrown looking up property information: " + e.toString());
            e.printStackTrace();
        }
        if (!Transforms.isTrivialTransform(sourceType, targetType)) {
            TransformInterface converterInstance = Transforms.lookupTransform(sourceType, targetType);
            if (converterInstance == null) {
                converterInstance = Transforms.lookupTransform(Object.class, targetType);
                return converterInstance != null;
            }
            return true;
        }
        return true;
    }

    static {
        inputClasses = new Hashtable();
    }
}

