/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.transforms;

import com.sas.GlobalInfoTable;
import com.sas.RunningObjectTable;
import com.sas.beans.editors._InstanceEditor;
import com.sas.util.transforms.TransformInterface;
import com.sas.util.transforms.Transforms;
import java.util.ArrayList;
import java.util.Enumeration;

public class TransformInterfaceEditor
extends _InstanceEditor {
    protected TransformInterface[] transforms;

    @Override
    public String getAsText() {
        if (this.value == null) {
            return "null";
        }
        TransformInterface transform = (TransformInterface)this.getValue();
        String name = RunningObjectTable.lookupComponentName(transform);
        if (name != null) {
            return name;
        }
        Class<?> transformClass = transform.getClass();
        return transformClass.getName();
    }

    @Override
    public String[] getTags() {
        return this.getTransforms();
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (text == null || text.trim().equals("null")) {
            this.setValue(null);
            return;
        }
        Object comp = RunningObjectTable.lookupComponent(text);
        boolean cont = false;
        if (comp != null) {
            if (comp instanceof TransformInterface) {
                cont = true;
            }
        } else {
            try {
                Class newClass = GlobalInfoTable.loadClass((String)text);
                if (TransformInterface.class.isAssignableFrom(newClass)) {
                    cont = true;
                }
            }
            catch (Exception newClass) {
                // empty catch block
            }
        }
        if (cont) {
            Object component = RunningObjectTable.lookupComponent(text);
            if (component != null) {
                this.setValue(component);
                this.firePropertyChange();
                return;
            }
            try {
                Class newClass = GlobalInfoTable.loadClass((String)text);
                this.setValue(newClass.newInstance());
                this.firePropertyChange();
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String[] getTransforms() {
        this.transforms = Transforms.getRegisteredTransforms();
        ArrayList<String> tagsList = new ArrayList<String>();
        tagsList.add("null");
        String frameName = this.getFrameName();
        Enumeration componentNames = RunningObjectTable.getComponentNames();
        while (componentNames.hasMoreElements()) {
            String name = (String)componentNames.nextElement();
            Object component = RunningObjectTable.lookupComponent(name);
            if (!this.instanceMatches(component) || !this.inSameFrame(name, frameName)) continue;
            tagsList.add(name);
        }
        for (int i = 1; i < this.transforms.length + 1; ++i) {
            tagsList.add(this.transforms[i - 1].getClass().getName());
        }
        String[] tags = new String[tagsList.size()];
        tagsList.toArray(tags);
        return tags;
    }

    @Override
    protected boolean instanceMatches(Object component) {
        return component instanceof TransformInterface;
    }

    protected String getFrameName() {
        String componentName;
        String frameName = null;
        if (this.bean != null && (componentName = RunningObjectTable.lookupComponentName(this.bean)) != null) {
            int dotIndex = componentName.indexOf(".");
            frameName = dotIndex > 0 ? componentName.substring(0, dotIndex) : componentName;
        }
        return frameName;
    }
}

