/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.transforms;

import com.sas.collection.StringCollection;
import com.sas.collection.StringListInterface;
import com.sas.io.ObjectTokenizer;
import com.sas.lang.DoubleData;
import com.sas.lang.FloatData;
import com.sas.util.EventGateInterface;
import com.sas.util.Util;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInputOutputInterface;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class StringToStringListInterfaceTransform
implements TransformInputOutputInterface {
    static final long serialVersionUID = 5919455578835003294L;
    private static final int TT_EOF = -1;
    private char delimiter;
    public static final StringToStringListInterfaceTransform defaultInstance = new StringToStringListInterfaceTransform();
    public Class stringCollectionClass;

    protected static char defaultDelimiterChar() {
        return Util.getListDelimiterChar();
    }

    public StringToStringListInterfaceTransform() {
        this(StringToStringListInterfaceTransform.defaultDelimiterChar());
    }

    public StringToStringListInterfaceTransform(char delimiter) {
        this.delimiter = delimiter;
    }

    public Object transform(Object object) throws TransformException {
        return StringToStringListInterfaceTransform.transform(this.newStringList(), (String)object, this.delimiter);
    }

    protected StringListInterface newStringList() {
        try {
            if (this.stringCollectionClass == null) {
                return new StringCollection();
            }
            return (StringListInterface)this.stringCollectionClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public static StringListInterface transform(StringListInterface stringList, String text, char delimiter) throws TransformException {
        String delimiters = "" + (char)delimiter;
        EventGateInterface eventGate = stringList instanceof EventGateInterface ? (EventGateInterface)stringList : null;
        try {
            if (eventGate != null) {
                eventGate.disableEvents();
            }
            ObjectTokenizer tokens = new ObjectTokenizer((Reader)new StringReader(text));
            int token = 0;
            while (token != -1) {
                boolean isObject;
                token = tokens.nextObject(delimiters, true);
                boolean isDelim = token == delimiter;
                boolean bl = isObject = !isDelim && token == -600;
                if (!isObject && !isDelim) break;
                Object object = isObject ? tokens.getLastObject() : "";
                if (object == null) {
                    stringList.add(null);
                } else if (object instanceof Double) {
                    stringList.add(DoubleData.toString((double)((Double)object)));
                } else if (object instanceof Float) {
                    stringList.add(FloatData.toString(((Float)object).floatValue()));
                } else {
                    stringList.add(object.toString());
                }
                if (isObject) {
                    token = tokens.nextToken();
                }
                if (token == delimiter) continue;
                break;
            }
            StringListInterface stringListInterface = stringList;
            return stringListInterface;
        }
        catch (IOException ioe) {
            throw new TransformException(ioe.getMessage());
        }
        finally {
            if (eventGate != null) {
                eventGate.enableEvents();
            }
        }
    }

    public Class getInputClass() {
        return String.class;
    }

    public Class getOutputClass() {
        return StringListInterface.class;
    }
}

