/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.transforms;

import com.sas.collection.Dictionary;
import com.sas.collection.DictionaryInterface;
import com.sas.io.ObjectTokenizer;
import com.sas.util.EventGateInterface;
import com.sas.util.Util;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInputOutputInterface;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class StringToDictionaryInterfaceTransform
implements TransformInputOutputInterface {
    static final long serialVersionUID = 5919455578835003294L;
    private char delimiter;
    private char separator;
    public static final StringToDictionaryInterfaceTransform defaultInstance = new StringToDictionaryInterfaceTransform();
    public Class dictionaryClass;

    protected static char defaultDelimiterChar() {
        return Util.getListDelimiterChar();
    }

    public StringToDictionaryInterfaceTransform() {
        this(StringToDictionaryInterfaceTransform.defaultDelimiterChar(), '=');
    }

    public StringToDictionaryInterfaceTransform(char delimiter) {
        this(delimiter, '=');
    }

    public StringToDictionaryInterfaceTransform(char delimiter, char separator) {
        this.delimiter = delimiter;
        this.separator = separator;
    }

    public Object transform(Object object) throws TransformException {
        return this.transform(this.newDictionary(), (String)object);
    }

    protected DictionaryInterface newDictionary() {
        try {
            if (this.dictionaryClass == null) {
                return new Dictionary();
            }
            return (DictionaryInterface)this.dictionaryClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public DictionaryInterface transform(DictionaryInterface dictionary, String text) throws TransformException {
        if (dictionary == null || text == null) {
            return dictionary;
        }
        ObjectTokenizer tokens = new ObjectTokenizer((Reader)new StringReader(text));
        int token = 0;
        String delimiters = "" + this.delimiter + this.separator;
        EventGateInterface eventGate = dictionary instanceof EventGateInterface ? (EventGateInterface)dictionary : null;
        try {
            Object key;
            if (eventGate != null) {
                eventGate.disableEvents();
            }
            dictionary.removeAll();
            while (token != -1 && (token = tokens.nextObject(delimiters, true)) != -1) {
                if (token != -600) {
                    throw new IllegalArgumentException();
                }
                key = tokens.getLastObject();
                Object value = null;
                token = tokens.nextToken();
                if (token != this.separator) {
                    dictionary.set(key, value);
                    if (token == -1 || token == this.delimiter) continue;
                    throw new IllegalArgumentException();
                }
                token = tokens.nextObject(delimiters, true);
                if (token == -600) {
                    value = tokens.getLastObject();
                    token = tokens.nextToken();
                }
                if (token != -1 && token != this.delimiter) {
                    throw new IllegalArgumentException();
                }
                dictionary.set(key, value);
            }
            key = dictionary;
            return key;
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            ioe.printStackTrace();
            throw new TransformException(ioe.getMessage());
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
            throw new TransformException(e.getMessage());
        }
        finally {
            if (eventGate != null) {
                eventGate.enableEvents();
            }
        }
    }

    public Class getInputClass() {
        return String.class;
    }

    public Class getOutputClass() {
        return DictionaryInterface.class;
    }
}

