/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.transforms;

import com.sas.collection.Collection;
import com.sas.collection.CollectionInterface;
import com.sas.io.ObjectTokenizer;
import com.sas.util.EventGateInterface;
import com.sas.util.Util;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class StringToCollectionInterfaceTransform
implements TransformInterface {
    static final long serialVersionUID = 5919455578835003294L;
    private char delimiter;
    private CollectionInterface collection = null;
    public static final StringToCollectionInterfaceTransform defaultInstance = new StringToCollectionInterfaceTransform();
    public Class collectionClass;

    protected static char defaultDelimiterChar() {
        return Util.getListDelimiterChar();
    }

    public StringToCollectionInterfaceTransform() {
        this(StringToCollectionInterfaceTransform.defaultDelimiterChar(), null);
    }

    public StringToCollectionInterfaceTransform(char delimiter) {
        this(delimiter, null);
    }

    public StringToCollectionInterfaceTransform(char delimiter, CollectionInterface collection) {
        this.delimiter = delimiter;
        this.collection = collection;
    }

    public Object transform(Object object) throws TransformException {
        if (this.collection == null) {
            return this.transform(this.newCollection(), (String)object);
        }
        return this.transform(this.collection, (String)object);
    }

    protected CollectionInterface newCollection() {
        try {
            if (this.collectionClass == null) {
                return new Collection();
            }
            return (CollectionInterface)this.collectionClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public CollectionInterface transform(CollectionInterface collection, String text) throws TransformException {
        String delimiters = "" + this.delimiter;
        EventGateInterface eventGate = collection instanceof EventGateInterface ? (EventGateInterface)collection : null;
        try {
            ObjectTokenizer tokens = new ObjectTokenizer((Reader)new StringReader(text));
            int token = 0;
            if (eventGate != null) {
                eventGate.disableEvents();
            }
            collection.removeAll();
            while (token != -1) {
                boolean isObject;
                token = tokens.nextObject(delimiters, true);
                boolean isDelim = token == this.delimiter;
                boolean bl = isObject = !isDelim && token == -600;
                if (!isObject && !isDelim) break;
                Object object = isObject ? tokens.getLastObject() : null;
                collection.add(object);
                if (isObject) {
                    token = tokens.nextToken();
                }
                if (token == -1 || token == this.delimiter) continue;
                throw new IllegalArgumentException("token = " + token + ", " + tokens.nval + ", " + tokens.sval + ", delimiter = " + this.delimiter);
            }
            CollectionInterface collectionInterface = collection;
            return collectionInterface;
        }
        catch (IOException ioe) {
            throw new TransformException(ioe.getMessage());
        }
        finally {
            if (eventGate != null) {
                eventGate.enableEvents();
            }
        }
    }
}

