/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.transforms;

import com.sas.collection.AssociationListInterface;
import com.sas.collection.StaticDictionaryInterface;
import com.sas.collection.StringCollection;
import com.sas.lang.DoubleData;
import com.sas.lang.FloatData;
import com.sas.util.StringComparator;
import com.sas.util.Strings;
import com.sas.util.Util;
import com.sas.util.transforms.TransformInputOutputInterface;
import java.util.Enumeration;

public class StaticDictionaryInterfaceToStringTransform
implements TransformInputOutputInterface {
    static final long serialVersionUID = 2836053506599852798L;
    private char delimiter;
    private char separator;
    private boolean alwaysQuote;
    public static final StaticDictionaryInterfaceToStringTransform defaultInstance = new StaticDictionaryInterfaceToStringTransform();

    protected static char defaultDelimiterChar() {
        return Util.getListDelimiterChar();
    }

    public StaticDictionaryInterfaceToStringTransform() {
        this(StaticDictionaryInterfaceToStringTransform.defaultDelimiterChar(), '=', true);
    }

    public StaticDictionaryInterfaceToStringTransform(char delimiter, char separator, boolean alwaysQuote) {
        this.delimiter = delimiter;
        this.separator = separator;
        this.alwaysQuote = alwaysQuote;
    }

    public Object transform(Object object) {
        if (object == null) {
            return "null";
        }
        StaticDictionaryInterface dictionary = (StaticDictionaryInterface)object;
        StringCollection items = new StringCollection();
        Enumeration keys = dictionary.getKeys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = dictionary.get(key);
            items.add(this.quote(key) + this.separator + this.quote(value));
        }
        items.sort(new StringComparator());
        StringBuffer buffer = new StringBuffer(256);
        int len = items.count();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                buffer.append(this.delimiter);
            }
            buffer.append(items.getString(i));
        }
        return buffer.toString();
    }

    public Object transform(AssociationListInterface object) {
        if (object == null) {
            return "null";
        }
        AssociationListInterface alist = object;
        StringBuffer buffer = new StringBuffer(256);
        for (int i = 0; i < alist.count(); ++i) {
            Object key = alist.getKey(i);
            Object value = alist.get(i);
            if (i > 0) {
                buffer.append(this.delimiter);
            }
            buffer.append(this.quote(key) + this.separator + this.quote(value));
        }
        return buffer.toString();
    }

    protected String quote(Object item) {
        if (item == null) {
            return "null";
        }
        if ("null".equals(item)) {
            return "\"null\"";
        }
        if (item instanceof String) {
            boolean special;
            String string = (String)item;
            boolean bl = special = string.indexOf(this.delimiter) > -1 || string.indexOf(this.separator) > -1 || Strings.needsQuoting((String)string);
            if (!special && !this.alwaysQuote) {
                return string;
            }
            return Strings.quote((String)string);
        }
        if (item instanceof Double) {
            return DoubleData.toString((double)((Double)item));
        }
        if (item instanceof Float) {
            return FloatData.toString(((Float)item).floatValue());
        }
        return item.toString();
    }

    public Class getInputClass() {
        return StaticDictionaryInterface.class;
    }

    public Class getOutputClass() {
        return String.class;
    }
}

