/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.transforms;

import com.sas.collection.StaticCollectionInterface;
import com.sas.lang.DoubleData;
import com.sas.lang.FloatData;
import com.sas.util.Strings;
import com.sas.util.Util;
import com.sas.util.transforms.TransformInterface;
import java.util.Enumeration;

public class StaticCollectionInterfaceToStringTransform
implements TransformInterface {
    static final long serialVersionUID = 2088989163438011867L;
    char delimiter;
    private boolean alwaysQuote;
    public static final StaticCollectionInterfaceToStringTransform defaultInstance = new StaticCollectionInterfaceToStringTransform();

    protected static char defaultDelimiterChar() {
        return Util.getListDelimiterChar();
    }

    public StaticCollectionInterfaceToStringTransform() {
        this(StaticCollectionInterfaceToStringTransform.defaultDelimiterChar(), true);
    }

    public StaticCollectionInterfaceToStringTransform(char delimiter, boolean alwaysQuote) {
        this.delimiter = delimiter;
        this.alwaysQuote = alwaysQuote;
    }

    public Object transform(Object object) {
        if (object == null) {
            return "null";
        }
        StaticCollectionInterface staticCollection = (StaticCollectionInterface)object;
        StringBuffer buffer = new StringBuffer(256);
        Enumeration items = staticCollection.getItems();
        boolean needDelimiter = false;
        while (items.hasMoreElements()) {
            Object item = items.nextElement();
            if (needDelimiter) {
                buffer.append(this.delimiter);
            }
            needDelimiter = true;
            if (item == null) {
                buffer.append("null");
                continue;
            }
            if ("null".equals(item)) {
                buffer.append("\"null\"");
                continue;
            }
            if (item instanceof String) {
                boolean special;
                String string = (String)item;
                boolean bl = special = string.indexOf(this.delimiter) > -1 || Strings.needsQuoting((String)string);
                if (!special && !this.alwaysQuote) {
                    buffer.append(string);
                    continue;
                }
                buffer.append(Strings.quote((String)string));
                continue;
            }
            if (item instanceof Double) {
                buffer.append(DoubleData.toString((double)((Double)item)));
                continue;
            }
            if (item instanceof Float) {
                buffer.append(FloatData.toString(((Float)item).floatValue()));
                continue;
            }
            buffer.append(item.toString());
        }
        return buffer.toString();
    }
}

