/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.transforms;

import com.sas.lang.ByteDataInterface;
import com.sas.lang.CharacterDataInterface;
import com.sas.lang.DoubleData;
import com.sas.lang.DoubleDataInterface;
import com.sas.lang.FloatData;
import com.sas.lang.FloatDataInterface;
import com.sas.lang.IntegerDataInterface;
import com.sas.lang.LongDataInterface;
import com.sas.lang.ShortDataInterface;
import com.sas.util.transforms.BaseFormatTransform;
import com.sas.util.transforms.TransformException;
import java.text.Format;

public class FormatTransform
extends BaseFormatTransform {
    public static final FormatTransform defaultInstance = new FormatTransform();

    public FormatTransform() {
        this(null);
    }

    public FormatTransform(Format format) {
        this.setFormat(format);
    }

    @Override
    public Object transform(Object object) throws TransformException {
        try {
            Format fmt = this.getFormat();
            if (fmt != null) {
                return fmt.format(object);
            }
            if (object instanceof DoubleDataInterface) {
                return DoubleData.toString(((DoubleDataInterface)object).getDoubleData());
            }
            if (object instanceof FloatDataInterface) {
                return FloatData.toString(((FloatDataInterface)object).getFloatData());
            }
            if (object instanceof LongDataInterface) {
                return Long.toString(((LongDataInterface)object).getLongData());
            }
            if (object instanceof IntegerDataInterface) {
                return Integer.toString(((IntegerDataInterface)object).getIntegerData());
            }
            if (object instanceof ShortDataInterface) {
                return Short.toString(((ShortDataInterface)object).getShortData());
            }
            if (object instanceof ByteDataInterface) {
                return Byte.toString(((ByteDataInterface)object).getByteData());
            }
            if (object instanceof CharacterDataInterface) {
                return ((CharacterDataInterface)object).getCharacterData() + "";
            }
            return DoubleData.toString(((Number)object).doubleValue());
        }
        catch (Exception e) {
            throw new TransformException(e.getMessage());
        }
    }
}

