/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.selectors;

import com.sas.GlobalInfoTable;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.beans.Util;
import com.sas.collection.AssociationList;
import com.sas.util.Classes;
import com.sas.util.selectors.ArraySelector;
import com.sas.util.selectors.BaseSelector;
import com.sas.util.selectors.PropertySelector;
import com.sas.util.selectors.RB;
import com.sas.util.selectors.SelectorInterface;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class Selector
extends BaseSelector {
    public static final String RB_KEY = "Selector.";
    static final long serialVersionUID = -8616070161193922343L;
    private SelectorInterface strategy;
    protected static AssociationList selectors = new AssociationList();
    private static Class selectorInterfaceClass;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "selectionStrategy"}, {"Description", RB.getStringResource(RB_KEY, "selectionStrategy.pd.txt")}, {"Expert", "true"}, {"Hidden", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.shortDescription = RB.getStringResource(RB_KEY, "description.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public Selector() {
    }

    public Selector(Object collection, Object key) {
        super(collection, key);
    }

    @Override
    public void setCollection(Object newCollection) {
        this.setCollection(newCollection, Selector.newSelector(newCollection));
    }

    public void setCollection(Object newCollection, SelectorInterface selector) {
        this.setSelectionStrategy(selector);
        super.setCollection(newCollection);
    }

    @Override
    public void setKey(Object newKey) {
        if (this.getSelectionStrategy() != null) {
            this.getSelectionStrategy().setKey(newKey);
        }
        super.setKey(newKey);
    }

    void setSelectionStrategy(SelectorInterface strategy) {
        if (this.strategy == strategy) {
            return;
        }
        SelectorInterface oldStrategy = this.getSelectionStrategy();
        Object oldValue = this.getValue();
        if (oldStrategy != null) {
            Util.removePropertyChangeListener((Object)oldStrategy, (PropertyChangeListener)this);
        }
        this.strategy = strategy;
        if (strategy != null) {
            Util.addPropertyChangeListener((Object)strategy, (PropertyChangeListener)this);
        }
        this.firePropertyChange("selectionStrategy", oldStrategy, this.getSelectionStrategy());
        this.update();
    }

    SelectorInterface getSelectionStrategy() {
        return this.strategy;
    }

    @Override
    public Object getValue(Object key) {
        return this.getSelectionStrategy().getValue(key);
    }

    @Override
    public Object getKey(Object value) {
        return this.getSelectionStrategy().getKey(value);
    }

    private static void loadSelectorInterfaceClass() {
        if (selectorInterfaceClass != null) {
            return;
        }
        try {
            selectorInterfaceClass = GlobalInfoTable.loadClass((String)"com.sas.util.selectors.SelectorInterface");
        }
        catch (ClassNotFoundException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        catch (ExceptionInInitializerError e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            e.getException().printStackTrace();
        }
        System.out.println("selectorInterfaceClass == " + selectorInterfaceClass);
    }

    public static void registerSelector(Class collectionClass, Class selectorClass) {
        Selector.loadSelectorInterfaceClass();
        if (!Classes.implementsInterface((Class)selectorClass, (Class)selectorInterfaceClass)) {
            throw new IllegalArgumentException();
        }
        System.out.println("register " + collectionClass.getName() + " for " + selectorClass.getName());
        selectors.add(0, collectionClass, selectorClass);
    }

    public static void registerSelector(String collectionClassName, String selectorClassName) throws ClassNotFoundException {
        System.out.println("registerSelector(" + collectionClassName + ", " + selectorClassName + ")");
        Selector.registerSelector(GlobalInfoTable.loadClass((String)collectionClassName), GlobalInfoTable.loadClass((String)selectorClassName));
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String prop = event.getPropertyName();
        if (event.getSource() == this.getSelectionStrategy() && ("key".equals(prop) || "value".equals(prop))) {
            this.firePropertyChange(prop, event.getOldValue(), event.getNewValue());
        }
        super.propertyChange(event);
    }

    public static SelectorInterface newSelector(Object collection) {
        if (collection == null) {
            return null;
        }
        SelectorInterface sel = Selector.newSelector(collection.getClass());
        sel.setCollection(collection);
        return sel;
    }

    public static SelectorInterface newSelector(Class collectionClass) {
        Class selClass = Selector.findSelectorClass(collectionClass);
        System.out.println("For " + collectionClass.getName() + ", use " + selClass.getName());
        return Selector.createSelector(selClass);
    }

    private static SelectorInterface createSelector(Class selClass) {
        SelectorInterface sel = null;
        try {
            sel = (SelectorInterface)selClass.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sel;
    }

    public static Class findSelectorClass(Class collectionClass) {
        if (collectionClass.isArray()) {
            return ArraySelector.class;
        }
        for (int i = 0; i < selectors.count(); ++i) {
            Class registeredClass = (Class)selectors.getKey(i);
            if (registeredClass.isInterface() && Classes.implementsInterface((Class)collectionClass, (Class)registeredClass)) {
                return (Class)selectors.get(i);
            }
            if (!Classes.extendsClass((Class)collectionClass, (Class)registeredClass)) continue;
            return (Class)selectors.get(i);
        }
        return PropertySelector.class;
    }

    static {
        try {
            Selector.registerSelector("java.util.Vector", "com.sas.util.selectors.VectorSelector");
            Selector.registerSelector("java.util.Dictionary", "com.sas.util.selectors.DictionarySelector");
            Selector.registerSelector("com.sas.table.StaticTableInterface", "com.sas.util.selectors.ColumnSelector");
            Selector.registerSelector("com.sas.sasserver.dataset.DataSetInterface", "com.sas.util.selectors.ColumnSelector");
            Selector.registerSelector("com.sas.collection.StaticPropertyBagInterface", "com.sas.util.selectors.StaticPropertyBagSelector");
            Selector.registerSelector("com.sas.collection.StaticDictionaryInterface", "com.sas.util.selectors.StaticDictionarySelector");
            Selector.registerSelector("com.sas.util.IndexedGetInterface", "com.sas.util.selectors.IndexedGetSelector");
            Selector.registerSelector("com.sas.collection.AssociationListInterface", "com.sas.util.selectors.AssociationListSelector");
        }
        catch (ClassNotFoundException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        catch (ExceptionInInitializerError e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            e.getException().printStackTrace();
        }
        catch (Error e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        Selector.loadSelectorInterfaceClass();
    }
}

