/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.selectors;

import com.sas.lang.ByteDataInterface;
import com.sas.lang.CharacterDataInterface;
import com.sas.lang.DoubleDataInterface;
import com.sas.lang.FloatDataInterface;
import com.sas.lang.IntegerDataInterface;
import com.sas.lang.LongDataInterface;
import com.sas.lang.ShortDataInterface;
import com.sas.lang.StringDataInterface;
import com.sas.util.selectors.BaseSelector;

abstract class IntegerIndexedSelector
extends BaseSelector {
    static final long serialVersionUID = 2609523111402075792L;

    protected IntegerIndexedSelector() {
    }

    protected IntegerIndexedSelector(Object collection, Object key) {
        super(collection, key);
    }

    @Override
    public Object getKey(Object value) {
        int key = this.keyAsInteger(value);
        return new Integer(key);
    }

    @Override
    public Object getValue(Object key) {
        int iKey = IntegerIndexedSelector.computeIntegerKey(key);
        return this.getValue(iKey);
    }

    public static int computeIntegerKey(Object key) {
        try {
            if (key instanceof Number) {
                return ((Number)key).intValue();
            }
            if (key instanceof String) {
                return Integer.parseInt((String)key);
            }
            if (key instanceof ByteDataInterface) {
                return ((ByteDataInterface)key).getByteData();
            }
            if (key instanceof CharacterDataInterface) {
                return ((CharacterDataInterface)key).getCharacterData();
            }
            if (key instanceof ShortDataInterface) {
                return ((ShortDataInterface)key).getShortData();
            }
            if (key instanceof IntegerDataInterface) {
                return ((IntegerDataInterface)key).getIntegerData();
            }
            if (key instanceof LongDataInterface) {
                return (int)((LongDataInterface)key).getLongData();
            }
            if (key instanceof FloatDataInterface) {
                return (int)((FloatDataInterface)key).getFloatData();
            }
            if (key instanceof DoubleDataInterface) {
                return (int)((DoubleDataInterface)key).getDoubleData();
            }
            if (key instanceof StringDataInterface) {
                return Integer.parseInt(((StringDataInterface)key).getText());
            }
            throw new IllegalArgumentException();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    protected abstract Object getValue(int var1);

    protected abstract int keyAsInteger(Object var1);
}

