/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.selectors;

import com.sas.Component;
import com.sas.ComponentInterfaceSupport;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedSource;
import com.sas.util.Util;
import com.sas.util.selectors.RB;
import com.sas.util.selectors.SelectorInterface;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public abstract class BaseSelector
extends Component
implements SelectorInterface,
ContentsChangedListener,
PropertyChangeListener {
    public static final String RB_KEY = "BaseSelector.";
    static final long serialVersionUID = -8616070161193922343L;
    private Object collection;
    private Object key;
    private Object value;
    private boolean found;
    private boolean haveValue;
    private boolean haveKey;
    protected Object lastValue;
    protected Object lastKey;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "collection"}, {"Description", RB.getStringResource(RB_KEY, "collection.pd.txt")}}, {{"Name", "key"}, {"Description", RB.getStringResource(RB_KEY, "key.pd.txt")}}, {{"Name", "value"}, {"Description", RB.getStringResource(RB_KEY, "value.pd.txt")}}, {{"Name", "found"}, {"Description", RB.getStringResource(RB_KEY, "found.pd.txt")}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public BaseSelector() {
    }

    public BaseSelector(Object collection, Object key) {
        this.setCollection(collection);
        this.setKey(key);
    }

    public BaseSelector(Object collection) {
        this.setCollection(collection);
    }

    @Override
    public Object getCollection() {
        return this.collection;
    }

    @Override
    public void setCollection(Object collection) {
        Object oldCollection = this.getCollection();
        if (oldCollection == collection) {
            return;
        }
        this.unlisten();
        this.collection = collection;
        this.listen();
        this.firePropertyChange("collection", oldCollection, this.getCollection());
        this.maybeFireValue(null);
    }

    protected void listen() {
        Object coll = this.getCollection();
        if (coll != null) {
            com.sas.beans.Util.addPropertyChangeListener((Object)coll, (PropertyChangeListener)this);
            if (coll instanceof ContentsChangedSource) {
                ((ContentsChangedSource)coll).addContentsChangedListener((ContentsChangedListener)this);
            }
        }
    }

    protected void unlisten() {
        Object coll = this.getCollection();
        if (coll != null) {
            com.sas.beans.Util.removePropertyChangeListener((Object)coll, (PropertyChangeListener)this);
            if (coll instanceof ContentsChangedSource) {
                ((ContentsChangedSource)coll).removeContentsChangedListener((ContentsChangedListener)this);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this.getCollection()) {
            this.update();
        }
    }

    public void contentsChanged(ContentsChangedEvent event) {
        if (event.getSource() == this.getCollection()) {
            this.update();
        }
    }

    protected void maybeFireValue(Object oldValue) {
        Object selection;
        if (this.anyPropertyChangeListeners() && (selection = this.getValue()) != oldValue) {
            this.firePropertyChange("value", oldValue, selection);
        }
    }

    public void update() {
        if (this.haveKey) {
            this.firePropertyChange("value", null, this.getValue());
        } else if (this.haveValue) {
            this.firePropertyChange("value", null, this.getKey());
        }
    }

    protected void maybeFireKey(Object oldKey) {
        Object currentKey;
        if (this.anyPropertyChangeListeners() && !Util.equal((Object)(currentKey = this.getKey()), (Object)oldKey)) {
            this.firePropertyChange("key", oldKey, currentKey);
        }
    }

    protected void setFound(boolean newFound) {
        if (this.found == newFound) {
            return;
        }
        boolean oldFound = this.found;
        this.found = newFound;
        ComponentInterfaceSupport.firePropertyChange(this, "found", this.found);
    }

    @Override
    public boolean isFound() {
        return this.found;
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        try {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    public final Object getValue() {
        Object val = null;
        if (this.haveValue) {
            val = this.value;
        } else if (this.haveKey) {
            try {
                val = this.getValue(this.getKey());
                this.setFound(true);
            }
            catch (Exception e) {
                this.setFound(false);
            }
        }
        return val;
    }

    @Override
    public abstract Object getValue(Object var1);

    protected void forgetValue() {
        this.value = null;
        this.haveValue = false;
    }

    protected void forgetKey() {
        this.key = null;
        this.haveKey = false;
    }

    public final Object getKey() {
        Object k = null;
        if (this.haveKey) {
            k = this.key;
        } else if (this.haveValue) {
            try {
                k = this.getKey(this.getValue());
                this.setFound(true);
            }
            catch (Exception e) {
                this.setFound(false);
            }
        }
        return k;
    }

    @Override
    public abstract Object getKey(Object var1);

    @Override
    public void setKey(Object newKey) {
        Object oldKey = this.getKey();
        this.forgetValue();
        this.haveKey = true;
        if (Util.equal((Object)oldKey, (Object)newKey)) {
            this.key = newKey;
            return;
        }
        this.key = newKey;
        this.firePropertyChange("key", oldKey, this.key);
        this.maybeFireValue(null);
    }

    @Override
    public void setValue(Object newValue) {
        Object oldValue = this.getValue();
        this.forgetKey();
        this.haveValue = true;
        if (Util.equal((Object)oldValue, (Object)newValue)) {
            this.value = newValue;
            return;
        }
        this.value = newValue;
        this.firePropertyChange("value", oldValue, this.value);
        this.maybeFireKey(null);
    }
}

