/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.selectors;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.util.Util;
import com.sas.util.selectors.IntegerIndexedSelector;
import com.sas.util.selectors.RB;
import java.lang.reflect.Array;
import java.util.NoSuchElementException;

public class ArraySelector
extends IntegerIndexedSelector {
    public static final String RB_KEY = "ArraySelector.";
    static final long serialVersionUID = 1050008439999092683L;

    public ArraySelector() {
    }

    public ArraySelector(Object array, Object key) {
        super(array, key);
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.shortDescription = RB.getStringResource(RB_KEY, "description.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    @Override
    protected Object getValue(int index) {
        Object array = this.getCollection();
        Class<?> componentType = array.getClass().getComponentType();
        if (!componentType.isPrimitive()) {
            return Array.get(array, index);
        }
        if (componentType == Boolean.TYPE) {
            return ((boolean[])array)[index] ? Boolean.TRUE : Boolean.FALSE;
        }
        if (componentType == Byte.TYPE) {
            return new Byte(((byte[])array)[index]);
        }
        if (componentType == Character.TYPE) {
            return new Character(((char[])array)[index]);
        }
        if (componentType == Short.TYPE) {
            return new Short(((short[])array)[index]);
        }
        if (componentType == Integer.TYPE) {
            return new Integer(((int[])array)[index]);
        }
        if (componentType == Long.TYPE) {
            return new Long(((long[])array)[index]);
        }
        if (componentType == Float.TYPE) {
            return new Float(((float[])array)[index]);
        }
        if (componentType == Double.TYPE) {
            return new Double(((double[])array)[index]);
        }
        throw new ClassCastException();
    }

    @Override
    protected int keyAsInteger(Object object) {
        Object array = this.getCollection();
        Class<?> componentType = array.getClass().getComponentType();
        int index = -1;
        if (!componentType.isPrimitive()) {
            Object[] a = (Object[])array;
            for (int i = 0; i < a.length; ++i) {
                if (!Util.equal((Object)object, (Object)Array.get(a, i))) continue;
                index = i;
                break;
            }
        } else if (componentType == Boolean.TYPE && object instanceof Boolean) {
            boolean[] a = (boolean[])array;
            boolean b = (Boolean)object;
            for (int i = 0; i < a.length; ++i) {
                if (a[i] != b) continue;
                index = i;
                break;
            }
        } else if (componentType == Byte.TYPE && object instanceof Byte) {
            byte[] a = (byte[])array;
            byte b = (Byte)object;
            for (int i = 0; i < a.length; ++i) {
                if (a[i] != b) continue;
                index = i;
                break;
            }
        } else if (componentType == Character.TYPE && object instanceof Character) {
            char[] a = (char[])array;
            char b = ((Character)object).charValue();
            for (int i = 0; i < a.length; ++i) {
                if (a[i] != b) continue;
                index = i;
                break;
            }
        } else if (componentType == Short.TYPE && object instanceof Short) {
            short[] a = (short[])array;
            short b = (Short)object;
            for (int i = 0; i < a.length; ++i) {
                if (a[i] != b) continue;
                index = i;
                break;
            }
        } else if (componentType == Integer.TYPE && object instanceof Integer) {
            int[] a = (int[])array;
            int b = (Integer)object;
            for (int i = 0; i < a.length; ++i) {
                if (a[i] != b) continue;
                index = i;
                break;
            }
        } else if (componentType == Long.TYPE && object instanceof Long) {
            long[] a = (long[])array;
            long b = (Long)object;
            for (int i = 0; i < a.length; ++i) {
                if (a[i] != b) continue;
                index = i;
                break;
            }
        } else if (componentType == Float.TYPE && object instanceof Float) {
            float[] a = (float[])array;
            float b = ((Float)object).floatValue();
            for (int i = 0; i < a.length; ++i) {
                if (a[i] != b) continue;
                index = i;
                break;
            }
        } else if (componentType == Double.TYPE && object instanceof Double) {
            double[] a = (double[])array;
            double b = (Double)object;
            for (int i = 0; i < a.length; ++i) {
                if (a[i] != b) continue;
                index = i;
                break;
            }
        } else {
            throw new ClassCastException();
        }
        if (index == -1) {
            throw new NoSuchElementException();
        }
        return index;
    }
}

