/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.models.SimpleNodeInterface;
import com.sas.models.TreeInterface;
import com.sas.util.TreeIteratorInterface;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class TreeIterator
implements TreeIteratorInterface,
Iterator {
    private transient TreeInterface m_tree;

    public TreeIterator(TreeInterface tree) {
        if (tree == null) {
            throw new IllegalArgumentException();
        }
        this.m_tree = tree;
    }

    @Override
    public TreeInterface getTree() {
        return this.m_tree;
    }

    @Override
    public void setNode(SimpleNodeInterface node) {
        int index = this.getNodeIndex();
        while (this.hasMoreNodes()) {
            if (this.getNode().equals(node)) {
                return;
            }
            this.nextNode();
        }
        this.reset();
        while (this.getNodeIndex() != index) {
            if (this.getNode().equals(node)) {
                return;
            }
            this.nextNode();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void setNodeIndex(int newIndex) {
        if (newIndex < 0) {
            throw new IllegalArgumentException();
        }
        if (newIndex < this.getNodeIndex()) {
            this.reset();
        }
        while (this.getNodeIndex() != newIndex && this.hasMoreNodes()) {
            this.nextNode();
        }
        if (this.getNodeIndex() != newIndex) {
            throw new IndexOutOfBoundsException();
        }
    }

    public final boolean equals(Object obj) {
        return obj instanceof TreeIterator && this.equals((TreeIterator)obj);
    }

    public boolean equals(TreeIterator other) {
        return other != null && other.getTree().equals(this.getTree()) && other.getNodeIndex() == this.getNodeIndex();
    }

    @Override
    public boolean hasNext() {
        return this.hasMoreElements();
    }

    public Object next() {
        return this.nextElement();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

