/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.util.Comparator;
import com.sas.util.GenericComparator;
import com.sas.util.StringComparator;
import com.sas.util.Util;
import com.sas.util.transforms.IdentityTransform;
import com.sas.util.transforms.ParseTransform;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;

public class TransformingComparator
extends StringComparator {
    static final long serialVersionUID = -5987605467564836186L;
    private TransformInterface leftTransform;
    private TransformInterface rightTransform;
    private Comparator comparator;

    public TransformingComparator() {
        this((Comparator)GenericComparator.defaultInstance, ParseTransform.defaultInstance);
    }

    public TransformingComparator(Comparator comparator) {
        this(comparator, ParseTransform.defaultInstance);
    }

    public TransformingComparator(Comparator comparator, TransformInterface transform) {
        this(comparator, transform, transform);
    }

    public TransformingComparator(Comparator comparator, TransformInterface leftTransform, TransformInterface rightTransform) {
        this.setComparator(comparator);
        this.setLeftTransform(leftTransform);
        this.setRightTransform(rightTransform);
    }

    public void setComparator(Comparator newComparator) {
        Comparator oldComparator;
        if (newComparator == null) {
            newComparator = GenericComparator.defaultInstance;
        }
        if (Util.equal((Object)(oldComparator = this.getComparator()), (Object)newComparator)) {
            return;
        }
        this.comparator = newComparator;
        this.firePropertyChange("comparator", oldComparator, this.getComparator());
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setLeftTransform(TransformInterface newLeftTransform) {
        TransformInterface oldLeftTransform;
        if (newLeftTransform == null) {
            newLeftTransform = IdentityTransform.identityTransform;
        }
        if (Util.equal((Object)(oldLeftTransform = this.getLeftTransform()), (Object)newLeftTransform)) {
            return;
        }
        this.leftTransform = newLeftTransform;
        this.firePropertyChange("leftTransform", oldLeftTransform, this.getLeftTransform());
    }

    public TransformInterface getLeftTransform() {
        return this.leftTransform;
    }

    public void setRightTransform(TransformInterface newRightTransform) {
        TransformInterface oldRightTransform;
        if (newRightTransform == null) {
            newRightTransform = IdentityTransform.identityTransform;
        }
        if (Util.equal((Object)(oldRightTransform = this.getRightTransform()), (Object)newRightTransform)) {
            return;
        }
        this.rightTransform = newRightTransform;
        this.firePropertyChange("rightTransform", oldRightTransform, this.getRightTransform());
    }

    public TransformInterface getRightTransform() {
        return this.rightTransform;
    }

    @Override
    public int compare(Object left, Object right) {
        try {
            Object leftVal = this.leftTransform.transform(left);
            Object rightVal = this.rightTransform.transform(right);
            return this.comparator.compare(leftVal, rightVal);
        }
        catch (TransformException te) {
            return Integer.MAX_VALUE;
        }
    }
}

