/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.Component;
import com.sas.GlobalInfoTable;
import com.sas.ModelInterface;
import com.sas.RB;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedSource;
import com.sas.collection.Dictionary;
import com.sas.collection.DictionaryInterface;
import com.sas.collection.StringCollection;
import com.sas.lang.StringDataInterface;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.Format;
import java.util.Vector;

public class Template
extends Component
implements StringDataInterface,
ContentsChangedListener {
    static final String RB_KEY = "Template.";
    static final long serialVersionUID = -7640300770674352320L;
    static String[] requiredInterfacesString = new String[]{"com.sas.collection.StaticDictionaryInterface"};
    private String submit_string = "";
    private String template_string = "";
    private boolean formatException = false;
    private StringCollection temp_string_array;
    public boolean hasInitialized;
    private String vdelimiter = "%";
    private char openc = (char)40;
    private char closec = (char)41;
    private transient String ddelimiter = "%%";
    private transient String open = "(";
    private transient String close = ")";
    public Dictionary dlist;
    private int npos;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "template"}, {"Description", com.sas.util.RB.getStringResource((String)RB_KEY, (String)"template.pd.txt")}}, {{"Name", "text"}, {"Description", com.sas.util.RB.getStringResource((String)RB_KEY, (String)"text.pd.txt")}}, {{"Name", "marker"}, {"Description", com.sas.util.RB.getStringResource((String)RB_KEY, (String)"marker.pd.txt")}}, {{"Name", "open"}, {"Description", com.sas.util.RB.getStringResource((String)RB_KEY, (String)"open.pd.txt")}}, {{"Name", "close"}, {"Description", com.sas.util.RB.getStringResource((String)RB_KEY, (String)"close.pd.txt")}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "template";
        ebi.defaultOutputPropertyName = "text";
        ebi.shortDescription = com.sas.util.RB.getStringResource((String)RB_KEY, (String)"description.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public Template() {
        this.initializeComponent();
        this.temp_string_array = new StringCollection();
    }

    public Template(String pattern) {
        this();
        this.setTemplate(pattern);
    }

    public Template(String pattern, DictionaryInterface dictionary) throws IllegalArgumentException {
        this(pattern, dictionary, '%', '(', ')');
    }

    public Template(String pattern, DictionaryInterface dictionary, char marker, char open, char close) {
        this();
        this.setMarker(marker);
        this.setOpen(open);
        this.setClose(close);
        this.setTemplate(pattern);
        this.attachDictionary(dictionary);
    }

    private void attachDictionary(DictionaryInterface dictionary) {
        if (dictionary != null) {
            if (dictionary instanceof ModelInterface) {
                this.attachModel((ModelInterface)((Object)dictionary));
            } else {
                throw new IllegalArgumentException(Message.format((String)RB.getStringResource((String)"ViewInterfaceSupport.", (String)"notModelInterface.ex.txt"), (Object)this.getClass().getName()));
            }
        }
    }

    public Template(DictionaryInterface dictionary) throws IllegalArgumentException {
        this();
        this.attachDictionary(dictionary);
    }

    @Override
    public void attachModel(ModelInterface si) {
        if (si instanceof ContentsChangedSource) {
            ((ContentsChangedSource)si).addContentsChangedListener((ContentsChangedListener)this);
        }
        super.attachModel(si);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Template newData = (Template)super.clone();
        return newData;
    }

    public void contentsChanged(ContentsChangedEvent evt) {
        String oldValue = this.submit_string;
        this.processText();
        this.firePropertyChange("text", oldValue, this.submit_string);
    }

    @Override
    public void detachModel(ModelInterface si) {
        if (si instanceof ContentsChangedSource) {
            ((ContentsChangedSource)si).removeContentsChangedListener((ContentsChangedListener)this);
        }
        super.detachModel(si);
    }

    private String[] findVarDelimiter(String nstring) {
        String[] subvar = new String[]{null, null, null};
        int[] cpos = Strings.positions((String)nstring, (int)0, (int)-1, (char)',');
        if (cpos.length > 0) {
            for (int i = 0; i < 2; ++i) {
                String[] temp = this.parseFields(nstring);
                switch (i) {
                    case 0: {
                        subvar[0] = temp[0];
                        break;
                    }
                    case 1: {
                        subvar[1] = temp[0];
                        break;
                    }
                    case 3: {
                        subvar[2] = temp[0];
                    }
                }
                if (temp[1] != null) {
                    nstring = temp[1];
                    continue;
                }
                break;
            }
        } else {
            subvar[0] = nstring;
        }
        for (int j = 0; j < 3; ++j) {
            int[] hpos;
            if (subvar[j] == null || (hpos = Strings.positions((String)subvar[j], (int)0, (int)-1, (char)'\"')).length < 2) continue;
            subvar[j] = subvar[j].substring(hpos[0] + 1, hpos[hpos.length - 1]);
        }
        return subvar;
    }

    @Override
    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        return requiredInterfaces;
    }

    public synchronized String getTemplate() {
        return this.template_string;
    }

    public synchronized String getText() {
        this.processText();
        return this.submit_string;
    }

    @Override
    public void initialize() {
        if (this.getModelInterface() == null) {
            if (this.dlist.count() > 0) {
                this.attachModel(this.dlist);
            }
            this.dlist.initialize();
        }
        this.firePropertyChange("text", null, null);
        this.hasInitialized = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String[] parseFields(String mstring) {
        String[] holder = new String[]{null, null};
        int k = 0;
        int[] cpos = Strings.positions((String)mstring, (int)0, (int)-1, (String)",", (boolean)false);
        if (cpos.length <= 0) {
            holder[0] = mstring;
            return holder;
        }
        int j = 0;
        while (j < cpos.length) {
            String cstring = mstring.substring(k, cpos[j]);
            int[] qpos = Strings.positions((String)cstring, (int)0, (int)-1, (char)'\"');
            if (qpos.length != 1) {
                if (cstring.length() > 0) {
                    int[] ppos6;
                    int[] ppos5 = Strings.positions((String)cstring, (int)0, (int)-1, (String)this.open, (boolean)false);
                    if (ppos5.length == (ppos6 = Strings.positions((String)cstring, (int)0, (int)-1, (String)this.close, (boolean)false)).length) {
                        holder[0] = mstring.substring(k, cpos[j]);
                        if (cpos[j] + 1 >= mstring.length()) return holder;
                        holder[1] = mstring.substring(cpos[j] + 1);
                        return holder;
                    }
                    holder[0] = mstring;
                } else if (cpos[j] + 1 < mstring.length()) {
                    holder[1] = mstring.substring(cpos[j] + 1);
                    return holder;
                }
            }
            ++j;
        }
        return holder;
    }

    private boolean parseStringTokens(String fstring, StringCollection strname) {
        boolean kvalue = false;
        if (fstring.length() > 0) {
            boolean flag = true;
            if (fstring.equals(this.vdelimiter)) {
                strname.add(fstring);
                kvalue = true;
            } else {
                for (int i = 1; i < fstring.length(); ++i) {
                    char c = fstring.charAt(i);
                    if (i == 1 && Character.isJavaIdentifierStart(c)) {
                        flag = true;
                        continue;
                    }
                    if (i > 1 && Character.isJavaIdentifierPart(c)) {
                        flag = true;
                        continue;
                    }
                    if (fstring.charAt(i) != this.openc) {
                        strname.add(fstring.substring(0, i));
                        strname.add(fstring.substring(i));
                        kvalue = true;
                        flag = false;
                        break;
                    }
                    flag = false;
                    int[] ppos1 = Strings.positions((String)fstring, (int)0, (int)-1, (String)this.open, (boolean)false);
                    int[] ppos2 = Strings.positions((String)fstring, (int)0, (int)-1, (String)this.close, (boolean)false);
                    if (ppos1.length <= 0 || ppos2.length <= 0) break;
                    if (ppos1.length == 1 && ppos2.length == 1) {
                        strname.add(fstring.substring(0, ppos2[ppos2.length - 1]) + this.close);
                        if (ppos2[ppos2.length - 1] + 1 <= fstring.length() - 1) {
                            strname.add(fstring.substring(ppos2[ppos2.length - 1] + 1));
                        }
                        kvalue = true;
                        break;
                    }
                    if (ppos1.length > 1) {
                        if (ppos1[1] > ppos2[0]) {
                            strname.add(fstring.substring(0, ppos2[0]) + this.close);
                            if (ppos2[0] + 1 <= fstring.length() - 1) {
                                strname.add(fstring.substring(ppos2[0] + 1));
                            }
                            kvalue = true;
                            break;
                        }
                        if (ppos1.length != ppos2.length) break;
                        strname.add(fstring.substring(0, ppos2[ppos2.length - 1]) + this.close);
                        if (ppos2[ppos2.length - 1] + 1 <= fstring.length() - 1) {
                            strname.add(fstring.substring(ppos2[ppos2.length - 1] + 1));
                        }
                        kvalue = true;
                        kvalue = true;
                        break;
                    }
                    if (ppos1.length >= ppos2.length) break;
                    strname.add(fstring.substring(0, ppos2[0]) + this.close);
                    if (ppos2[0] + 1 <= fstring.length() - 1) {
                        strname.add(fstring.substring(ppos2[0] + 1));
                    }
                    kvalue = true;
                    break;
                }
                if (flag) {
                    strname.add(fstring);
                    kvalue = true;
                }
            }
        }
        return kvalue;
    }

    private String parseToken(String pstring) {
        boolean var1Set = false;
        boolean var2Set = false;
        boolean var3Set = false;
        String resolvedString = null;
        String tstring = null;
        if (pstring.startsWith(this.vdelimiter) && pstring.length() > 1) {
            if (this.getModelInterface() != null) {
                int pos = pstring.indexOf(this.openc);
                if (pos == -1) {
                    Object tempobj;
                    String vstring = pstring.substring(1);
                    if (((DictionaryInterface)((Object)this.getModelInterface())).count() > 0 && ((DictionaryInterface)((Object)this.getModelInterface())).containsKey(vstring) && (tempobj = ((DictionaryInterface)((Object)this.getModelInterface())).get(vstring)) != null) {
                        resolvedString = tempobj.toString();
                    }
                } else {
                    Object tempobj;
                    String vstring = pstring.substring(1, pos);
                    if (((DictionaryInterface)((Object)this.getModelInterface())).count() > 0 && ((DictionaryInterface)((Object)this.getModelInterface())).containsKey(vstring) && (tempobj = ((DictionaryInterface)((Object)this.getModelInterface())).get(vstring)) != null) {
                        tstring = tempobj.toString();
                    }
                    String nstring = pstring.substring(pos + 1);
                    int[] mpos = Strings.positions((String)nstring, (int)0, (int)-1, (char)this.closec);
                    nstring = nstring.substring(0, mpos[mpos.length - 1]);
                    if ((nstring = nstring.trim()).length() == 0) {
                        resolvedString = tstring;
                    } else {
                        String out;
                        int i;
                        StringCollection var_string_array;
                        String[] var = this.findVarDelimiter(nstring);
                        String hold = "";
                        if (var[0] != null) {
                            var1Set = true;
                            var_string_array = new StringCollection();
                            this.tokenizeField(var[0], var_string_array);
                            for (i = 0; i < var_string_array.count(); ++i) {
                                out = this.parseToken(var_string_array.getString(i));
                                if (out == null) continue;
                                hold = hold + out;
                            }
                            var[0] = hold;
                        }
                        if (var[1] != null) {
                            var2Set = true;
                            var_string_array = new StringCollection();
                            this.tokenizeField(var[1], var_string_array);
                            hold = "";
                            for (i = 0; i < var_string_array.count(); ++i) {
                                out = this.parseToken(var_string_array.getString(i));
                                if (out == null) continue;
                                hold = hold + out;
                            }
                            var[1] = hold;
                        }
                        if (var[2] != null) {
                            var3Set = true;
                            var_string_array = new StringCollection();
                            this.tokenizeField(var[2], var_string_array);
                            hold = "";
                            for (i = 0; i < var_string_array.count(); ++i) {
                                out = this.parseToken(var_string_array.getString(i));
                                if (out == null) continue;
                                hold = hold + out;
                            }
                            var[2] = hold;
                        }
                        if (var[2] != null) {
                            try {
                                Format fd = (Format)GlobalInfoTable.loadClass((String)var[2]).newInstance();
                                String formatted = tstring != null ? fd.format(tstring) : fd.format(var[1]);
                                resolvedString = formatted;
                            }
                            catch (InstantiationException e) {
                                resolvedString = null;
                            }
                            catch (IllegalAccessException e) {
                                resolvedString = null;
                            }
                            catch (ClassNotFoundException e) {
                                resolvedString = null;
                            }
                        } else if (tstring == null) {
                            if (var[1] == null && !var2Set) {
                                return null;
                            }
                            resolvedString = var[1];
                        } else {
                            if (var[0] == null && !var1Set) {
                                return null;
                            }
                            resolvedString = var[0];
                        }
                    }
                }
            }
        } else {
            resolvedString = pstring;
        }
        return resolvedString;
    }

    private void processText() {
        this.tokenizeTemplate();
        this.npos = 0;
        while (this.npos < this.temp_string_array.count()) {
            String pstring = this.temp_string_array.getString(this.npos);
            String tmp = this.parseToken(pstring);
            if (tmp != null) {
                this.temp_string_array.setString(this.npos, tmp);
            } else {
                this.temp_string_array.removeStringAt(this.npos);
                --this.npos;
            }
            ++this.npos;
        }
        String tempString = "";
        for (int k = 0; k < this.temp_string_array.count(); ++k) {
            tempString = tempString + this.temp_string_array.getString(k);
        }
        if (!tempString.equals(this.submit_string)) {
            this.submit_string = tempString;
            this.submit_string = Strings.replace((String)this.submit_string, (int)0, (int)-1, (String)this.ddelimiter, (String)this.vdelimiter);
        }
    }

    public void refresh() {
        if (this.getModelInterface() != null && this.hasInitialized) {
            this.firePropertyChange("text", null, null);
        }
    }

    @Override
    public void refresh(ModelInterface Model) {
        if (this.getModelInterface() != null && this.hasInitialized) {
            this.firePropertyChange("text", null, null);
        }
    }

    public synchronized void setTemplate(String string_val) {
        if (string_val == null) {
            this.template_string = "";
        }
        if (!string_val.equals(this.template_string)) {
            String oldTemplate = this.getTemplate();
            this.template_string = string_val;
            this.firePropertyChange("template", oldTemplate, string_val);
            String oldValue = this.submit_string;
            this.processText();
            this.firePropertyChange("text", oldValue, this.submit_string);
        }
    }

    public void setText(String s) {
    }

    public synchronized void setMarker(char marker) {
        char oldMarker = this.getMarker();
        if (oldMarker == marker) {
            return;
        }
        this.vdelimiter = new String(new char[]{marker});
        this.ddelimiter = this.vdelimiter + this.vdelimiter;
        String oldValue = this.submit_string;
        this.processText();
        this.firePropertyChange("marker", new Character(oldMarker), new Character(this.getMarker()));
        if (Util.unequal((Object)oldValue, (Object)this.submit_string)) {
            this.firePropertyChange("text", oldValue, this.submit_string);
        }
    }

    public char getMarker() {
        return this.vdelimiter.charAt(0);
    }

    public synchronized void setClose(char close) {
        char oldClose = this.getClose();
        if (oldClose == close) {
            return;
        }
        this.closec = close;
        this.close = new String(new char[]{close});
        String oldValue = this.submit_string;
        if (this.open != null) {
            this.processText();
        }
        this.processText();
        this.firePropertyChange("close", new Character(oldClose), new Character(this.getClose()));
        if (Util.unequal((Object)oldValue, (Object)this.submit_string)) {
            this.firePropertyChange("text", oldValue, this.submit_string);
        }
    }

    public char getClose() {
        return this.closec;
    }

    public synchronized void setOpen(char open) {
        char oldOpen = this.getOpen();
        if (oldOpen == open) {
            return;
        }
        this.openc = open;
        this.open = new String(new char[]{open});
        String oldValue = this.submit_string;
        if (this.close != null) {
            this.processText();
        }
        this.firePropertyChange("open", new Character(oldOpen), new Character(this.getOpen()));
        if (Util.unequal((Object)oldValue, (Object)this.submit_string)) {
            this.firePropertyChange("text", oldValue, this.submit_string);
        }
    }

    public char getOpen() {
        return this.openc;
    }

    private void tokenizeField(String strtemp, StringCollection collname) {
        int[] tpos = Strings.positions((String)strtemp, (int)0, (int)-1, (String)this.vdelimiter, (boolean)false);
        if (tpos.length > 0) {
            int k = 0;
            for (int j = 0; j < tpos.length; ++j) {
                String fstring = strtemp.substring(k, tpos[j]);
                if (!this.parseStringTokens(fstring, collname)) continue;
                k = tpos[j];
            }
            boolean bl = this.parseStringTokens(strtemp.substring(k, strtemp.length()), collname);
        } else {
            collname.add(strtemp);
        }
    }

    private void tokenizeTemplate() {
        this.temp_string_array.removeAll();
        int[] tpos = Strings.positions((String)this.template_string, (int)0, (int)-1, (String)this.vdelimiter, (boolean)false);
        String tempstring = this.template_string;
        if (tpos.length > 0) {
            int k = 0;
            for (int j = 0; j < tpos.length; ++j) {
                String fstring = tempstring.substring(k, tpos[j]);
                if (!this.parseStringTokens(fstring, this.temp_string_array)) continue;
                k = tpos[j];
            }
            boolean bl = this.parseStringTokens(tempstring.substring(k, tempstring.length()), this.temp_string_array);
        } else {
            this.temp_string_array.add(this.template_string);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        char c = this.openc;
        this.openc = '\u0000';
        if (c == '\u0000') {
            c = '(';
            this.openc = (char)40;
        }
        this.open = new String(new char[]{c});
        c = this.closec;
        this.closec = '\u0000';
        if (c == '\u0000') {
            c = ')';
            this.closec = (char)41;
        }
        this.close = new String(new char[]{c});
        this.ddelimiter = this.vdelimiter + this.vdelimiter;
    }

    @Override
    public void setDefaultValues() {
        this.dlist = new Dictionary();
        if (this.getModelInterface() == null) {
            if (this.dlist.count() > 0) {
                this.attachModel(this.dlist);
            }
            this.dlist.initialize();
        }
        this.firePropertyChange("text", null, null);
        this.hasInitialized = true;
    }
}

