/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.Component;
import com.sas.PublicClonable;
import com.sas.util.Comparator;
import com.sas.util.Util;
import java.io.Serializable;
import java.text.Collator;

public class StringComparator
extends Component
implements Comparator,
PublicClonable,
Serializable,
java.util.Comparator {
    static final String RB_KEY = "StringComparator.";
    static final long serialVersionUID = 770854091247656479L;
    private boolean ascending;
    private boolean caseSensitive;
    private int startChar;
    private Collator collator;
    public static final StringComparator defaultInstance = new StringComparator();

    public StringComparator() {
        this(true, true, 0);
    }

    public StringComparator(Collator collator) {
        this(true, true, 0);
        this.collator = collator;
    }

    public StringComparator(boolean ascending) {
        this(ascending, true, 0);
    }

    public StringComparator(boolean ascending, boolean caseSensitive) {
        this(ascending, caseSensitive, 0);
    }

    public StringComparator(boolean ascending, boolean caseSensitive, int startChar) {
        this.setAscending(ascending);
        this.setStartChar(startChar);
        this.setCaseSensitive(caseSensitive);
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        if (this.ascending != ascending) {
            this.ascending = ascending;
            this.firePropertyChange("ascending", this.ascending);
        }
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        if (this.collator != null) {
            this.collator.setStrength(caseSensitive ? 2 : 0);
        }
        if (this.caseSensitive != caseSensitive) {
            this.caseSensitive = caseSensitive;
            this.firePropertyChange("caseSensitive", this.caseSensitive);
        }
    }

    void firePropertyChange(String propertyName, boolean newValue) {
        if (newValue) {
            this.firePropertyChange(propertyName, Boolean.FALSE, Boolean.TRUE);
        } else {
            this.firePropertyChange(propertyName, Boolean.TRUE, Boolean.FALSE);
        }
    }

    public void setCollator(Collator newCollator) {
        if (Util.equal((Object)this.collator, (Object)newCollator)) {
            return;
        }
        Collator oldCollator = this.collator;
        this.collator = newCollator;
        this.firePropertyChange("collator", oldCollator, this.collator);
    }

    public Collator getCollator() {
        return this.collator;
    }

    public int getStartChar() {
        return this.startChar;
    }

    public void setStartChar(int startChar) {
        if (startChar < 0) {
            throw new IllegalArgumentException("startChar < 0");
        }
        if (this.startChar != startChar) {
            Integer oldVal = new Integer(this.startChar);
            Integer newVal = new Integer(startChar);
            this.startChar = startChar;
            this.firePropertyChange("startChar", oldVal, newVal);
        }
    }

    public int compare(Object first, Object second) {
        int result;
        if (first == second) {
            return 0;
        }
        if (first == null) {
            return this.ascending ? -1 : 1;
        }
        if (second == null) {
            return this.ascending ? 1 : -1;
        }
        if (!(first instanceof String) || !(second instanceof String)) {
            return this.compare(first.toString(), second.toString());
        }
        String a = (String)first;
        String b = (String)second;
        if (this.startChar > 0) {
            if ((a = a.length() < this.startChar ? null : a.substring(this.startChar)) == (b = b.length() < this.startChar ? null : b.substring(this.startChar))) {
                return 0;
            }
            if (a == null) {
                return this.ascending ? -1 : 1;
            }
            if (b == null) {
                return this.ascending ? 1 : -1;
            }
        }
        if ((result = this.collator != null ? this.collator.compare(a, b) : (this.caseSensitive ? a.compareTo(b) : a.toLowerCase().compareTo(b.toLowerCase()))) < 0) {
            result = this.ascending ? -1 : 1;
        } else if (result > 0) {
            result = this.ascending ? 1 : -1;
        }
        return result;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return "ascending: " + this.ascending + ", caseSensitive:" + this.caseSensitive + ", startChar:" + this.startChar + " StringComparator ";
    }
}

