/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.text.Message;
import com.sas.util.RB;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessControlException;
import java.text.DecimalFormat;
import java.util.Date;
import javax.swing.JOptionPane;

public class ResourceCopier {
    public static final String RB_KEY = "ResourceCopier.";
    private static final int WEBAF = 1;
    private static final int WEBEIS = 2;
    private static final int RUNTIME = 3;
    protected boolean _promptForReplace = true;
    protected boolean _promptForCopy = true;
    protected String _destinationDir;

    public ResourceCopier() {
        int mode = this.getMode();
        this._destinationDir = mode == 1 ? new String(System.getProperty("webaf.project.directory")) : (mode == 2 ? new String(System.getProperty("webeis.document.directory")) : new String(System.getProperty("user.dir")));
    }

    public ResourceCopier(String destDir) {
        this();
        this.setDestinationDir(destDir);
    }

    private int getMode() {
        try {
            String webAFdir = System.getProperty("webaf.project.directory");
            if (webAFdir != null && webAFdir.length() != 0) {
                return 1;
            }
        }
        catch (AccessControlException webAFdir) {
            // empty catch block
        }
        try {
            String webEISdir = System.getProperty("webeis.document.directory");
            if (webEISdir != null && webEISdir.length() != 0) {
                return 2;
            }
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        return 3;
    }

    public void setDestinationDir(String newValue) {
        if (!this._destinationDir.equals(newValue)) {
            this._destinationDir = newValue;
        }
    }

    public String getDestinationDir() {
        return this._destinationDir;
    }

    public void setPromptForCopy(boolean newValue) {
        if (this._promptForCopy != newValue) {
            this._promptForCopy = newValue;
        }
    }

    public boolean getPromptForCopy() {
        return this._promptForCopy;
    }

    public void setPromptForReplace(boolean newValue) {
        if (this._promptForReplace != newValue) {
            this._promptForReplace = newValue;
        }
    }

    public boolean getPromptForReplace() {
        return this._promptForReplace;
    }

    public File copyFile(String src) {
        File srcFile = this.createSourceFile(src);
        return this.copyFile(srcFile);
    }

    public File copyFile(File src) {
        return this.copyFile(src, this.getDestinationDir());
    }

    public File copyFile(File src, String destDir) {
        File destFile = new File(destDir + File.separator + src.getName());
        if (src.compareTo(destFile) == 0) {
            System.out.println("Same File");
            return src;
        }
        if (destFile.exists() && this.getPromptForReplace()) {
            String srcInfo = "";
            String destInfo = "";
            try {
                long srcSize = src.length();
                Date srcDate = new Date(src.lastModified());
                long destSize = destFile.length();
                Date destDate = new Date(destFile.lastModified());
                DecimalFormat format = new DecimalFormat("#.##");
                srcInfo = "     " + format.format((double)srcSize / 1024.0) + "KB " + RB.getStringResource((String)RB_KEY, (String)"modifiedOn.txt") + " " + srcDate;
                destInfo = "     " + format.format((double)destSize / 1024.0) + "KB " + RB.getStringResource((String)RB_KEY, (String)"modifiedOn.txt") + " " + destDate;
            }
            catch (SecurityException srcSize) {
                // empty catch block
            }
            String type = RB.getStringResource((String)RB_KEY, (String)"webAFProject.txt");
            if (this.getMode() == 2) {
                type = RB.getStringResource((String)RB_KEY, (String)"webEISDocument.txt");
            }
            int button = JOptionPane.showOptionDialog(null, Message.format((String)RB.getStringResource((String)RB_KEY, (String)"fileCopyMessage.txt"), (Object)type, (Object)src.getAbsolutePath(), (Object)destDir) + "\n\n" + Message.format((String)RB.getStringResource((String)RB_KEY, (String)"fileReplaceMessage.txt"), (Object)(destDir + File.separator), (Object)src.getName(), (Object)src.getAbsolutePath(), (Object)srcInfo, (Object)destInfo), RB.getStringResource((String)RB_KEY, (String)"fileReplaceTitle.txt"), 1, 2, null, null, null);
            switch (button) {
                case 0: {
                    break;
                }
                case 1: {
                    return destFile;
                }
                case 2: {
                    return null;
                }
            }
        } else if (this.getPromptForCopy()) {
            String type;
            int mode = this.getMode();
            if (mode == 2) {
                type = RB.getStringResource((String)RB_KEY, (String)"webEISDocument.txt");
                int button = JOptionPane.showOptionDialog(null, Message.format((String)RB.getStringResource((String)RB_KEY, (String)"fileCopyMessage.txt"), (Object)type) + "\n\n" + Message.format((String)RB.getStringResource((String)RB_KEY, (String)"fileCopyMessage2.txt"), (Object)src.getAbsolutePath(), (Object)destFile.getAbsolutePath()), RB.getStringResource((String)RB_KEY, (String)"fileCopyTitle.txt"), 2, 2, null, null, null);
                switch (button) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        return null;
                    }
                }
            } else {
                type = RB.getStringResource((String)RB_KEY, (String)"webAFProject.txt");
                int button = JOptionPane.showOptionDialog(null, Message.format((String)RB.getStringResource((String)RB_KEY, (String)"fileCopyMessage.txt"), (Object)type) + "\n\n" + Message.format((String)RB.getStringResource((String)RB_KEY, (String)"fileCopyMessage2.txt"), (Object)src.getAbsolutePath(), (Object)destFile.getAbsolutePath()), RB.getStringResource((String)RB_KEY, (String)"fileCopyTitle.txt"), 1, 2, null, null, null);
                switch (button) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        return src;
                    }
                    case 2: {
                        return null;
                    }
                }
            }
        }
        try {
            FileInputStream fi = new FileInputStream(src);
            FileOutputStream fo = new FileOutputStream(destFile);
            int len = new Long(src.length()).intValue();
            byte[] b = new byte[len];
            fi.read(b, 0, len);
            fo.write(b, 0, len);
            fi.close();
            fo.close();
        }
        catch (IOException ie) {
            ie.printStackTrace();
            return null;
        }
        return destFile;
    }

    private File createSourceFile(String src) {
        File temp = new File(src);
        if (temp.getAbsolutePath().toUpperCase().indexOf(src.toUpperCase()) != 0) {
            temp = new File(this.getDestinationDir() + File.separator + src);
        }
        return temp;
    }
}

