/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.security.BaseSecuritySupport;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;

public class PropertySerializer
implements Serializable {
    static final long serialVersionUID = -3928067674396745845L;
    private Vector properties;
    private String objectClass;

    public void setObject(Object comp) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        this.properties = new Vector();
        this.objectClass = comp.getClass().getName();
        BeanInfo bi = Introspector.getBeanInfo(comp.getClass());
        PropertyDescriptor[] pd = bi.getPropertyDescriptors();
        for (int i = 0; i < pd.length; ++i) {
            Method rm;
            if (pd[i].getName().compareTo("menuBar") == 0 || (rm = pd[i].getReadMethod()) == null) continue;
            Method wm = pd[i].getWriteMethod();
            Class[] pt = BaseSecuritySupport.securitySupport.getMethodParameterTypes(rm);
            if (pt.length != 0 || wm == null) continue;
            Object value = BaseSecuritySupport.securitySupport.invokeMethod(rm, comp, null);
            if (value == null || value instanceof Serializable) {
                Property p = new Property();
                p.propertyWriteMethod = BaseSecuritySupport.securitySupport.getMethodName(wm);
                p.propertyValue = value;
                p.propertyName = pd[i].getName();
                this.properties.addElement(p);
                continue;
            }
            System.out.println(pd[i].getName() + " not serializable");
        }
    }

    public void updateObject(Object comp) throws ClassNotFoundException, IntrospectionException, ClassCastException, IllegalAccessException, InvocationTargetException {
        Class<?> oClass = Class.forName(this.objectClass);
        if (comp.getClass().equals(oClass)) {
            BeanInfo bi = Introspector.getBeanInfo(comp.getClass());
            PropertyDescriptor[] pd = bi.getPropertyDescriptors();
            Enumeration e = this.properties.elements();
            while (e.hasMoreElements()) {
                Property p = (Property)e.nextElement();
                Object[] args = new Object[]{p.propertyValue};
                Method wm = null;
                for (int i = 0; i < pd.length; ++i) {
                    if (p.propertyName.compareTo(pd[i].getName()) == 0 && p.propertyWriteMethod.compareTo((wm = pd[i].getWriteMethod()).getName()) != 0) {
                        wm = null;
                    }
                    if (wm != null) break;
                }
                if (wm != null) {
                    wm.invoke(comp, args);
                    continue;
                }
                System.out.println("No write method for " + p.propertyName);
            }
        } else {
            throw new ClassCastException("Class does not match serialized class");
        }
    }

    public void updateSafeObject(Object comp) throws IntrospectionException, ClassCastException, IllegalAccessException, InvocationTargetException {
        BeanInfo bi = Introspector.getBeanInfo(comp.getClass());
        PropertyDescriptor[] pd = bi.getPropertyDescriptors();
        Enumeration e = this.properties.elements();
        while (e.hasMoreElements()) {
            Property p = (Property)e.nextElement();
            Method wm = null;
            for (int i = 0; i < pd.length; ++i) {
                if (p.propertyName.compareTo(pd[i].getName()) == 0) {
                    wm = pd[i].getWriteMethod();
                    if (p.propertyWriteMethod.compareTo(wm.getName()) != 0) {
                        wm = null;
                    } else {
                        Class<?>[] pt = wm.getParameterTypes();
                        if (pt != null && pt.length == 1) {
                            if (p.propertyValue != null && !pt[0].isPrimitive() && !pt[0].isAssignableFrom(p.propertyValue.getClass())) {
                                wm = null;
                            }
                        } else {
                            wm = null;
                        }
                    }
                }
                if (wm != null) break;
            }
            if (wm == null) continue;
            Object[] args = new Object[]{p.propertyValue};
            wm.invoke(comp, args);
        }
    }

    class Property
    implements Serializable {
        String propertyWriteMethod;
        String propertyName;
        Object propertyValue;

        Property() {
        }

        public String toString() {
            if (this.propertyValue != null) {
                return this.propertyWriteMethod + ";" + this.propertyName + ";" + this.propertyValue.toString();
            }
            return this.propertyWriteMethod + ";" + this.propertyName + "; null";
        }
    }
}

