/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.models.SimpleNodeInterface;
import com.sas.models.TreeInterface;
import com.sas.util.TreeIterator;
import java.util.NoSuchElementException;

public class PreorderTreeIterator
extends TreeIterator {
    private transient int m_index;
    private transient SimpleNodeInterface m_node;
    private transient NodeInfo m_parentStack;

    public PreorderTreeIterator(TreeInterface tree) {
        super(tree);
        this.m_node = tree.getRoot();
    }

    @Override
    public boolean hasMoreNodes() {
        return this.getNode() != null;
    }

    @Override
    public SimpleNodeInterface nextNode() {
        SimpleNodeInterface node;
        block6: {
            node = this.getNode();
            if (node == null) {
                throw new NoSuchElementException();
            }
            if (!node.isLeafNode() && node.countNodeChildren(1) >= 1) {
                this.pushParent(node);
                this.m_node = node.getNodeChild(0);
            } else {
                NodeInfo parent;
                while (true) {
                    if ((parent = this.m_parentStack) == null) {
                        this.m_node = null;
                        break block6;
                    }
                    ++parent.pos;
                    if (parent.node.countNodeChildren(parent.pos + 1) > parent.pos) break;
                    this.popParent();
                }
                this.m_node = parent.node.getNodeChild(parent.pos);
            }
        }
        if (this.m_node != null) {
            ++this.m_index;
        }
        return node;
    }

    @Override
    public final boolean hasMoreElements() {
        return this.hasMoreNodes();
    }

    public final Object nextElement() {
        return this.nextNode();
    }

    @Override
    public void reset() {
        this.m_node = this.getTree().getRoot();
        this.m_index = 0;
        this.m_parentStack = null;
    }

    @Override
    public SimpleNodeInterface getNode() {
        return this.m_node;
    }

    @Override
    public SimpleNodeInterface[] getNodeParents() {
        int count = 0;
        NodeInfo p = this.m_parentStack;
        while (p != null) {
            ++count;
            p = p.prev;
        }
        SimpleNodeInterface[] parents = new SimpleNodeInterface[count];
        int i = parents.length;
        p = this.m_parentStack;
        while (p != null) {
            parents[--i] = p.node;
            p = p.prev;
        }
        return parents;
    }

    @Override
    public int getNodeIndex() {
        return this.m_index;
    }

    private void pushParent(SimpleNodeInterface node) {
        this.m_parentStack = new NodeInfo(this.m_parentStack, node, 0);
    }

    private void popParent() {
        if (this.m_parentStack != null) {
            this.m_parentStack = this.m_parentStack.prev;
        }
    }

    private final class NodeInfo {
        NodeInfo prev;
        SimpleNodeInterface node;
        int pos;

        NodeInfo(NodeInfo prev, SimpleNodeInterface node, int pos) {
            this.prev = prev;
            this.node = node;
            this.pos = pos;
        }
    }
}

