/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.Component;
import com.sas.PublicClonable;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.models.BoundedNumberInterface;
import com.sas.util.IntegerRangeInterface;

public class IntegerRange
extends Component
implements IntegerRangeInterface,
PublicClonable,
BoundedNumberInterface {
    static final long serialVersionUID = -6380744443557295757L;
    private int blockIncrement;
    private int unitIncrement;
    private int minimum;
    private int maximum;
    private int value;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "blockIncrement"}, {"Default value", "10"}, {"Short description", "block increment"}, {"Description", "Block amount the value increments"}}, {{"Name", "maximum"}, {"Default value", "100"}, {"Short description", "maximum"}, {"Description", "Maximum amount of range value"}}, {{"Name", "minimum"}, {"Default value", "0"}, {"Short description", "minimum"}, {"Description", "Minimum amount of range value"}}, {{"Name", "unitIncrement"}, {"Default value", "1"}, {"Short description", "unit increment"}, {"Description", "Unit amount the value increments"}}, {{"Name", "value"}, {"Default value", "0"}, {"Short description", "value"}, {"Description", "Value of range"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "value";
        ebi.defaultOutputPropertyName = "value";
        ebi.shortDescription = "Integer constrained within a range";
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public IntegerRange() {
        this.initializeComponent();
    }

    public IntegerRange(int value, int min, int max, int unit, int block) {
        this.initializeComponent();
        this.setValues(value, min, max, unit, block);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof IntegerRange) {
            return this.equals((IntegerRange)object);
        }
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Object clone = super.clone();
        IntegerRange range = (IntegerRange)clone;
        range.setValues(this.getValue(), this.getMinimum(), this.getMaximum(), this.getUnitIncrement(), this.getBlockIncrement());
        return range;
    }

    public boolean equals(IntegerRange otherRange) {
        if (otherRange == null) {
            return false;
        }
        return this.getMinimum() == otherRange.getMinimum() && this.getValue() == otherRange.getValue() && this.getMaximum() == otherRange.getMaximum() && this.getBlockIncrement() == otherRange.getBlockIncrement() && this.getUnitIncrement() == otherRange.getUnitIncrement();
    }

    public String toString() {
        return "[" + this.getMinimum() + "," + this.getValue() + "," + this.getMaximum() + "]," + this.getUnitIncrement() + "," + this.getBlockIncrement();
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.blockIncrement = 10;
        this.unitIncrement = 1;
        this.maximum = 100;
        this.minimum = 0;
        this.value = 0;
    }

    @Override
    public int getMaximum() {
        return this.maximum;
    }

    @Override
    public int getMinimum() {
        return this.minimum;
    }

    @Override
    public int getBlockIncrement() {
        return this.blockIncrement;
    }

    @Override
    public int getUnitIncrement() {
        return this.unitIncrement;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public Number incrementBy(int increment, int incrementType) {
        int incrementAmount = incrementType == 0 ? this.getUnitIncrement() : this.getBlockIncrement();
        if (this.getValue() == this.getMinimum() && increment < 0 || this.getValue() == this.getMaximum() && increment > 0) {
            return this.getNumberValue();
        }
        int incrementValue = increment * incrementAmount;
        int newValue = this.getValue() + incrementValue;
        int closestMinValue = this.getMinimum() - incrementValue;
        int closestMaxValue = this.getMaximum() - incrementValue;
        if (this.getValue() < closestMinValue && increment < 0) {
            this.setValue(this.getMinimum());
        } else if (this.getValue() > closestMaxValue && increment > 0) {
            this.setValue(this.getMaximum());
        } else {
            this.setValue(newValue);
        }
        return this.getNumberValue();
    }

    @Override
    public void setMaximum(int max) {
        if (max < this.minimum) {
            throw new IllegalArgumentException("max < min");
        }
        if (max != this.getMaximum()) {
            int oldMax = this.maximum;
            this.maximum = max;
            this.firePropertyChange("maximum", new Integer(oldMax), new Integer(this.maximum));
            if (this.value > max) {
                this.setValue(max);
            }
        }
    }

    @Override
    public void setMinimum(int min) {
        if (min > this.maximum) {
            throw new IllegalArgumentException("min > max");
        }
        if (min != this.getMinimum()) {
            int oldMin = this.minimum;
            this.minimum = min;
            this.firePropertyChange("minimum", new Integer(oldMin), new Integer(this.minimum));
            if (this.value < min) {
                this.setValue(min);
            }
        }
    }

    @Override
    public void setBlockIncrement(int block) {
        int range = this.maximum - this.minimum;
        if (block < 0) {
            throw new IllegalArgumentException("block < 0");
        }
        if (range > 0 && block > range) {
            throw new IllegalArgumentException("block > range");
        }
        if (block != this.getBlockIncrement()) {
            int oldBlockIncrement = this.blockIncrement;
            this.blockIncrement = block;
            this.firePropertyChange("blockIncrement", new Integer(oldBlockIncrement), new Integer(this.blockIncrement));
        }
    }

    @Override
    public void setUnitIncrement(int unit) {
        int range = this.maximum - this.minimum;
        if (unit < 0) {
            throw new IllegalArgumentException("unit < 0");
        }
        if (range > 0 && unit > range) {
            throw new IllegalArgumentException("unit > range");
        }
        if (unit != this.getUnitIncrement()) {
            int oldUnitIncrement = this.unitIncrement;
            this.unitIncrement = unit;
            this.firePropertyChange("unitIncrement", new Integer(oldUnitIncrement), new Integer(this.unitIncrement));
        }
    }

    @Override
    public void setValue(int newValue) {
        if (newValue != this.getValue()) {
            int oldValue = this.value;
            this.value = newValue > this.getMaximum() ? this.getMaximum() : (newValue < this.getMinimum() ? this.getMinimum() : newValue);
            this.firePropertyChange("value", new Integer(oldValue), new Integer(this.value));
        }
    }

    @Override
    public void setValues(int value, int min, int max) {
        this.setValues(value, min, max, this.unitIncrement, this.blockIncrement);
    }

    @Override
    public void setValues(int value, int min, int max, int unit, int block) {
        int oldMin = this.minimum;
        int oldMax = this.maximum;
        int oldValue = this.value;
        int oldUnit = this.unitIncrement;
        int oldBlock = this.unitIncrement;
        if (value < min) {
            value = min;
        } else if (value > max) {
            value = max;
        }
        int range = max - min;
        if (min > max) {
            throw new IllegalArgumentException("min > max");
        }
        if (unit < 0) {
            throw new IllegalArgumentException("unit < 0");
        }
        if (block < 0) {
            throw new IllegalArgumentException("block < 0");
        }
        if (range > 0 && unit > range) {
            throw new IllegalArgumentException("unit > range");
        }
        if (range > 0 && block > range) {
            throw new IllegalArgumentException("block > range");
        }
        this.value = value;
        this.unitIncrement = unit;
        this.blockIncrement = block;
        this.maximum = max;
        this.minimum = min;
        if (oldValue != value) {
            this.firePropertyChange("value", new Integer(oldValue), new Integer(value));
        }
        if (oldMax != this.maximum) {
            this.firePropertyChange("maximum", new Integer(oldMax), new Integer(this.maximum));
        }
        if (oldMin != this.minimum) {
            this.firePropertyChange("minimum", new Integer(oldMin), new Integer(this.minimum));
        }
        if (oldUnit != this.unitIncrement) {
            this.firePropertyChange("unitIncrement", new Integer(oldUnit), new Integer(this.unitIncrement));
        }
        if (oldBlock != this.blockIncrement) {
            this.firePropertyChange("blockIncrement", new Integer(oldBlock), new Integer(this.blockIncrement));
        }
    }

    @Override
    public Number getMaximumNumber() {
        return new Integer(this.getMaximum());
    }

    @Override
    public Number getMinimumNumber() {
        return new Integer(this.getMinimum());
    }

    @Override
    public Number getBlockIncrementNumber() {
        return new Integer(this.getBlockIncrement());
    }

    @Override
    public Number getUnitIncrementNumber() {
        return new Integer(this.getUnitIncrement());
    }

    @Override
    public Number getNumberValue() {
        return new Integer(this.getValue());
    }

    @Override
    public void setMaximumNumber(Number max) {
        this.setMaximum(max.intValue());
    }

    @Override
    public void setMinimumNumber(Number min) {
        this.setMinimum(min.intValue());
    }

    @Override
    public void setBlockIncrementNumber(Number block) {
        this.setBlockIncrement(block.intValue());
    }

    @Override
    public void setUnitIncrementNumber(Number unit) {
        this.setUnitIncrement(unit.intValue());
    }

    @Override
    public void setNumberValue(Number newValue) {
        this.setValue(newValue.intValue());
    }

    @Override
    public void setNumberValues(Number newValue, Number min, Number max) {
        this.setValues(newValue.intValue(), min.intValue(), max.intValue(), this.unitIncrement, this.blockIncrement);
    }

    @Override
    public void setNumberValues(Number newValue, Number min, Number max, Number unit, Number block) {
        this.setValues(newValue.intValue(), min.intValue(), max.intValue(), unit.intValue(), block.intValue());
    }
}

