/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.applet.AudioClip;
import java.awt.Button;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class AppletHost
extends Frame
implements AppletStub,
AppletContext,
ActionListener {
    static final long serialVersionUID = 1520319457200582336L;
    protected TextField status;
    protected Button startButton;
    protected Button stopButton;
    protected Hashtable params = new Hashtable();
    protected Vector applets = new Vector();
    protected int initial_width;
    protected int initial_height;

    public static void main(String[] args) {
        new AppletHost(args);
    }

    public AppletHost(Applet applet, String[] args) {
        this(applet, 640, 480, args);
    }

    public AppletHost(Applet applet, int default_width, int default_height, String[] args) {
        super(applet.getClass().getName());
        this.init(applet, default_width, default_height, args, 0);
    }

    public AppletHost(String appletClassName, int default_width, int default_height, String[] args) {
        super(appletClassName);
        try {
            Applet applet = (Applet)Class.forName(appletClassName).newInstance();
            this.init(applet, default_width, default_height, args, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public AppletHost(String[] args) {
        super(args[0]);
        try {
            Applet applet = (Applet)Class.forName(args[0]).newInstance();
            this.init(applet, 640, 480, args, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void init(Applet applet, int default_width, int default_height, String[] args, int startidx) {
        this.applets.addElement(applet);
        applet.setStub(this);
        this.initial_width = default_width;
        this.initial_height = default_height;
        this.parseArgs(args, startidx);
        this.status = new TextField();
        this.status.setEditable(false);
        this.startButton = new Button("Start");
        this.startButton.addActionListener(this);
        this.stopButton = new Button("Stop");
        this.stopButton.addActionListener(this);
        Panel p = new Panel();
        GridBagLayout gbl = new GridBagLayout();
        p.setLayout(gbl);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 0.0;
        c.ipady = 10;
        gbl.setConstraints(this.startButton, c);
        gbl.setConstraints(this.stopButton, c);
        c.weightx = 1.0;
        c.fill = 2;
        c.gridwidth = 0;
        gbl.setConstraints(this.status, c);
        p.add(this.startButton);
        p.add(this.stopButton);
        p.add(this.status);
        this.add("Center", applet);
        this.add("South", p);
        this.appletResize(this.initial_width, this.initial_height);
        this.show();
        applet.init();
        this.validate();
        applet.start();
        this.enableEvents(64L);
    }

    public void parseArgs(String[] args, int startidx) {
        for (int idx = startidx; idx < args.length - startidx; idx += 2) {
            try {
                if (args[idx].equals("-width")) {
                    this.initial_width = Integer.parseInt(args[idx + 1]);
                    continue;
                }
                if (args[idx].equals("-height")) {
                    this.initial_height = Integer.parseInt(args[idx + 1]);
                    continue;
                }
                int pos = args[idx].indexOf("=");
                if (pos > 0) {
                    if (args[idx].startsWith("-")) {
                        args[idx] = args[idx].substring(1);
                        --pos;
                    }
                    this.params.put(args[idx].substring(0, pos), args[idx].substring(pos + 1));
                    continue;
                }
                if (idx + 1 >= args.length - startidx) continue;
                this.params.put(args[idx], args[idx + 1]);
                continue;
            }
            catch (NumberFormatException nfe) {
                System.err.println("Warning: command line argument " + args[idx] + " is not a valid number.");
            }
        }
    }

    @Override
    public void processWindowEvent(WindowEvent evt) {
        super.processWindowEvent(evt);
        if (evt.getID() == 201) {
            System.exit(0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        block3: {
            block2: {
                if (evt.getSource() != this.startButton) break block2;
                for (int i = 0; i < this.applets.size(); ++i) {
                    ((Applet)this.applets.elementAt(i)).start();
                }
                break block3;
            }
            if (evt.getSource() != this.stopButton) break block3;
            for (int i = 0; i < this.applets.size(); ++i) {
                ((Applet)this.applets.elementAt(i)).stop();
            }
        }
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public URL getDocumentBase() {
        URL url = null;
        try {
            File dummy = new File("dummy.html");
            String path = dummy.getAbsolutePath();
            if (!File.separator.equals("/")) {
                StringBuffer buffer = new StringBuffer();
                if (path.charAt(0) != File.separator.charAt(0)) {
                    buffer.append("/");
                }
                StringTokenizer st = new StringTokenizer(path, File.separator);
                while (st.hasMoreTokens()) {
                    buffer.append(st.nextToken() + "/");
                }
                if (File.separator.equals("\\") && buffer.charAt(2) == ':') {
                    buffer.setCharAt(2, '|');
                }
                path = buffer.toString();
                path = path.substring(0, path.length() - 1);
            }
            url = new URL("file", "", -1, path);
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
        }
        return url;
    }

    @Override
    public final URL getCodeBase() {
        return this.getDocumentBase();
    }

    @Override
    public final String getParameter(String name) {
        return (String)this.params.get(name);
    }

    @Override
    public final AppletContext getAppletContext() {
        return this;
    }

    @Override
    public void appletResize(int width, int height) {
        Insets insets = this.getInsets();
        this.setSize(width + insets.left + insets.right, height + this.status.getPreferredSize().height + insets.top + insets.bottom);
    }

    @Override
    public final AudioClip getAudioClip(URL url) {
        return null;
    }

    @Override
    public final Image getImage(URL url) {
        return Toolkit.getDefaultToolkit().getImage(url);
    }

    @Override
    public final Applet getApplet(String name) {
        return null;
    }

    public final Enumeration getApplets() {
        return this.applets.elements();
    }

    @Override
    public void showDocument(URL url) {
        this.status.setText("AppletContext request to show URL " + url.toString());
    }

    @Override
    public void showDocument(URL url, String target) {
        this.status.setText("AppletContext request to show URL " + url.toString() + " in target: " + target);
    }

    @Override
    public void showStatus(String text) {
        this.status.setText(text);
    }

    @Override
    public InputStream getStream(String key) {
        return null;
    }

    public Iterator getStreamKeys() {
        return null;
    }

    @Override
    public void setStream(String key, InputStream stream) {
    }
}

