/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools;

public class ClassName {
    private String packageName;
    private String className;
    private String fullyQualifiedName;

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    public ClassName(String name) {
        this.fullyQualifiedName = name;
        int dot = name.lastIndexOf(46);
        if (dot == -1) {
            this.packageName = "";
            this.className = name;
        } else {
            this.packageName = name.substring(0, dot);
            this.className = name.substring(dot + 1);
        }
    }

    public ClassName(String packageName, String className) {
        this.packageName = packageName;
        this.className = className;
        if (packageName == null || packageName.length() == 0) {
            this.fullyQualifiedName = className;
            packageName = "";
        } else {
            this.fullyQualifiedName = packageName + "." + className;
        }
    }

    public String getImportStatement() {
        return "import " + this.fullyQualifiedName + ";";
    }

    public String getPackageStatement() {
        if (this.packageName.length() == 0) {
            return "";
        }
        return "package " + this.packageName + ";";
    }

    public String toString() {
        return this.fullyQualifiedName;
    }

    public String toString(boolean qualified) {
        if (qualified) {
            return this.fullyQualifiedName;
        }
        return this.className;
    }
}

