/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage;

import com.sas.Component;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.beans.Util;
import com.sas.sasserver.datawizard.StackChecker;
import com.sas.storage.RB;
import com.sas.table.TableNavigationV2Interface;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;

public abstract class BaseDataBean
extends Component
implements TableNavigationV2Interface {
    public static final String RB_KEY = "BaseDataBean.";
    protected static final int NEXTSUPPORTED = 0;
    protected static final int PREVIOUSSUPPORTED = 1;
    protected static final int FIRSTSUPPORTED = 2;
    protected static final int LASTSUPPORTED = 3;
    protected static final int COMMITSUPPORTED = 4;
    protected static final int INSERTSUPPORTED = 5;
    protected static final int DELETESUPPORTED = 6;
    protected static final int CANCELSUPPORTED = 7;
    protected static final int REFRESHSUPPORTED = 8;
    protected static final int PAGEFORWARDSUPPORTED = 9;
    protected static final int PAGEBACKWARDSUPPORTED = 10;
    protected transient boolean[] supported = new boolean[11];
    public static int COLUMNMAP_PROPERTY_NAME = 0;
    public static int COLUMNMAP_COLUMN_NAME = 1;
    public static int COLUMNMAP_COLUMN_TYPE = 2;
    public static int COLUMNMAP_COLUMN_INDEX = 3;
    public static int COLUMNMAP_FORMATTED_PROPERTY_NAME = 4;
    public static int COLUMNMAP_BASEDATABEAN_FUTURES = 5;
    public static int COLUMNMAP_USERBASE = 6;
    protected boolean atBeginning;
    protected boolean atEnd;
    protected boolean badState;
    protected boolean commitWithUpdate;
    protected boolean dataNeedsCommit;
    protected boolean delayCommit;
    protected boolean isDesignTime = Util.isDesignTime();
    protected boolean initialized;
    protected boolean calledFromExecuteQuery;
    protected boolean calledFromInit;
    protected boolean calledFromFireAll;
    protected boolean setBadState;
    protected int autoCommitLevel;
    protected int pageSize;
    protected int resultSetConcurrency;
    protected int resultSetType;
    protected String queryStatement;
    protected SQLException statusException;
    protected transient Connection dataSource;
    protected transient ResultSet results;
    protected transient Statement statement;
    protected transient StackChecker _stackChecker;
    protected boolean isOnInsertRow;
    protected boolean endOfForwardOnlyResultSet;
    protected boolean cursorValid;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "statement"}, {"Expert", "true"}}, {{"Name", "rowValues"}, {"Expert", "true"}}, {{"Name", "pageSize"}, {"Expert", "true"}}, {{"Name", "statusException"}, {"Expert", "true"}}, {{"Name", "autoCommitLevel"}, {"Expert", "true"}}, {{"Name", "resultSetType"}, {"Expert", "true"}}, {{"Name", "resultSetConcurrency"}, {"Expert", "true"}}, {{"Name", "pageBackwardSupported"}, {"Hidden", "true"}}, {{"Name", "pageForwardSupported"}, {"Hidden", "true"}}, {{"Name", "lastSupported"}, {"Hidden", "true"}}, {{"Name", "firstSupported"}, {"Hidden", "true"}}, {{"Name", "insertSupported"}, {"Hidden", "true"}}, {{"Name", "deleteSupported"}, {"Hidden", "true"}}, {{"Name", "cancelSupported"}, {"Hidden", "true"}}, {{"Name", "commitSupported"}, {"Hidden", "true"}}, {{"Name", "previousSupported"}, {"Hidden", "true"}}, {{"Name", "nextSupported"}, {"Hidden", "true"}}, {{"Name", "row"}, {"Expert", "true"}}, {{"Name", "rowCount"}, {"Expert", "true"}}, {{"Name", "refreshSupported"}, {"Hidden", "true"}}, {{"Name", "modified"}, {"Expert", "true"}}, {{"Name", "modelInterface"}, {"Hidden", "true"}}, {{"Name", "dataSource"}, {"Property editor class", "com.sas.beans.editors._InstanceEditor"}}, {{"Name", "resultSetType"}, {"Property editor class", "com.sas.beans.editors._BaseDataBeanResultSetTypeEditor"}}, {{"Name", "resultSetConcurrency"}, {"Property editor class", "com.sas.beans.editors._BaseDataBeanResultSetConcurEditor"}}, {{"Name", "autoCommitLevel"}, {"Property editor class", "com.sas.beans.editors._BaseDataBeanCommitLevelEditor"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "queryStatement";
        ebi.defaultOutputPropertyName = "queryStatement";
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public BaseDataBean() {
        this.resultSetConcurrency = 1007;
        this.initializeData();
    }

    public BaseDataBean(Connection dataSource, int resultSetConcurrency) throws SQLException {
        this.dataSource = dataSource;
        this.resultSetConcurrency = resultSetConcurrency;
        this.firePropertyChange("dataSource", null, dataSource);
        this.firePropertyChange("cursorValid", null, Boolean.FALSE);
        this.initializeData();
    }

    public BaseDataBean(Connection dataSource) throws SQLException {
        this(dataSource, 1007);
    }

    public BaseDataBean(Connection dataSource, String queryStatement, int resultSetConcurrency) throws SQLException {
        this(dataSource, resultSetConcurrency);
        this.queryStatement = queryStatement;
    }

    public BaseDataBean(Connection dataSource, String queryStatement) throws SQLException {
        this(dataSource, queryStatement, 1007);
    }

    public void setDataSource(Connection dataSource, int resultSetConcurrency) throws SQLException {
        this.badState = false;
        Connection oldDataSource = this.dataSource;
        if (com.sas.util.Util.unequal((Object)oldDataSource, (Object)dataSource)) {
            this.dataSource = dataSource;
            this.firePropertyChange("dataSource", oldDataSource, dataSource);
        }
        if (!this.isDesignTime) {
            if (this.dataNeedsCommit) {
                this.commitData(1);
                if (this.dataNeedsCommit) {
                    throw new IllegalStateException(RB.getStringResource(RB_KEY, "ModifiedDataNotCommited.txt"));
                }
            }
            this.initialized = false;
        }
    }

    public void setDataSource(Connection dataSource) throws SQLException {
        this.setDataSource(dataSource, this.getResultSetConcurrency());
    }

    protected void initializeResults() throws SQLException {
        this.badState = false;
        if (this.dataNeedsCommit) {
            this.commitData(1);
            if (this.dataNeedsCommit) {
                throw new IllegalStateException(RB.getStringResource(RB_KEY, "ModifiedDataNotCommited.txt"));
            }
        }
    }

    public Connection getDataSource() {
        return this.dataSource;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
        this.initialized = false;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public boolean executeQuery() {
        return this.executeQuery(this.queryStatement);
    }

    public boolean executeQuery(String queryStatement) {
        if (!this.initialized && !this.calledFromInit) {
            this.calledFromExecuteQuery = false;
            try {
                this.init();
            }
            catch (SQLException e) {
                this._fireAll();
                this.setStatusException(e);
                return false;
            }
        } else {
            this.calledFromExecuteQuery = this.initialized && !this.calledFromInit;
        }
        this.badState = false;
        if (this.dataNeedsCommit) {
            this.commitData(1);
            if (this.dataNeedsCommit) {
                throw new IllegalStateException(RB.getStringResource(RB_KEY, "ModifiedDataNotCommited.txt"));
            }
        }
        if (!this.initialized && this.calledFromInit || this.initialized && this.calledFromExecuteQuery) {
            try {
                if (queryStatement == null) {
                    queryStatement = "";
                }
                this.results = this.statement.executeQuery(queryStatement);
                this.atEnd = false;
                this.endOfForwardOnlyResultSet = false;
                this.cursorValid = false;
                this.firePropertyChange("cursorValid", null, Boolean.FALSE);
                if (this.calledFromInit) {
                    this.initialized = true;
                }
                this.next();
                if (this.calledFromInit) {
                    this.initialized = false;
                }
                this.setQueryStatement(queryStatement);
                return true;
            }
            catch (SQLException e) {
                this._fireAll();
                this.setStatusException(e);
                return false;
            }
        }
        return true;
    }

    public void setQueryStatement(String queryStatement) {
        String oldQuery = this.getQueryStatement();
        if (com.sas.util.Util.unequal((Object)oldQuery, (Object)queryStatement)) {
            this.queryStatement = queryStatement;
            this.firePropertyChange("queryStatement", oldQuery, queryStatement);
        }
    }

    public String getQueryStatement() {
        return this.queryStatement;
    }

    public void setResultSetType(int type) throws SQLException {
        if (type == 1003 || type == 1004 || type == 1005) {
            this.initialized = false;
            int oldType = this.getResultSetType();
            if (oldType != type) {
                this.resultSetType = type;
                this.firePropertyChange("resultSetType", new Integer(oldType), new Integer(this.resultSetType));
                if (!this.isDesignTime && this.dataSource != null) {
                    this.statement = null;
                    this.initializeResults();
                }
            }
        } else {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "InvalidResultSetTypeValue.txt"));
        }
    }

    public int getResultSetType() {
        if (this.results != null) {
            try {
                return this.results.getType();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.resultSetType;
    }

    public void setResultSetConcurrency(int concur) throws SQLException {
        if (concur == 1007 || concur == 1008) {
            this.initialized = false;
            int oldConcur = this.getResultSetConcurrency();
            if (oldConcur != concur) {
                this.resultSetConcurrency = concur;
                this.firePropertyChange("resultSetConcurrency", new Integer(oldConcur), new Integer(concur));
                if (!this.isDesignTime && this.dataSource != null) {
                    this.statement = null;
                    this.initializeResults();
                }
            }
        } else {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "InvalidResultSetConcurrencyValue.txt"));
        }
    }

    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    protected void updateColumn(int columnIndex, String value) throws SQLException {
        if (!this.isDesignTime) {
            this.init();
            this.results.updateString(columnIndex, value);
            this.updateColumn(columnIndex);
        }
    }

    protected void updateColumn(int columnIndex, double value) throws SQLException {
        if (!this.isDesignTime) {
            this.init();
            this.results.updateDouble(columnIndex, value);
            this.updateColumn(columnIndex);
        }
    }

    protected void updateColumn(int columnIndex, long value) throws SQLException {
        if (!this.isDesignTime) {
            this.init();
            this.results.updateLong(columnIndex, value);
            this.updateColumn(columnIndex);
        }
    }

    protected void updateColumn(int columnIndex, byte[] value) throws SQLException {
        if (!this.isDesignTime) {
            this.init();
            this.results.updateBytes(columnIndex, value);
            this.updateColumn(columnIndex);
        }
    }

    protected void updateColumn(int columnIndex, boolean value) throws SQLException {
        if (!this.isDesignTime) {
            this.init();
            this.results.updateBoolean(columnIndex, value);
            this.updateColumn(columnIndex);
        }
    }

    protected void updateColumn(int columnIndex, Date value) throws SQLException {
        if (!this.isDesignTime) {
            this.init();
            this.results.updateDate(columnIndex, value);
            this.updateColumn(columnIndex);
        }
    }

    protected void updateColumn(int columnIndex, BigDecimal value) throws SQLException {
        if (!this.isDesignTime) {
            this.init();
            this.results.updateBigDecimal(columnIndex, value);
            this.updateColumn(columnIndex);
        }
    }

    protected void updateColumn(int columnIndex, float value) throws SQLException {
        if (!this.isDesignTime) {
            this.init();
            this.results.updateFloat(columnIndex, value);
            this.updateColumn(columnIndex);
        }
    }

    protected void updateColumn(int columnIndex, int value) throws SQLException {
        if (!this.isDesignTime) {
            this.init();
            this.results.updateInt(columnIndex, value);
            this.updateColumn(columnIndex);
        }
    }

    protected void updateColumn(int columnIndex, Object value) throws SQLException {
        if (!this.isDesignTime) {
            this.init();
            this.results.updateObject(columnIndex, value);
            this.updateColumn(columnIndex);
        }
    }

    protected void updateColumn(int columnIndex, short value) throws SQLException {
        if (!this.isDesignTime) {
            this.init();
            this.results.updateShort(columnIndex, value);
            this.updateColumn(columnIndex);
        }
    }

    protected void updateColumn(int columnIndex, Time value) throws SQLException {
        if (!this.isDesignTime) {
            this.init();
            this.results.updateTime(columnIndex, value);
            this.updateColumn(columnIndex);
        }
    }

    protected void updateColumn(int columnIndex, Timestamp value) throws SQLException {
        if (!this.isDesignTime) {
            this.init();
            this.results.updateTimestamp(columnIndex, value);
            this.updateColumn(columnIndex);
        }
    }

    protected void updateColumn(int columnIndex, byte value) throws SQLException {
        if (!this.isDesignTime) {
            this.init();
            this.results.updateByte(columnIndex, value);
            this.updateColumn(columnIndex);
        }
    }

    protected void updateColumn(int columnIndex) throws SQLException {
        if (!this.isDesignTime) {
            this.init();
            this.itemChanged(columnIndex);
            this.commitData(2);
        }
    }

    protected Array getArrayColumn(int columnIndex) throws SQLException {
        if (!this.isDesignTime) {
            this.init();
            if (this.isCursorValid()) {
                return this.results.getArray(columnIndex);
            }
        }
        return null;
    }

    protected byte[] getByteArrayColumn(int columnIndex) throws SQLException {
        if (!this.isDesignTime) {
            this.init();
            if (this.isCursorValid()) {
                return this.results.getBytes(columnIndex);
            }
        }
        return null;
    }

    protected boolean getBooleanColumn(int columnIndex) throws SQLException {
        if (!this.isDesignTime) {
            this.init();
            if (this.isCursorValid()) {
                return this.results.getBoolean(columnIndex);
            }
        }
        return false;
    }

    protected String getStringColumn(int columnIndex) throws SQLException {
        if (!this.isDesignTime) {
            this.init();
            if (this.isCursorValid()) {
                return this.results.getString(columnIndex);
            }
        }
        return null;
    }

    protected double getDoubleColumn(int columnIndex) throws SQLException {
        if (!this.isDesignTime) {
            this.init();
            if (this.isCursorValid()) {
                return this.results.getDouble(columnIndex);
            }
        }
        return 0.0;
    }

    protected long getLongColumn(int columnIndex) throws SQLException {
        if (!this.isDesignTime) {
            this.init();
            if (this.isCursorValid()) {
                return this.results.getLong(columnIndex);
            }
        }
        return 0L;
    }

    protected BigDecimal getBigDecimalColumn(int columnIndex) throws SQLException {
        if (!this.isDesignTime) {
            this.init();
            if (this.isCursorValid()) {
                return this.results.getBigDecimal(columnIndex);
            }
        }
        return null;
    }

    protected float getFloatColumn(int columnIndex) throws SQLException {
        if (!this.isDesignTime) {
            this.init();
            if (this.isCursorValid()) {
                return this.results.getFloat(columnIndex);
            }
        }
        return 0.0f;
    }

    protected int getIntColumn(int columnIndex) throws SQLException {
        if (!this.isDesignTime) {
            this.init();
            if (this.isCursorValid()) {
                return this.results.getInt(columnIndex);
            }
        }
        return 0;
    }

    protected Object getObjectColumn(int columnIndex) throws SQLException {
        if (!this.isDesignTime) {
            this.init();
            if (this.isCursorValid()) {
                return this.results.getObject(columnIndex);
            }
        }
        return null;
    }

    protected Ref getRefColumn(int columnIndex) throws SQLException {
        if (!this.isDesignTime) {
            this.init();
            if (this.isCursorValid()) {
                return this.results.getRef(columnIndex);
            }
        }
        return null;
    }

    protected short getShortColumn(int columnIndex) throws SQLException {
        if (!this.isDesignTime) {
            this.init();
            if (this.isCursorValid()) {
                return this.results.getShort(columnIndex);
            }
        }
        return 0;
    }

    protected Time getTimeColumn(int columnIndex) throws SQLException {
        if (!this.isDesignTime) {
            this.init();
            if (this.isCursorValid()) {
                return this.results.getTime(columnIndex);
            }
        }
        return null;
    }

    protected Timestamp getTimestampColumn(int columnIndex) throws SQLException {
        if (!this.isDesignTime) {
            this.init();
            if (this.isCursorValid()) {
                return this.results.getTimestamp(columnIndex);
            }
        }
        return null;
    }

    protected byte getByteColumn(int columnIndex) throws SQLException {
        if (!this.isDesignTime) {
            this.init();
            if (this.isCursorValid()) {
                return this.results.getByte(columnIndex);
            }
        }
        return 0;
    }

    protected Blob getBlobColumn(int columnIndex) throws SQLException {
        if (!this.isDesignTime) {
            this.init();
            if (this.isCursorValid()) {
                return this.results.getBlob(columnIndex);
            }
        }
        return null;
    }

    protected Clob getClobColumn(int columnIndex) throws SQLException {
        if (!this.isDesignTime) {
            this.init();
            if (this.isCursorValid()) {
                return this.results.getClob(columnIndex);
            }
        }
        return null;
    }

    protected Date getDateColumn(int columnIndex) throws SQLException {
        if (!this.isDesignTime) {
            this.init();
            if (this.isCursorValid()) {
                return this.results.getDate(columnIndex);
            }
        }
        return null;
    }

    @Override
    public boolean first() {
        try {
            this.init();
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
        if (this.results == null) {
            this.setStatusException(new SQLException(RB.getStringResource(RB_KEY, "ResultSetIsNull.txt"), "22002"));
            return false;
        }
        if (this.dataNeedsCommit) {
            this.commitData(1);
            if (this.dataNeedsCommit) {
                this.setStatusException(new SQLException(RB.getStringResource(RB_KEY, "ModifiedDataNotCommited.txt"), "25000"));
                return false;
            }
        }
        this.commitWithUpdate = true;
        try {
            boolean rc = this.results.first();
            this.isOnInsertRow = false;
            if (!rc) {
                this._fireAll();
                this.setStatusException(new SQLException(RB.getStringResource(RB_KEY, "NoRowsInResultSet.txt"), "22002"));
                return rc;
            }
            this.atEnd = this.results.isLast();
            this.atBeginning = true;
            this.rowChanged();
            return rc;
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
    }

    @Override
    public boolean last() {
        try {
            this.init();
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
        if (this.results == null) {
            this.setStatusException(new SQLException(RB.getStringResource(RB_KEY, "ResultSetIsNull.txt"), "22002"));
            return false;
        }
        if (this.dataNeedsCommit) {
            this.commitData(1);
            if (this.dataNeedsCommit) {
                this.setStatusException(new SQLException(RB.getStringResource(RB_KEY, "ModifiedDataNotCommited.txt"), "25000"));
                return false;
            }
        }
        this.commitWithUpdate = true;
        try {
            boolean rc = this.results.last();
            this.isOnInsertRow = false;
            if (!rc) {
                this._fireAll();
                this.setStatusException(new SQLException(RB.getStringResource(RB_KEY, "NoRowsOrInvalidCursor.txt"), "01001"));
                return rc;
            }
            this.atBeginning = this.results.isFirst();
            this.atEnd = true;
            this.rowChanged();
            return rc;
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
    }

    @Override
    public boolean previous() {
        try {
            this.init();
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
        if (this.results == null) {
            this.setStatusException(new SQLException(RB.getStringResource(RB_KEY, "ResultSetIsNull.txt"), "22002"));
            return false;
        }
        if (this.dataNeedsCommit) {
            this.commitData(1);
            if (this.dataNeedsCommit) {
                this.setStatusException(new SQLException(RB.getStringResource(RB_KEY, "ModifiedDataNotCommited.txt"), "25000"));
                return false;
            }
        }
        this.commitWithUpdate = true;
        try {
            boolean rc = this.results.previous();
            this.isOnInsertRow = false;
            if (!rc) {
                this._fireAll();
                this.setStatusException(new SQLException(RB.getStringResource(RB_KEY, "CursorOnInvalidRow.txt"), "01001"));
                return rc;
            }
            this.atBeginning = this.results.isFirst();
            this.atEnd = false;
            this.rowChanged();
            return rc;
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
    }

    @Override
    public boolean next() {
        try {
            this.init();
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
        if (this.results == null) {
            this.setStatusException(new SQLException(RB.getStringResource(RB_KEY, "ResultSetIsNull.txt"), "22002"));
            return false;
        }
        if (this.dataNeedsCommit) {
            this.commitData(1);
            if (this.dataNeedsCommit) {
                this.setStatusException(new SQLException(RB.getStringResource(RB_KEY, "ModifiedDataNotCommited.txt"), "25000"));
                return false;
            }
        }
        this.commitWithUpdate = true;
        try {
            boolean rc = this.results.next();
            this.isOnInsertRow = false;
            if (!rc) {
                if (this.results.getType() == 1003) {
                    this.endOfForwardOnlyResultSet = true;
                }
                this._fireAll();
                this.setStatusException(new SQLException(RB.getStringResource(RB_KEY, "NoMoreRowsInResultSet.txt"), "01001"));
                return rc;
            }
            if (this.results.getType() != 1003) {
                this.atEnd = this.results.isLast();
                this.atBeginning = this.results.isFirst();
            }
            this.rowChanged();
            return rc;
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
    }

    public boolean isOnInsertRow() {
        return this.isOnInsertRow;
    }

    @Override
    public boolean insert() {
        try {
            this.init();
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
        if (this.results == null) {
            this.setStatusException(new SQLException(RB.getStringResource(RB_KEY, "ResultSetIsNull.txt"), "22002"));
            return false;
        }
        if (this.dataNeedsCommit) {
            this.commitData(1);
            if (this.dataNeedsCommit) {
                this.setStatusException(new SQLException(RB.getStringResource(RB_KEY, "ModifiedDataNotCommited.txt"), "25000"));
                return false;
            }
        }
        this.commitWithUpdate = false;
        try {
            this.results.moveToInsertRow();
            this.isOnInsertRow = true;
            this.rowChanged();
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
        return true;
    }

    @Override
    public boolean move(int row) {
        try {
            this.init();
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
        if (this.results == null) {
            this.setStatusException(new SQLException(RB.getStringResource(RB_KEY, "ResultSetIsNull.txt"), "22002"));
            return false;
        }
        if (this.dataNeedsCommit) {
            this.commitData(1);
            if (this.dataNeedsCommit) {
                this.setStatusException(new SQLException(RB.getStringResource(RB_KEY, "ModifiedDataNotCommited.txt"), "25000"));
                return false;
            }
        }
        this.commitWithUpdate = true;
        try {
            boolean rc = this.results.absolute(row);
            this.isOnInsertRow = false;
            if (!rc) {
                this.setStatusException(new SQLException(RB.getStringResource(RB_KEY, "InvalidRow.txt"), "01001"));
                return false;
            }
            if (this.results.getType() != 1003) {
                this.atEnd = this.results.isLast();
                this.atBeginning = this.results.isFirst();
            }
            this.rowChanged();
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean commit() {
        try {
            this.init();
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
        if (this.results == null) {
            this.setStatusException(new SQLException(RB.getStringResource("BaseDataBean.", "ResultSetIsNull.txt"), "22002"));
            return false;
        }
        if (this.commitWithUpdate) {
            try {
                this.results.updateRow();
                if (!this.badState) ** GOTO lbl50
                this.badState = false;
                this.setBadState = false;
                this._fireAll();
                this.setBadState = true;
            }
            catch (SQLException e) {
                e.printStackTrace();
                this._fireAll();
                this.setStatusException(e);
                return false;
            }
        } else {
            try {
                this.results.insertRow();
                this.isOnInsertRow = false;
                rowCount = this.getRowCount();
                if (this.getRowCount() == 1) {
                    this.results.absolute(1);
                } else {
                    this.results.moveToCurrentRow();
                }
                if (this.results.getType() != 1003) {
                    if (rowCount == 0) {
                        this.atBeginning = true;
                        this.atEnd = true;
                    } else {
                        this.atBeginning = this.results.isFirst();
                        this.atEnd = this.results.isLast();
                    }
                }
                this.commitWithUpdate = true;
                this.badState = false;
                this.rowChanged();
            }
            catch (SQLException e) {
                e.printStackTrace();
                this._fireAll();
                this.setStatusException(e);
                return false;
            }
        }
lbl50:
        // 3 sources

        this.dataNeedsCommit = false;
        return true;
    }

    @Override
    public boolean cancel() {
        try {
            this.init();
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
        if (this.results == null) {
            this.setStatusException(new SQLException(RB.getStringResource(RB_KEY, "ResultSetIsNull.txt"), "22002"));
            return false;
        }
        try {
            if (this.isOnInsertRow) {
                this.results.moveToCurrentRow();
                this.isOnInsertRow = false;
            } else {
                this.results.cancelRowUpdates();
            }
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
        this.rowChanged();
        this.dataNeedsCommit = false;
        return true;
    }

    @Override
    public boolean refresh() {
        return this.executeQuery();
    }

    @Override
    public void setPageSize(int pageSize) {
        int oldPageSize = this.getPageSize();
        if (oldPageSize != pageSize) {
            this.pageSize = pageSize;
            this.firePropertyChange("pageSize", new Integer(oldPageSize), new Integer(pageSize));
        }
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    protected void setStatusException(SQLException statusException) {
        this.statusException = statusException;
    }

    @Override
    public Exception getStatusException() {
        return this.statusException;
    }

    @Override
    public void setAutoCommitLevel(int autoCommitLevel) {
        if (autoCommitLevel == 0 || autoCommitLevel == 1 || autoCommitLevel == 2) {
            int oldCommitLevel = this.getAutoCommitLevel();
            if (oldCommitLevel != autoCommitLevel) {
                this.autoCommitLevel = autoCommitLevel;
                this.firePropertyChange("autoCommitLevel", new Integer(oldCommitLevel), new Integer(autoCommitLevel));
            }
        } else {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "InvalidAutoCommitLevelValue.txt"));
        }
    }

    @Override
    public int getAutoCommitLevel() {
        return this.autoCommitLevel;
    }

    protected void initializeData() {
        this.badState = false;
        this.setBadState = true;
        this.dataNeedsCommit = false;
        this.delayCommit = false;
        this.commitWithUpdate = true;
        this.setPageSize(10);
        this.setAutoCommitLevel(0);
        this.resultSetType = 1004;
        this.firePropertyChange("resultSetType", null, new Integer(this.resultSetType));
    }

    protected void commitData(int commitLevel) {
        if (commitLevel <= this.autoCommitLevel && !this.delayCommit) {
            this.commit();
        } else {
            this.dataNeedsCommit = true;
        }
    }

    @Override
    public boolean pageForward() {
        try {
            this.init();
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
        if (this.results == null) {
            this.setStatusException(new SQLException(RB.getStringResource(RB_KEY, "ResultSetIsNull.txt"), "22002"));
            return false;
        }
        if (this.dataNeedsCommit) {
            this.commitData(1);
            if (this.dataNeedsCommit) {
                this.setStatusException(new SQLException(RB.getStringResource(RB_KEY, "ModifiedDataNotCommited.txt"), "25000"));
                return false;
            }
        }
        try {
            int currentRow = this.getRow();
            int rowCount = this.getRowCount();
            if (rowCount > 0 && this.pageSize > 0) {
                if (currentRow + this.pageSize > rowCount) {
                    this.last();
                } else {
                    this.results.relative(this.pageSize);
                }
                this.isOnInsertRow = false;
                this.atBeginning = this.results.isFirst();
                this.atEnd = this.results.isLast();
            }
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
        this.rowChanged();
        return true;
    }

    @Override
    public boolean pageBackward() {
        try {
            this.init();
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
        if (this.results == null) {
            this.setStatusException(new SQLException(RB.getStringResource(RB_KEY, "ResultSetIsNull.txt"), "22002"));
            return false;
        }
        if (this.dataNeedsCommit) {
            this.commitData(1);
            if (this.dataNeedsCommit) {
                this.setStatusException(new SQLException(RB.getStringResource(RB_KEY, "ModifiedDataNotCommited.txt"), "25000"));
                return false;
            }
        }
        try {
            int currentRow = this.getRow();
            int rowCount = this.getRowCount();
            if (rowCount > 0 && this.pageSize > 0) {
                if (currentRow - this.pageSize < 1) {
                    this.first();
                } else {
                    this.results.relative(this.pageSize * -1);
                }
                this.isOnInsertRow = false;
                this.atBeginning = this.results.isFirst();
                this.atEnd = this.results.isLast();
            }
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
        this.rowChanged();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean delete() {
        if (this.isOnInsertRow) {
            return false;
        }
        try {
            this.init();
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
        if (this.results == null) {
            this.setStatusException(new SQLException(RB.getStringResource(RB_KEY, "ResultSetIsNull.txt"), "22002"));
            return false;
        }
        if (!this.commitWithUpdate) return false;
        try {
            int previousRowCount = this.getRowCount();
            if (this.results.getType() == 1003) {
                this.results.deleteRow();
                if (this.results.getRow() == 0) {
                    this.endOfForwardOnlyResultSet = true;
                }
                this.rowChanged();
            } else if (this.results.isLast()) {
                this.results.deleteRow();
                boolean lastRc = this.last();
                if (previousRowCount == 1 && this.getRowCount() < 1) {
                    this.atBeginning = this.results.isFirst();
                    this.atEnd = this.results.isLast();
                    this.rowChanged();
                }
            } else if (this.results.isFirst()) {
                this.results.deleteRow();
                this.first();
            } else {
                this.results.deleteRow();
                this.atBeginning = this.results.isFirst();
                this.atEnd = this.results.isLast();
                this.rowChanged();
            }
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
        this.dataNeedsCommit = false;
        return true;
    }

    @Override
    public boolean isPreviousSupported() {
        if (this.isDesignTime) {
            return false;
        }
        try {
            this.init();
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
        if (this.results == null) {
            this.setStatusException(new SQLException(RB.getStringResource(RB_KEY, "ResultSetIsNull.txt"), "22002"));
            return false;
        }
        try {
            if (this.results.getType() == 1003 || this.atBeginning || this.badState || !this.isCursorValid()) {
                this.setStatusException(null);
                return false;
            }
            return true;
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
    }

    @Override
    public boolean isPageBackwardSupported() {
        if (this.isDesignTime) {
            return false;
        }
        try {
            this.init();
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
        if (this.results == null) {
            this.setStatusException(new SQLException(RB.getStringResource(RB_KEY, "ResultSetIsNull.txt"), "22002"));
            return false;
        }
        try {
            if (this.results.getType() == 1003 || this.atBeginning || this.badState || !this.isCursorValid()) {
                this.setStatusException(null);
                return false;
            }
            return true;
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
    }

    @Override
    public boolean isNextSupported() {
        if (this.isDesignTime) {
            return false;
        }
        try {
            this.init();
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
        if (this.results == null) {
            this.setStatusException(new SQLException(RB.getStringResource(RB_KEY, "ResultSetIsNull.txt"), "22002"));
            return false;
        }
        try {
            if (this.atEnd || this.badState || this.results.getType() == 1003 && this.endOfForwardOnlyResultSet || !this.isCursorValid()) {
                this.setStatusException(null);
                return false;
            }
            return true;
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
    }

    @Override
    public boolean isPageForwardSupported() {
        if (this.isDesignTime) {
            return false;
        }
        try {
            this.init();
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
        if (this.results == null) {
            this.setStatusException(new SQLException(RB.getStringResource(RB_KEY, "ResultSetIsNull.txt"), "22002"));
            return false;
        }
        try {
            if (this.results.getType() == 1003 || this.atEnd || this.badState || !this.isCursorValid()) {
                this.setStatusException(null);
                return false;
            }
            return true;
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
    }

    @Override
    public boolean isFirstSupported() {
        if (this.isDesignTime) {
            return false;
        }
        try {
            this.init();
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
        if (this.results == null) {
            this.setStatusException(new SQLException(RB.getStringResource(RB_KEY, "ResultSetIsNull.txt"), "22002"));
            return false;
        }
        try {
            if (this.results.getType() == 1003 || this.atBeginning || this.badState || !this.isCursorValid()) {
                this.setStatusException(null);
                return false;
            }
            return true;
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
    }

    @Override
    public boolean isLastSupported() {
        if (this.isDesignTime) {
            return false;
        }
        try {
            this.init();
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
        if (this.results == null) {
            this.setStatusException(new SQLException(RB.getStringResource(RB_KEY, "ResultSetIsNull.txt"), "22002"));
            return false;
        }
        try {
            if (this.results.getType() == 1003 || this.atEnd || this.badState || !this.isCursorValid()) {
                this.setStatusException(null);
                return false;
            }
            return true;
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
    }

    @Override
    public boolean isInsertSupported() {
        if (this.isDesignTime) {
            return false;
        }
        try {
            this.init();
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
        if (this.results == null) {
            this.setStatusException(new SQLException(RB.getStringResource(RB_KEY, "ResultSetIsNull.txt"), "22002"));
            return false;
        }
        try {
            if (this.results.getConcurrency() == 1007) {
                this.setStatusException(null);
                return false;
            }
            return true;
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
    }

    @Override
    public boolean isCommitSupported() {
        if (this.isDesignTime) {
            return false;
        }
        try {
            this.init();
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
        if (this.results == null) {
            this.setStatusException(new SQLException(RB.getStringResource(RB_KEY, "ResultSetIsNull.txt"), "22002"));
            return false;
        }
        try {
            if (this.results.getConcurrency() == 1007) {
                return false;
            }
            return this.isOnInsertRow || this.isCursorValid();
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
    }

    @Override
    public boolean isDeleteSupported() {
        if (this.isDesignTime) {
            return false;
        }
        try {
            this.init();
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
        if (this.results == null) {
            this.setStatusException(new SQLException(RB.getStringResource(RB_KEY, "ResultSetIsNull.txt"), "22002"));
            return false;
        }
        try {
            if (this.results.getConcurrency() == 1007 || this.badState || this.isOnInsertRow || !this.isCursorValid()) {
                this.setStatusException(null);
                return false;
            }
            return true;
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
    }

    @Override
    public boolean isCancelSupported() {
        if (this.isDesignTime) {
            return false;
        }
        try {
            this.init();
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
        if (this.results == null) {
            this.setStatusException(new SQLException(RB.getStringResource(RB_KEY, "ResultSetIsNull.txt"), "22002"));
            return false;
        }
        try {
            if (this.results.getConcurrency() == 1007 || this.badState || !this.isCursorValid()) {
                this.setStatusException(null);
                return false;
            }
            return true;
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
    }

    @Override
    public boolean isRefreshSupported() {
        if (this.isDesignTime) {
            return false;
        }
        try {
            this.init();
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            return false;
        }
        if (this.results == null) {
            this.setStatusException(new SQLException(RB.getStringResource(RB_KEY, "ResultSetIsNull.txt"), "22002"));
            return false;
        }
        return true;
    }

    @Override
    public boolean isModified() {
        return this.dataNeedsCommit;
    }

    @Override
    public boolean isCursorValid() {
        boolean oldCursorValid = this.cursorValid;
        try {
            this.init();
            if (this.results == null) {
                throw new IllegalStateException(RB.getStringResource(RB_KEY, "ResultSetIsNull.txt"));
            }
            int currentRow = this.getRow();
            int type = this.results.getType();
            this.cursorValid = !(!this.isOnInsertRow && (this.badState || type != 1003 && currentRow < 1 || type == 1003 && this.endOfForwardOnlyResultSet));
        }
        catch (SQLException e) {
            this._fireAll();
            this.setStatusException(e);
            this.cursorValid = false;
        }
        if (oldCursorValid != this.cursorValid) {
            this.firePropertyChange("cursorValid", this.cursorValid ? Boolean.FALSE : Boolean.TRUE, this.cursorValid ? Boolean.TRUE : Boolean.FALSE);
        }
        return this.cursorValid;
    }

    public int getRow() {
        try {
            this.init();
            return this.results.getRow();
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public int getRowCount() {
        try {
            this.init();
            if (this.results.getType() == 1003 || this.isOnInsertRow) {
                return -1;
            }
            int currentRow = this.results.getRow();
            boolean rcLast = this.results.last();
            int lastRow = this.results.getRow();
            if (currentRow != 0) {
                this.results.absolute(currentRow);
            } else if (lastRow != 0) {
                this.results.absolute(1);
            }
            return lastRow;
        }
        catch (SQLException ex) {
            this._fireAll();
            this.setStatusException(ex);
            return -1;
        }
    }

    protected abstract void initColumnIndexes() throws SQLException;

    protected abstract Object[][] getColumnMapping();

    protected abstract Hashtable getPropertyNameMap();

    protected void initPropertyNameMap(Hashtable propertyNameMap) {
        Object[][] columnMapping = this.getColumnMapping();
        for (int i = 0; i < columnMapping.length; ++i) {
            propertyNameMap.put(columnMapping[i][COLUMNMAP_PROPERTY_NAME], columnMapping[i]);
        }
    }

    protected int initColumnIndex(String propertyName) throws SQLException {
        this.init();
        int columnIndex = -1;
        try {
            Hashtable propertyNameMap = this.getPropertyNameMap();
            Object[] columnInfo = (Object[])propertyNameMap.get(propertyName);
            columnIndex = this.results.findColumn((String)columnInfo[COLUMNMAP_COLUMN_NAME]);
            ResultSetMetaData resultsMetaData = this.results.getMetaData();
            int SQLDataType = resultsMetaData.getColumnType(columnIndex);
            if ((Integer)columnInfo[COLUMNMAP_COLUMN_TYPE] == 1111) {
                columnInfo[BaseDataBean.COLUMNMAP_COLUMN_TYPE] = new Integer(SQLDataType);
            } else if (SQLDataType != (Integer)columnInfo[COLUMNMAP_COLUMN_TYPE]) {
                columnIndex = -1;
            }
            columnInfo[BaseDataBean.COLUMNMAP_COLUMN_INDEX] = new Integer(columnIndex);
        }
        catch (SQLException e) {
            this.setStatusException(e);
            throw e;
        }
        return columnIndex;
    }

    protected void itemChanged(int columnIndex) {
    }

    protected void rowChanged() {
        Object[][] columnMapping = this.getColumnMapping();
        if (columnMapping != null) {
            for (int i = 0; i < columnMapping.length; ++i) {
                this.firePropertyChange((String)columnMapping[i][COLUMNMAP_PROPERTY_NAME], null, null);
                if (columnMapping[i][COLUMNMAP_FORMATTED_PROPERTY_NAME] == null) continue;
                this.firePropertyChange((String)columnMapping[i][COLUMNMAP_FORMATTED_PROPERTY_NAME], null, null);
            }
        }
        this.setBadState = false;
        this._fireAll();
        this.setBadState = true;
    }

    protected void _fireAll() {
        this.calledFromFireAll = true;
        if (this.setBadState) {
            this.badState = true;
        }
        this.fpc("nextSupported", this.isNextSupported(), 0);
        this.fpc("previousSupported", this.isPreviousSupported(), 1);
        this.fpc("firstSupported", this.isFirstSupported(), 2);
        this.fpc("lastSupported", this.isLastSupported(), 3);
        this.fpc("commitSupported", this.isCommitSupported(), 4);
        this.fpc("insertSupported", this.isInsertSupported(), 5);
        this.fpc("deleteSupported", this.isDeleteSupported(), 6);
        this.fpc("cancelSupported", this.isCancelSupported(), 7);
        this.fpc("refreshSupported", this.isRefreshSupported(), 8);
        this.fpc("pageForwardSupported", this.isPageForwardSupported(), 9);
        this.fpc("pageBackwardSupported", this.isPageBackwardSupported(), 10);
        this.calledFromFireAll = false;
    }

    protected void fpc(String propertyName, boolean newValue, int index) {
        if (this.supported[index] != newValue) {
            this.firePropertyChange(propertyName, null, newValue ? Boolean.TRUE : Boolean.FALSE);
            this.supported[index] = newValue;
        }
    }

    protected ResultSetMetaData getResultSetMetaData() throws SQLException {
        this.init();
        ResultSetMetaData resultSetMetaData = null;
        try {
            if (this.results != null) {
                resultSetMetaData = this.results.getMetaData();
            }
        }
        catch (SQLException e) {
            this.setStatusException(e);
            throw e;
        }
        return resultSetMetaData;
    }

    protected void init() throws SQLException {
        if (this.initialized || this.calledFromFireAll || this.calledFromInit || this.isDesignTime) {
            return;
        }
        if (this.dataSource == null) {
            this.setStatusException(new SQLException(RB.getStringResource(RB_KEY, "connNull.ex.txt"), "08003"));
            throw this.statusException;
        }
        try {
            this.statement = this.dataSource.createStatement(this.getResultSetType(), this.getResultSetConcurrency());
            this.calledFromInit = true;
            if (!this.executeQuery(this.queryStatement)) {
                this.calledFromInit = false;
                throw this.statusException;
            }
            this.initColumnIndexes();
            this.calledFromInit = false;
            this.initialized = true;
        }
        catch (SQLException e) {
            this.setStatusException(e);
            throw e;
        }
        finally {
            this.calledFromInit = false;
        }
    }

    protected boolean checkValue() {
        if (this._stackChecker == null) {
            this._stackChecker = new StackChecker();
        }
        if (this._stackChecker.checkStack("PropertyLinkAdaptor.addLink")) {
            return false;
        }
        return this.isOnInsertRow || this.isCursorValid() || !this._stackChecker.checkStack("PropertyLinkAdaptor.setPropertyValue");
    }
}

