/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net;

import com.sas.Component;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.lang.StringDataInterface;
import com.sas.net.ConnectionRefusedException;
import com.sas.net.RB;
import com.sas.text.Message;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URLConnection;

public class URL
extends Component
implements StringDataInterface {
    static final long serialVersionUID = 8497903219595264986L;
    private transient java.net.URL url;
    private String text;
    public static final String RB_KEY = "URL.";

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "url"}, {"Description", RB.getStringResource(RB_KEY, "url.pd.txt")}}, {{"Name", "text"}, {"Description", RB.getStringResource(RB_KEY, "text.pd.txt")}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "text";
        ebi.defaultOutputPropertyName = "text";
        ebi.shortDescription = RB.getStringResource(RB_KEY, "description.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public URL() {
    }

    public URL(String name) {
        this.setText(name);
    }

    public String getText() {
        return this.text;
    }

    public java.net.URL getUrl() {
        return this.url;
    }

    public void setText(String name) {
        URLConnection connection = null;
        if (name == null || name.length() == 0) {
            this.url = null;
            return;
        }
        try {
            try {
                this.url = new java.net.URL(name);
            }
            catch (MalformedURLException m) {
                throw new ConnectionRefusedException(Message.format((String)RB.getStringResource(RB_KEY, "invalidurl.ex.txt"), (Object)name));
            }
            connection = this.url.openConnection();
        }
        catch (IOException e) {
            throw new ConnectionRefusedException(Message.format((String)RB.getStringResource(RB_KEY, "contents.ex.txt"), (Object)name));
        }
        String oldText = this.text;
        this.text = this.url.toString();
        this.firePropertyChange("text", oldText, name);
    }

    public String toString() {
        return this.text;
    }
}

