/*
 * Decompiled with CFR 0.152.
 */
package com.sas.models;

import com.sas.ModelInterface;
import com.sas.beans.Util;
import com.sas.lang.StringData;
import com.sas.lang.StringDataInterface;
import com.sas.util.Alarm;
import com.sas.util.AlarmEvent;
import com.sas.util.AlarmInterface;
import com.sas.util.AlarmListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;

public class StatusStringData
extends StringData
implements AlarmListener {
    static String[] requiredInterfacesString = new String[]{"com.sas.lang.StringDataInterface"};
    protected StringDataInterface defaultModel;
    protected AlarmInterface refreshAlarm;

    public StatusStringData() {
    }

    public StatusStringData(String str) {
        super(str);
        this.defaultModel.setText(str);
    }

    public StatusStringData(StringBuffer strBuffer) {
        super(strBuffer);
        this.defaultModel.setText(strBuffer.toString());
    }

    public AlarmInterface getRefreshAlarm() {
        return this.refreshAlarm;
    }

    public void setRefreshAlarm(AlarmInterface refresh) {
        if (this.refreshAlarm != refresh) {
            AlarmInterface oldAlarm = this.refreshAlarm;
            if (oldAlarm != null) {
                oldAlarm.removeAlarmListener(this);
            }
            this.refreshAlarm = refresh;
            if (this.refreshAlarm != null) {
                this.refreshAlarm.addAlarmListener(this);
            }
            this.firePropertyChange("refreshAlarm", oldAlarm, this.refreshAlarm);
        }
    }

    @Override
    public void fireAlarm(AlarmEvent event) {
        if (event.getSource() == this.refreshAlarm) {
            this.refresh(this.getModelInterface());
        }
    }

    @Override
    public void refresh(ModelInterface model) {
        super.refresh(model);
        if (model != null) {
            String defaultText = ((StringDataInterface)model).getText();
            super.setText(defaultText);
        }
    }

    @Override
    public void attachModel(ModelInterface model) {
        super.attachModel(model);
        Util.addPropertyChangeListener((Object)model, (PropertyChangeListener)this);
    }

    @Override
    public void detachModel(ModelInterface model) {
        super.detachModel(model);
        Util.removePropertyChangeListener((Object)model, (PropertyChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        ModelInterface model = this.getModelInterface();
        String propName = event.getPropertyName();
        if (event.getSource() == model && propName != null && propName.equals("text") && !this.refreshAlarm.isRunning()) {
            this.refresh(model);
        }
    }

    @Override
    public void setText(String txt) {
        AlarmInterface alarm = this.getRefreshAlarm();
        if (alarm != null && alarm.isRunning()) {
            alarm.stop();
        }
        super.setText(txt);
        if (alarm != null) {
            alarm.start();
        }
    }

    @Override
    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        return requiredInterfaces;
    }

    protected AlarmInterface newRefreshAlarm() {
        Alarm alarm = new Alarm();
        alarm.setDelay(10000L);
        alarm.setCount(1);
        return alarm;
    }

    protected void createComponents() {
        this.setRefreshAlarm(this.newRefreshAlarm());
        this.defaultModel = new StringData();
        this.setModelInterface((ModelInterface)this.defaultModel);
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.createComponents();
    }
}

