/*
 * Decompiled with CFR 0.152.
 */
package com.sas.models;

import com.sas.PublicClonable;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.AssociationList;
import com.sas.collection.OrderedCollection;
import com.sas.models.RB;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;

public class RGBList
extends AssociationList
implements PublicClonable {
    static final long serialVersionUID = -6033296540291263836L;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public RGBList() {
        this.setRGBList();
    }

    public RGBList(Enumeration e) {
        while (e.hasMoreElements()) {
            Object c = e.nextElement();
            if (!(c instanceof Color) && !(c instanceof com.sas.awt.Color)) continue;
            this.add(c);
        }
    }

    public void add(String name, int hexValue) {
        Color c = new Color(hexValue);
        if (!this.contains(new Integer(c.getRGB()))) {
            this.add(this.count(), name.toUpperCase(), new Integer(c.getRGB()));
        }
    }

    public void add(int hexValue) {
        Color c = new Color(hexValue);
        if (!this.contains(new Integer(c.getRGB()))) {
            String name = Integer.toHexString(hexValue);
            name = name.substring(2, name.length());
            this.add(this.count(), name.toUpperCase(), new Integer(c.getRGB()));
        }
    }

    @Override
    public void add(Object c) {
        if (c instanceof Color) {
            int rgb = ((Color)c).getRGB();
            if (!this.contains(new Integer(rgb))) {
                String name = Integer.toHexString(rgb);
                name = name.substring(2, name.length());
                this.add(this.count(), name.toUpperCase(), new Integer(rgb));
            }
        } else {
            throw new ClassCastException(RB.getStringResource((String)"invalidobj.ex.txt"));
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RGBList newData = (RGBList)super.clone();
        return newData;
    }

    private void setRGBList() {
        this.set(RB.getStringResource((String)"black.txt"), (Object)new Integer(com.sas.awt.Color.black.getRGB()));
        this.set(RB.getStringResource((String)"blue.txt"), (Object)new Integer(com.sas.awt.Color.blue.getRGB()));
        this.set(RB.getStringResource((String)"cyan.txt"), (Object)new Integer(com.sas.awt.Color.cyan.getRGB()));
        this.set(RB.getStringResource((String)"darkgray.txt"), (Object)new Integer(com.sas.awt.Color.darkGray.getRGB()));
        this.set(RB.getStringResource((String)"gray.txt"), (Object)new Integer(com.sas.awt.Color.gray.getRGB()));
        this.set(RB.getStringResource((String)"green.txt"), (Object)new Integer(com.sas.awt.Color.green.getRGB()));
        this.set(RB.getStringResource((String)"lightgray.txt"), (Object)new Integer(com.sas.awt.Color.lightGray.getRGB()));
        this.set(RB.getStringResource((String)"magenta.txt"), (Object)new Integer(com.sas.awt.Color.magenta.getRGB()));
        this.set(RB.getStringResource((String)"orange.txt"), (Object)new Integer(com.sas.awt.Color.orange.getRGB()));
        this.set(RB.getStringResource((String)"pink.txt"), (Object)new Integer(com.sas.awt.Color.pink.getRGB()));
        this.set(RB.getStringResource((String)"red.txt"), (Object)new Integer(com.sas.awt.Color.red.getRGB()));
        this.set(RB.getStringResource((String)"white.txt"), (Object)new Integer(com.sas.awt.Color.white.getRGB()));
        this.set(RB.getStringResource((String)"yellow.txt"), (Object)new Integer(com.sas.awt.Color.yellow.getRGB()));
        this.setEnglishColorsForDifferentLocale();
    }

    private void setEnglishColorsForDifferentLocale() {
        this.set("black", (Object)new Integer(com.sas.awt.Color.black.getRGB()));
        this.set("blue", (Object)new Integer(com.sas.awt.Color.blue.getRGB()));
        this.set("cyan", (Object)new Integer(com.sas.awt.Color.cyan.getRGB()));
        this.set("darkgray.txt", (Object)new Integer(com.sas.awt.Color.darkGray.getRGB()));
        this.set("gray", (Object)new Integer(com.sas.awt.Color.gray.getRGB()));
        this.set("green", (Object)new Integer(com.sas.awt.Color.green.getRGB()));
        this.set("lightgray", (Object)new Integer(com.sas.awt.Color.lightGray.getRGB()));
        this.set("magenta", (Object)new Integer(com.sas.awt.Color.magenta.getRGB()));
        this.set("orange", (Object)new Integer(com.sas.awt.Color.orange.getRGB()));
        this.set("pink", (Object)new Integer(com.sas.awt.Color.pink.getRGB()));
        this.set("red", (Object)new Integer(com.sas.awt.Color.red.getRGB()));
        this.set("white", (Object)new Integer(com.sas.awt.Color.white.getRGB()));
        this.set("yellow", (Object)new Integer(com.sas.awt.Color.yellow.getRGB()));
    }

    public com.sas.awt.Color getColor(String colorName) {
        return this.containsKey(colorName) ? new com.sas.awt.Color((Integer)this.get(colorName)) : com.sas.awt.Color.newColor(com.sas.awt.Color.white);
    }

    public com.sas.awt.Color getColor(int rgb) {
        if (this.contains(new Integer(rgb))) {
            String name = Integer.toHexString(rgb);
            name = name.substring(2, name.length());
            return new com.sas.awt.Color(name.toUpperCase(), rgb);
        }
        return com.sas.awt.Color.newColor(com.sas.awt.Color.white);
    }

    public com.sas.awt.Color getColor(Color jcolor) {
        return this.getColor(jcolor.getRGB());
    }

    public synchronized Enumeration getColors() {
        Vector<com.sas.awt.Color> v = new Vector<com.sas.awt.Color>();
        Enumeration enumer = this.getItems();
        while (enumer.hasMoreElements()) {
            com.sas.awt.Color c = new com.sas.awt.Color((Integer)enumer.nextElement());
            v.addElement(c);
        }
        return v.elements();
    }

    @Override
    public synchronized Enumeration getItems() {
        return ((OrderedCollection)this.keys).getItems();
    }
}

