/*
 * Decompiled with CFR 0.152.
 */
package com.sas.models;

import com.sas.ModelInterface;
import com.sas.beans.PropertyChangeListenerList;
import com.sas.beans.PropertyChangeSource;
import com.sas.collection.CollectionChangedInfo;
import com.sas.collection.HowChanged;
import com.sas.collection.OrderedCollection;
import com.sas.collection.StaticOrderedCollection;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.collection.StaticPropertyBagInterface;
import com.sas.lang.ObjectDataInterface;
import com.sas.models.MutableNodeInterface;
import com.sas.models.MutableSimpleNodeInterface;
import com.sas.models.NodeInterface;
import com.sas.models.RB;
import com.sas.models.SimpleNodeInterface;
import com.sas.models.StaticNodeStyleInterface;
import com.sas.models.TreeInterface;
import com.sas.text.Message;
import com.sas.util.Comparator;
import com.sas.util.Util;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;

public class Node
implements NodeInterface,
ModelInterface,
MutableNodeInterface,
MutableSimpleNodeInterface,
StaticNodeStyleInterface,
TreeInterface,
ObjectDataInterface,
PropertyChangeSource,
Serializable {
    static final long serialVersionUID = 6866956363479012755L;
    public static final String RB_KEY = "Node.";
    protected boolean hasChildren = false;
    protected OrderedCollection children;
    protected String expandedNodeText;
    protected boolean externalUpdateSupported = true;
    protected String nodeText;
    protected String nodeType;
    protected Object objectData;
    protected StaticPropertyBagInterface nodeStyle;
    protected StaticPropertyBagInterface defaultNodeStyle;
    private transient StaticOrderedCollection staticChildren;
    private transient PropertyChangeListenerList allPropertyChangeListeners;

    public Node() {
    }

    public Node(String nodeText) {
        this();
        this.nodeText = nodeText;
    }

    public Node(String nodeText, String nodeType) {
        this(nodeText);
        this.nodeType = nodeType;
    }

    @Override
    public int countNodeChildren(int maximumChildCount) {
        return this.getNodeChildCount();
    }

    @Override
    public int getNodeChildCount() {
        return this.children == null ? 0 : this.children.count();
    }

    @Override
    public boolean isLeafNode() {
        return !this.hasChildren;
    }

    @Override
    public SimpleNodeInterface getNodeChild(int index) {
        return this.children == null ? null : (NodeInterface)this.children.get(index);
    }

    @Override
    public SimpleNodeInterface[] getNodeChildren(int startIndex, int count) {
        if (this.children != null) {
            if (startIndex < 0 || startIndex >= this.children.count()) {
                throw new IndexOutOfBoundsException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"indexOutOfBounds.ex.txt"), (Object)new Integer(startIndex)));
            }
            if (startIndex + count > this.children.count()) {
                throw new IndexOutOfBoundsException(RB.getStringResource((String)RB_KEY, (String)"countExceedsBounds.ex.txt"));
            }
            SimpleNodeInterface[] sni = new SimpleNodeInterface[count];
            int cnt = startIndex + count;
            for (int i = startIndex; i < cnt; ++i) {
                sni[i - startIndex] = (SimpleNodeInterface)this.children.get(i);
            }
            return sni;
        }
        return null;
    }

    @Override
    public String getNodeExpandedText() {
        return this.expandedNodeText;
    }

    @Override
    public String getNodeType() {
        return this.nodeType;
    }

    @Override
    public String getNodeText() {
        return this.nodeText;
    }

    public void addNodeChild(SimpleNodeInterface node) {
        this.addNodeChild(node, -1);
    }

    @Override
    public void addNodeChild(SimpleNodeInterface node, int index) {
        if (node != null) {
            if (this.children == null) {
                this.children = new OrderedCollection();
            }
            if (index == -1) {
                index = this.children.count();
                this.children.add(node);
            } else {
                this.children.add(node, index);
            }
            this.hasChildren = true;
            CollectionChangedInfo cci = new CollectionChangedInfo(this, "nodeChildren", node, HowChanged.ADDED, index, index + 1);
            this.firePropertyChange((PropertyChangeEvent)((Object)cci));
        }
    }

    @Override
    public void removeNodeChild(SimpleNodeInterface node) {
        int index;
        if (node != null && this.children != null && (index = this.children.getIndex(node, 0)) >= 0) {
            this.removeNodeChild(index);
        }
    }

    @Override
    public void removeNodeChild(int index) {
        if (this.children != null) {
            NodeInterface node = (NodeInterface)this.children.get(index);
            this.children.removeAt(index);
            if (this.children.count() == 0) {
                this.hasChildren = false;
            }
            CollectionChangedInfo cci = new CollectionChangedInfo(this, "nodeChildren", node, HowChanged.REMOVED, index, index + 1);
            this.firePropertyChange((PropertyChangeEvent)((Object)cci));
        }
    }

    @Override
    public void removeAllNodeChildren() {
        if (this.children != null) {
            this.children.removeAll();
            this.hasChildren = false;
            this.firePropertyChange("nodeChildren", null, null);
        }
    }

    @Override
    public void moveNodeChild(int startIndex, int endIndex) {
        if (this.children == null) {
            return;
        }
        Object o = this.children.get(startIndex);
        this.children.removeAt(startIndex);
        this.children.add(o, endIndex);
        if (startIndex > endIndex) {
            int temp = startIndex;
            startIndex = endIndex;
            endIndex = temp;
        }
        CollectionChangedInfo cci = new CollectionChangedInfo(this, "nodeChildren", (NodeInterface)o, HowChanged.REORDERED, startIndex, endIndex);
        this.firePropertyChange((PropertyChangeEvent)((Object)cci));
    }

    @Override
    public boolean isExternalUpdateSupported() {
        return this.externalUpdateSupported;
    }

    @Override
    public StaticPropertyBagInterface getNodeStyle() {
        return this.nodeStyle;
    }

    @Override
    public StaticPropertyBagInterface getDefaultNodeStyle() {
        return this.defaultNodeStyle;
    }

    @Override
    public String[] getNodeTypes() {
        if (this.getNodeType() == null) {
            return null;
        }
        return new String[]{this.getNodeType()};
    }

    public void addItems(Enumeration enumer) {
        int startIndex = 0;
        if (this.children == null) {
            this.children = new OrderedCollection();
        } else {
            startIndex = this.children.count();
        }
        int endIndex = startIndex;
        while (enumer.hasMoreElements()) {
            NodeInterface node = (NodeInterface)enumer.nextElement();
            this.children.add(node);
            ++endIndex;
        }
        this.hasChildren = true;
        CollectionChangedInfo cci = new CollectionChangedInfo(this, "nodeChildren", null, HowChanged.ADDED, startIndex, endIndex);
        this.firePropertyChange((PropertyChangeEvent)((Object)cci));
    }

    public int getIndex(NodeInterface item, int startIndex) {
        return this.children == null ? -1 : this.children.getIndex(item, startIndex);
    }

    public StaticOrderedCollectionInterface getNodeChildren() {
        if (this.children == null) {
            this.children = new OrderedCollection();
        }
        if (this.staticChildren == null) {
            this.staticChildren = new StaticOrderedCollection(this.children);
        }
        return this.staticChildren;
    }

    public Object getObjectData() {
        return this.objectData;
    }

    @Override
    public NodeInterface getRoot() {
        return this;
    }

    public void setExternalUpdateSupported(boolean newValue) {
        if (this.externalUpdateSupported == newValue) {
            return;
        }
        this.externalUpdateSupported = newValue;
        this.firePropertyChange("externalUpdateSupported", this.externalUpdateSupported ? Boolean.FALSE : Boolean.TRUE, this.externalUpdateSupported ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setNodeChildren(StaticOrderedCollectionInterface newValue) {
        this.hasChildren = newValue != null && newValue.count() != 0;
        OrderedCollection oldValue = null;
        if (this.children != null) {
            oldValue = new OrderedCollection();
            oldValue.addItems(this.children.getItems());
        }
        if (this.hasChildren && this.children == null) {
            this.children = new OrderedCollection();
        }
        if (this.children != null) {
            this.children.disableEvents();
            this.children.removeAll();
            if (this.hasChildren) {
                this.children.addItems(newValue.getItems());
            }
            this.children.enableEvents();
        }
        this.firePropertyChange("nodeChildren", oldValue, newValue);
    }

    @Override
    public void setNodeExpandedText(String newValue) {
        if (this.expandedNodeText == newValue) {
            return;
        }
        String oldValue = this.expandedNodeText;
        this.expandedNodeText = newValue;
        this.firePropertyChange("nodeExpandedText", oldValue, newValue);
    }

    @Override
    public void setNodeType(String newValue) {
        if (this.nodeType == newValue) {
            return;
        }
        String oldValue = this.nodeType;
        this.nodeType = newValue;
        this.firePropertyChange("nodeType", oldValue, newValue);
    }

    @Override
    public void setNodeText(String newValue) {
        if (this.nodeText == newValue) {
            return;
        }
        String oldValue = this.nodeText;
        this.nodeText = newValue;
        this.firePropertyChange("nodeText", oldValue, newValue);
    }

    public void setObjectData(Object newValue) {
        if (this.objectData == newValue) {
            return;
        }
        Object oldValue = this.objectData;
        this.objectData = newValue;
        this.firePropertyChange("objectData", oldValue, newValue);
    }

    public void sort(Comparator comparator) {
        if (this.children != null) {
            this.children.sort(comparator);
            CollectionChangedInfo cci = new CollectionChangedInfo(this, "nodeChildren", this, HowChanged.REORDERED, 0, 0);
            this.firePropertyChange((PropertyChangeEvent)((Object)cci));
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        this.notifyPropertyChange(event);
    }

    protected void firePropertyChange(PropertyChangeEvent event) {
        this.notifyPropertyChange(event);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.allPropertyChangeListeners == null) {
            this.allPropertyChangeListeners = new PropertyChangeListenerList();
        }
        this.allPropertyChangeListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.allPropertyChangeListeners != null) {
            this.allPropertyChangeListeners.remove(listener);
        }
    }

    protected void notifyPropertyChange(PropertyChangeEvent event) {
        if (this.allPropertyChangeListeners == null) {
            return;
        }
        for (PropertyChangeListener listener : this.allPropertyChangeListeners.getListeners()) {
            listener.propertyChange(event);
        }
    }

    @Override
    public boolean attachView() {
        return true;
    }

    @Override
    public void detachView() {
    }

    public String toString() {
        return this.getNodeText();
    }

    public void setNodeStyle(StaticPropertyBagInterface newValue) {
        StaticPropertyBagInterface oldValue = this.getNodeStyle();
        this.nodeStyle = newValue;
        newValue = this.getNodeStyle();
        if (Util.unequal((Object)oldValue, (Object)newValue)) {
            this.firePropertyChange("nodeStyle", oldValue, newValue);
        }
    }

    public void setDefaultNodeStyle(StaticPropertyBagInterface newValue) {
        StaticPropertyBagInterface oldValue = this.getDefaultNodeStyle();
        this.defaultNodeStyle = newValue;
        newValue = this.getDefaultNodeStyle();
        if (Util.unequal((Object)oldValue, (Object)newValue)) {
            this.firePropertyChange("defaultNodeStyle", oldValue, newValue);
        }
    }
}

