/*
 * Decompiled with CFR 0.152.
 */
package com.sas.models;

import com.sas.PublicClonable;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.AssociationList;
import com.sas.models.RB;
import java.awt.Color;
import java.awt.SystemColor;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class ColorNameList
extends AssociationList
implements PublicClonable {
    static final long serialVersionUID = -6033296540291263836L;
    protected boolean showSystemColors = true;
    static final String RB_KEY = "ColorNameList.";

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public ColorNameList() {
        this(true, true);
    }

    public ColorNameList(boolean showSystemColors) {
        this(true, showSystemColors);
    }

    public ColorNameList(boolean showColors, boolean showSystemColors) {
        if (showColors) {
            this.setColorNameList();
        }
        this.showSystemColors = showSystemColors;
        if (showSystemColors) {
            this.setSystemColorList();
        }
    }

    public ColorNameList(Enumeration e) {
        while (e.hasMoreElements()) {
            this.add((Color)e.nextElement());
        }
    }

    public void add(String name, int hexValue) {
        com.sas.awt.Color c = new com.sas.awt.Color(hexValue);
        if (!this.containsKey(c)) {
            this.setSize(this.count() + 1);
            this.set(c, (Object)name.toLowerCase());
        }
    }

    public void add(String name, Color c) {
        if (c instanceof SystemColor) {
            if (!this.contains(c)) {
                this.setSize(this.count() + 1);
                this.set(this.count() - 1, c, name.toLowerCase());
            }
        } else if (c instanceof com.sas.awt.Color) {
            if (!this.contains(((com.sas.awt.Color)c).getName())) {
                this.setSize(this.count() + 1);
                this.set(this.count() - 1, c, name.toLowerCase());
            }
        } else {
            com.sas.awt.Color tc = com.sas.awt.Color.newColor(c);
            if (!this.contains(tc.getName())) {
                this.setSize(this.count() + 1);
                this.set(this.count() - 1, tc, name.toLowerCase());
            }
        }
    }

    public void add(int hexValue) {
        com.sas.awt.Color c = new com.sas.awt.Color(hexValue);
        if (!this.containsKey(c)) {
            this.setSize(this.count() + 1);
            this.set(c, (Object)Integer.toHexString(hexValue));
        }
    }

    @Override
    public void add(Object c) {
        if (c instanceof Color || c instanceof com.sas.awt.Color || c instanceof SystemColor) {
            int rgb = ((com.sas.awt.Color)c).getRGB();
            if (!this.containsKey(c)) {
                this.setSize(this.count() + 1);
                this.set(c, (Object)Integer.toHexString(rgb));
            }
        } else {
            throw new ClassCastException(RB.getStringResource((String)RB_KEY, (String)"invalidobj.ex.txt"));
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ColorNameList newData = (ColorNameList)super.clone();
        return newData;
    }

    public void setShowSystemColors(boolean bool) {
        if (this.showSystemColors != bool) {
            this.removeAll();
            this.setColorNameList();
            this.showSystemColors = bool;
            if (this.showSystemColors) {
                this.setSystemColorList();
            }
        }
    }

    public boolean getShowSystemColors() {
        return this.showSystemColors;
    }

    private void setColorNameList() {
        this.set(com.sas.awt.Color.newColor(com.sas.awt.Color.black), (Object)RB.getStringResource((String)"black.txt"));
        this.set(com.sas.awt.Color.newColor(com.sas.awt.Color.blue), (Object)RB.getStringResource((String)"blue.txt"));
        this.set(com.sas.awt.Color.newColor(com.sas.awt.Color.cyan), (Object)RB.getStringResource((String)"cyan.txt"));
        this.set(com.sas.awt.Color.newColor(com.sas.awt.Color.darkGray), (Object)RB.getStringResource((String)"darkgray.txt"));
        this.set(com.sas.awt.Color.newColor(com.sas.awt.Color.gray), (Object)RB.getStringResource((String)"gray.txt"));
        this.set(com.sas.awt.Color.newColor(com.sas.awt.Color.green), (Object)RB.getStringResource((String)"green.txt"));
        this.set(com.sas.awt.Color.newColor(com.sas.awt.Color.lightGray), (Object)RB.getStringResource((String)"lightgray.txt"));
        this.set(com.sas.awt.Color.newColor(com.sas.awt.Color.magenta), (Object)RB.getStringResource((String)"magenta.txt"));
        this.set(com.sas.awt.Color.newColor(com.sas.awt.Color.orange), (Object)RB.getStringResource((String)"orange.txt"));
        this.set(com.sas.awt.Color.newColor(com.sas.awt.Color.pink), (Object)RB.getStringResource((String)"pink.txt"));
        this.set(com.sas.awt.Color.newColor(com.sas.awt.Color.red), (Object)RB.getStringResource((String)"red.txt"));
        this.set(com.sas.awt.Color.newColor(com.sas.awt.Color.white), (Object)RB.getStringResource((String)"white.txt"));
        this.set(com.sas.awt.Color.newColor(com.sas.awt.Color.yellow), (Object)RB.getStringResource((String)"yellow.txt"));
    }

    private void setSystemColorList() {
        this.set(SystemColor.activeCaption, (Object)"ACTIVE_CAPTION");
        this.set(SystemColor.activeCaptionBorder, (Object)"ACTIVE_CAPTION_BORDER");
        this.set(SystemColor.activeCaptionText, (Object)"ACTIVE_CAPTION_TEXT");
        this.set(SystemColor.control, (Object)"CONTROL");
        this.set(SystemColor.controlDkShadow, (Object)"CONTROL_DK_SHADOW");
        this.set(SystemColor.controlHighlight, (Object)"CONTROL_HIGHLIGHT");
        this.set(SystemColor.controlLtHighlight, (Object)"CONTROL_LT_HIGHLIGHT");
        this.set(SystemColor.controlShadow, (Object)"CONTROL_SHADOW");
        this.set(SystemColor.controlText, (Object)"CONTROL_TEXT");
        this.set(SystemColor.desktop, (Object)"DESKTOP");
        this.set(SystemColor.inactiveCaption, (Object)"INACTIVE_CAPTION");
        this.set(SystemColor.inactiveCaptionBorder, (Object)"INACTIVE_CAPTION_BORDER");
        this.set(SystemColor.inactiveCaptionText, (Object)"INACTIVE_CAPTION_TEXT");
        this.set(SystemColor.info, (Object)"INFO");
        this.set(SystemColor.infoText, (Object)"INFO_TEXT");
        this.set(SystemColor.menu, (Object)"MENU");
        this.set(SystemColor.menuText, (Object)"MENU_TEXT");
        this.set(SystemColor.scrollbar, (Object)"SCROLLBAR");
        this.set(SystemColor.text, (Object)"TEXT");
        this.set(SystemColor.textHighlight, (Object)"TEXT_HIGHLIGHT");
        this.set(SystemColor.textHighlightText, (Object)"TEXT_HIGHLIGHT_TEXT");
        this.set(SystemColor.textInactiveText, (Object)"TEXT_INACTIVE_TEXT");
        this.set(SystemColor.textText, (Object)"TEXT_TEXT");
        this.set(SystemColor.window, (Object)"WINDOW");
        this.set(SystemColor.windowBorder, (Object)"WINDOW_BORDER");
        this.set(SystemColor.windowText, (Object)"WINDOW_TEXT");
    }

    public Color getColor(String colorName) {
        if (this.contains(colorName)) {
            return (Color)this.getKey(colorName);
        }
        if (this.contains(colorName.toLowerCase())) {
            return (Color)this.getKey(colorName.toLowerCase());
        }
        if (this.contains(colorName.toUpperCase())) {
            return (Color)this.getKey(colorName.toUpperCase());
        }
        throw new NoSuchElementException(RB.getStringResource((String)"colorNotFound.ex.txt"));
    }

    public String getColorName(Color color) {
        if (this.containsKey(color)) {
            return (String)this.get(color);
        }
        throw new NoSuchElementException(RB.getStringResource((String)"colorNotFound.ex.txt"));
    }

    public synchronized Enumeration getColors() {
        return this.getKeys();
    }
}

