/*
 * Decompiled with CFR 0.152.
 */
package com.sas.measures;

import com.sas.collection.AssociationList;
import com.sas.collection.AssociationListInterface;
import com.sas.collection.OrderedCollection;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.measures.Measure;
import com.sas.measures.RB;
import com.sas.measures.UnitInfo;
import com.sas.text.Message;

public class Time
extends Measure {
    public static final String RB_KEY = "Time.";
    private static final double PS_PER_MS = 1.0E-6;
    private static final double US_PER_MS = 0.001;
    private static final double S_PER_MS = 1000.0;
    private static final double M_PER_MS = 60000.0;
    private static final double H_PER_MS = 3600000.0;
    private static final double D_PER_MS = 8.64E7;
    private static final double W_PER_MS = 6.048E8;
    private static final double Y_PER_MS = 3.1556736E10;
    private static final double LY_PER_MS = 3.16224E10;
    private static final double MO_PER_MS = 2.629728E9;
    private static final double C_PER_MS = 3.1556736E12;
    private static final double MILLE_PER_MS = 3.1556736E13;
    private static final int PS = 0;
    private static final int US = 1;
    private static final int MS = 2;
    private static final int S = 3;
    private static final int M = 4;
    private static final int H = 5;
    private static final int D = 6;
    private static final int W = 7;
    private static final int MO = 8;
    private static final int Y = 9;
    private static final int LY = 10;
    private static final int C = 11;
    private static final int MILLE = 12;
    private static final UnitInfo[] UnitInfo = new UnitInfo[]{new UnitInfo("ps", 0, 1.0E-6, RB.getStringResource((String)"Time.", (String)"ps.txt")), new UnitInfo("us", 1, 0.001, RB.getStringResource((String)"Time.", (String)"us.txt")), new UnitInfo("ms", 2, 1.0, RB.getStringResource((String)"Time.", (String)"ms.txt")), new UnitInfo("s", 3, 1000.0, RB.getStringResource((String)"Time.", (String)"s.txt")), new UnitInfo("m", 4, 60000.0, RB.getStringResource((String)"Time.", (String)"m.txt")), new UnitInfo("h", 5, 3600000.0, RB.getStringResource((String)"Time.", (String)"h.txt")), new UnitInfo("d", 6, 8.64E7, RB.getStringResource((String)"Time.", (String)"d.txt")), new UnitInfo("w", 7, 6.048E8, RB.getStringResource((String)"Time.", (String)"w.txt")), new UnitInfo("mo", 8, 2.629728E9, RB.getStringResource((String)"Time.", (String)"mo.txt")), new UnitInfo("y", 9, 3.1556736E10, RB.getStringResource((String)"Time.", (String)"y.txt")), new UnitInfo("ly", 10, 3.16224E10, RB.getStringResource((String)"Time.", (String)"ly.txt")), new UnitInfo("c", 11, 3.1556736E12, RB.getStringResource((String)"Time.", (String)"c.txt")), new UnitInfo("mille", 12, 3.1556736E13, RB.getStringResource((String)"Time.", (String)"mille.txt"))};
    private int unit_index;

    public Time(double magnitude, String unitOfTime) {
        super(magnitude, (Object)unitOfTime);
    }

    public Time(String text) {
        super(text);
    }

    public Time(long millis) {
        super((double)millis, (Object)"ms");
    }

    public double getMagnitude(Object unit) {
        int du_index = this.parseUnit(unit);
        if (du_index == -1) {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource((String)"invalidUnit.ex.txt"), (Object)unit));
        }
        return this.internalGetMagnitude(UnitInfo[this.unit_index], UnitInfo[du_index], this.magnitude);
    }

    public Object getUnit() {
        return Time.UnitInfo[this.unit_index].name;
    }

    public String getUnitName() {
        return Time.UnitInfo[this.unit_index].longName;
    }

    protected void initializeUnit(Object unit) {
        this.unit_index = this.parseUnit(unit);
        if (this.unit_index == -1) {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource((String)"invalidUnit.ex.txt"), (Object)unit));
        }
    }

    public boolean validateUnit(String unit) {
        return this.parseUnit(unit) != -1;
    }

    private int parseUnit(Object unit) {
        int index;
        for (index = 0; index < UnitInfo.length; ++index) {
            if (!Time.UnitInfo[index].name.equals(unit)) continue;
            return index;
        }
        for (index = 0; index < UnitInfo.length; ++index) {
            if (!Time.UnitInfo[index].longName.equals(unit)) continue;
            return index;
        }
        return -1;
    }

    private double internalGetMagnitude(UnitInfo srcInfo, UnitInfo dstInfo, double magnitude) {
        return magnitude * (dstInfo.normf / srcInfo.normf);
    }

    public static AssociationListInterface makeUnitsAssociationList() {
        AssociationList aList = new AssociationList();
        Time ms = new Time(1L);
        for (UnitInfo info : UnitInfo) {
            double d = ms.getMagnitude(info.name);
            aList.set(info.longName, (Object)new Double(d));
        }
        return aList;
    }

    public static StaticOrderedCollectionInterface makeUnitsList() {
        OrderedCollection oc = new OrderedCollection();
        int l = UnitInfo.length;
        for (int i = 0; i < l; ++i) {
            oc.add(Time.UnitInfo[i].longName);
        }
        return oc;
    }
}

