/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lang;

import com.sas.Component;
import com.sas.PublicClonable;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.lang.FloatDataInterface;
import com.sas.lang.RB;
import com.sas.lang.StringDataInterface;
import com.sas.util.NumberUtil;

public class FloatData
extends Component
implements PublicClonable,
FloatDataInterface,
StringDataInterface {
    private float value;
    static final long serialVersionUID = 2582329811758091208L;
    public static final String RB_KEY = "FloatData.";

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "floatData"}, {"Default value", ""}, {"Description", RB.getStringResource(RB_KEY, "floatData.pd.txt")}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "floatData";
        ebi.defaultOutputPropertyName = "floatData";
        ebi.shortDescription = RB.getStringResource(RB_KEY, "description.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public static String toString(Float value) {
        return NumberUtil.toString((Float)value);
    }

    public static String toString(float d) {
        return NumberUtil.toString((float)d);
    }

    public static float valueOf(String floatString) {
        return NumberUtil.floatValueOf((String)floatString);
    }

    public FloatData() {
    }

    public FloatData(float value) {
        this.setFloatData(value);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        FloatData newData = (FloatData)super.clone();
        return newData;
    }

    public boolean equals(FloatData other) {
        return other.getFloatData() == this.getFloatData();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof FloatData) {
            return this.equals((FloatData)object);
        }
        return false;
    }

    public float getFloatData() {
        return this.value;
    }

    public String getText() {
        return this.toString();
    }

    public int hashCode() {
        return Float.floatToIntBits(this.getFloatData());
    }

    public synchronized void setFloatData(float value) {
        float oldValue = this.getFloatData();
        if (oldValue == value) {
            return;
        }
        String oldText = this.toString();
        this.value = value;
        this.firePropertyChange("floatData", new Float(oldValue), new Float(this.getFloatData()));
        this.firePropertyChange("text", oldText, this.toString());
    }

    public void setText(String string) {
        try {
            float temp = FloatData.valueOf(string);
            this.setFloatData(temp);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public String toString() {
        return NumberUtil.toString((float)this.value);
    }
}

