/*
 * Decompiled with CFR 0.152.
 */
package com.sas.collection.hlist;

import com.sas.collection.hlist.HListItem;
import com.sas.collection.hlist.StreamEnv;
import com.sas.io.Encoder;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class StringItem
extends HListItem {
    static final long serialVersionUID = 6924906818862201202L;
    protected String value;
    public static final char streamCode = 'S';
    public static final byte itemType = 2;

    public StringItem() {
        this.value = "";
    }

    public StringItem(StringItem item) {
        this.value = item.value;
    }

    public StringItem(String value) {
        if (value == null) {
            value = "";
        }
        this.value = value;
    }

    public StringItem(String value, String name, short attributes) {
        super(name, attributes);
        if (value == null) {
            value = "";
        }
        this.value = value;
    }

    public StringItem(String value, String name) {
        super(name);
        if (value == null) {
            value = "";
        }
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public boolean equals(Object other) {
        if (other instanceof StringItem) {
            StringItem otherString = (StringItem)other;
            return this.value.equals(otherString.value);
        }
        return false;
    }

    @Override
    public String toString() {
        return super.toString() + this.value;
    }

    @Override
    public Object toObject() {
        return this.value;
    }

    @Override
    public void read(DataInputStream stream) throws IOException {
        super.read(stream);
        this.value = Encoder.readUTF((DataInput)stream);
    }

    @Override
    protected void read(DataInputStream stream, StreamEnv env) throws IOException {
        super.read(stream, env);
        this.value = this.readString(stream, env);
    }

    @Override
    protected final char streamCode() {
        return 'S';
    }

    @Override
    protected final byte itemType() {
        return 2;
    }

    @Override
    public void write(DataOutputStream stream) throws IOException {
        super.write(stream);
        stream.writeUTF(this.value);
    }

    @Override
    public void write(DataOutputStream stream, StreamEnv env) throws IOException {
        super.write(stream, env);
        if (env.version >= 3) {
            this.writeString(this.value, stream, env);
        } else {
            stream.writeUTF(this.value);
        }
    }
}

