/*
 * Decompiled with CFR 0.152.
 */
package com.sas.collection.hlist;

import com.sas.collection.hlist.HList;
import com.sas.collection.hlist.HListInterface;
import com.sas.collection.hlist.HListItem;
import com.sas.collection.hlist.StreamEnv;
import com.sas.util.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ListItem
extends HListItem {
    static final long serialVersionUID = -5371725108692453945L;
    protected HListInterface value;
    public static final char streamCode = 'L';
    public static final byte itemType = 3;

    public ListItem() {
    }

    public ListItem(ListItem item) {
        this.value = item.value;
    }

    public ListItem(HListInterface value) {
        this.value = value;
    }

    public ListItem(HListInterface value, String name, short attributes) {
        super(name, attributes);
        this.value = value;
    }

    public ListItem(HListInterface value, String name) {
        super(name);
        this.value = value;
    }

    public HListInterface getValue() {
        return this.value;
    }

    public void setValue(HListInterface list) {
        this.value = list;
    }

    public boolean equals(Object other) {
        if (other instanceof ListItem) {
            ListItem otherList = (ListItem)other;
            return Util.equal((Object)this.value, (Object)otherList.value);
        }
        return false;
    }

    @Override
    public String toString() {
        String result = super.toString();
        result = result + "[" + (this.value == null ? 0 : this.value.getId()) + "]";
        return result;
    }

    @Override
    public Object toObject() {
        return this.value;
    }

    @Override
    public void read(DataInputStream stream) throws IOException {
        super.read(stream);
        byte isListValid = stream.readByte();
        this.value = isListValid > 0 ? new HList(stream) : null;
    }

    @Override
    public void read(DataInputStream stream, StreamEnv env) throws IOException {
        super.read(stream, env);
        byte isListValid = stream.readByte();
        this.value = isListValid > 0 ? new HList(stream, env) : null;
    }

    @Override
    protected final char streamCode() {
        return 'L';
    }

    @Override
    protected final byte itemType() {
        return 3;
    }

    @Override
    public void write(DataOutputStream stream) throws IOException {
        super.write(stream);
        stream.writeByte((byte)(this.value != null ? 1 : 0));
        if (this.value != null) {
            this.value.write(stream);
        }
    }

    @Override
    public void write(DataOutputStream stream, StreamEnv env) throws IOException {
        super.write(stream, env);
        stream.writeByte((byte)(this.value != null ? 1 : 0));
        if (this.value != null) {
            ((HList)this.value).write(stream, env);
        }
    }
}

