/*
 * Decompiled with CFR 0.152.
 */
package com.sas.collection.hlist;

import com.sas.PublicClonable;
import com.sas.collection.hlist.ArrayItem;
import com.sas.collection.hlist.DoubleItem;
import com.sas.collection.hlist.HList;
import com.sas.collection.hlist.HListAttributes;
import com.sas.collection.hlist.ListItem;
import com.sas.collection.hlist.StreamEnv;
import com.sas.collection.hlist.StringItem;
import com.sas.io.Encoder;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Hashtable;

public abstract class HListItem
implements PublicClonable,
Serializable {
    static final long serialVersionUID = 7370904303741104567L;
    protected static Hashtable classTable;
    protected static final short ITEM_ATTR_MASK = 255;
    protected String name;
    short attributes;
    protected final char ITEM_HAS_NAME = (char)16;
    protected final char ITEM_HAS_ATTRS = (char)32;
    private static final int HAS_NAME_MASK = 128;
    private static final int HAS_ATTR_MASK = 64;
    private static final int UNUSED_MASK = 32;
    private static final int ITEM_BIT_MASK = 31;
    private static final String EmptyString = "";

    public HListItem() {
    }

    public HListItem(String name, short attributes) {
        this.name = name == null ? null : HListItem.intern(name);
        this.attributes = (short)(attributes & 0xFF);
    }

    public HListItem(String name) {
        this.name = name == null ? null : HListItem.intern(name);
        this.attributes = 0;
    }

    protected static String intern(String string) {
        return HList.intern(string);
    }

    public HListItem(HListItem item) {
        this.name = item.name;
        this.attributes = item.attributes;
    }

    protected static HListItem newFromStream(DataInputStream stream) throws IOException {
        char itemType = stream.readChar();
        HListItem item = null;
        if (itemType == 'D') {
            item = new DoubleItem();
        } else if (itemType == 'S') {
            item = new StringItem();
        } else if (itemType == 'L') {
            item = new ListItem();
        } else {
            throw new IOException("Unexpected item type: '" + itemType + "'");
        }
        ((HListItem)item).read(stream);
        return item;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static HListItem newFromStream(DataInputStream stream, StreamEnv env) throws IOException {
        void var4_11;
        Object var4_2 = null;
        if (env.version >= 3) {
            byte code = stream.readByte();
            boolean hasName = (code & 0x80) == 128;
            boolean hasAttrs = (code & 0x40) == 64;
            int itemType = code & 0x1F;
            env.readNextItemAttrs = hasAttrs;
            env.readNextItemName = hasName;
            if (itemType == 1) {
                DoubleItem doubleItem = new DoubleItem();
            } else if (itemType == 2) {
                StringItem stringItem = new StringItem();
            } else if (itemType == 3) {
                ListItem listItem = new ListItem();
            } else {
                if (itemType != 5) throw new IOException("Unexpected item type: '" + itemType + "'");
                ArrayItem arrayItem = new ArrayItem();
            }
        } else {
            char itemType = stream.readChar();
            env.readNextItemAttrs = true;
            env.readNextItemName = true;
            if (itemType == 'D') {
                DoubleItem doubleItem = new DoubleItem();
            } else if (itemType == 'S') {
                StringItem stringItem = new StringItem();
            } else {
                if (itemType != 'L') throw new IOException("Unexpected item type: '" + itemType + "'");
                ListItem listItem = new ListItem();
            }
        }
        var4_11.read(stream, env);
        return var4_11;
    }

    protected void read(DataInputStream stream) throws IOException {
        String sName = HListItem.readUTF(stream);
        if (sName == EmptyString || sName.length() == 0) {
            this.setName(null);
        } else {
            this.setName(sName);
        }
        short sAttributes = stream.readShort();
        this.setAttributes(sAttributes, true);
    }

    protected void read(DataInputStream stream, StreamEnv env) throws IOException {
        String name = null;
        if (env.readNextItemName && ((name = this.readString(stream, env)) == EmptyString || name.length() == 0)) {
            name = null;
        }
        this.setName(name);
        short attributes = 0;
        if (env.readNextItemAttrs) {
            attributes = stream.readShort();
        }
        this.setAttributes(attributes, true);
    }

    protected String readString(DataInputStream stream, StreamEnv env) throws IOException {
        return env.readString(stream);
    }

    protected void writeString(String string, DataOutputStream stream, StreamEnv env) throws IOException {
        env.writeString(string, stream);
    }

    protected abstract char streamCode();

    protected abstract byte itemType();

    public static final String readUTF(DataInput in) throws IOException {
        return Encoder.readUTF((DataInput)in);
    }

    private void readObject(ObjectInputStream stream) throws IOException {
        try {
            stream.defaultReadObject();
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe.getMessage());
        }
        if (this.name != null) {
            this.setName(this.name);
        }
    }

    protected void write(DataOutputStream stream) throws IOException {
        this.write(stream, new StreamEnv(1, null));
    }

    protected void write(DataOutputStream stream, StreamEnv env) throws IOException {
        if (env.version >= 3) {
            boolean hasName;
            byte code = this.itemType();
            boolean bl = hasName = this.name != null && this.name.length() > 0;
            if (hasName) {
                code = (byte)(code | 0x80);
            }
            if (this.attributes != 0) {
                code = (byte)(code | 0x40);
            }
            stream.writeByte(code);
            if (hasName) {
                this.writeString(this.name, stream, env);
            }
            if (this.attributes != 0) {
                stream.writeShort(this.attributes);
            }
        } else {
            stream.writeChar(this.streamCode());
            this.writeString(this.name, stream, env);
            stream.writeShort(this.attributes);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void setName(String name) {
        this.name = name == null ? null : HListItem.intern(name);
    }

    public String getName() {
        return this.name;
    }

    public void setAttribute(HListAttributes attr, boolean state) {
        short attrValue = (short)(0xFF & attr.getValue());
        this.attributes = state ? (short)(this.attributes | attrValue) : (short)(this.attributes & (short)(~attrValue));
    }

    protected void setAttributes(short attrs, short mask) {
        this.attributes = (short)(0xFF & (this.attributes & ~mask | attrs & mask));
    }

    public void setAttributes(short attrs, boolean state) {
        if (state) {
            this.attributes = (short)(this.attributes | (short)(0xFF & attrs));
        } else {
            attrs = (short)(attrs & (short)(0xFF & ~attrs));
        }
    }

    public boolean hasAttribute(HListAttributes attr) {
        int attrValue = attr.getValue();
        return (this.attributes & attrValue) != 0;
    }

    public boolean hasAttributes(HListAttributes[] attrs) {
        short attrValue;
        boolean has = true;
        for (int i = 0; has && i < attrs.length; has |= (this.attributes & (attrValue = (short)(0xFF & attrs[i].getValue()))) != 0, ++i) {
        }
        return has;
    }

    public String toString() {
        if (this.name == null) {
            return EmptyString;
        }
        return this.name + "=";
    }

    protected static void add(Class itemClass) {
    }

    protected static boolean add(String name) {
        return false;
    }

    public abstract Object toObject();
}

