/*
 * Decompiled with CFR 0.152.
 */
package com.sas.collection;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.AVLNode;
import com.sas.collection.AVLTree;
import com.sas.collection.BaseCollection;
import com.sas.collection.CollectionChangedInfo;
import com.sas.collection.HowChanged;
import com.sas.collection.IndexedEnumeration;
import com.sas.collection.RB;
import com.sas.collection.SortedCollectionInterface;
import com.sas.collection.StaticCollectionInterface;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.util.ApplyInterface;
import com.sas.util.Comparator;
import com.sas.util.GenericComparator;
import com.sas.util.Util;
import com.sas.util.transforms.StaticOrderedCollectionInterfaceToStringTransform;
import com.sas.util.transforms.StringToCollectionInterfaceTransform;
import com.sas.util.transforms.TransformException;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class SortedCollection
extends BaseCollection
implements SortedCollectionInterface {
    static final long serialVersionUID = 8762854648297041043L;
    private Comparator comparator;
    private boolean allowDuplicates;
    protected AVLTree avlTree;
    public static final String RB_KEY = "SortedCollection.";
    private transient AVLNode.Cursor cursor;
    private transient int currentIndex;
    private transient Object currentItem;

    public SortedCollection() {
        this(null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedCollection(Object[] array, Comparator comparator, boolean allowDuplicates) {
        this(comparator, allowDuplicates);
        Object[] objectArray = array;
        synchronized (array) {
            for (int i = 0; i < array.length; ++i) {
                this.add(array[i]);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedCollection(Enumeration e, Comparator comparator, boolean allowDuplicates) {
        this(comparator, allowDuplicates);
        Enumeration enumeration = e;
        synchronized (enumeration) {
            while (e.hasMoreElements()) {
                this.add(e.nextElement());
            }
        }
    }

    public SortedCollection(StaticCollectionInterface items, Comparator comparator, boolean allowDuplicates) {
        this(items.getItems(), comparator, allowDuplicates);
    }

    public SortedCollection(String data, Comparator comparator, boolean allowDuplicates) {
        this(comparator, allowDuplicates);
        try {
            new StringToCollectionInterfaceTransform().transform(this, data);
        }
        catch (TransformException te) {
            throw new IllegalArgumentException(te.getMessage());
        }
    }

    protected Comparator newComparator() {
        return new GenericComparator();
    }

    public SortedCollection(Comparator comparator) {
        this(comparator, true);
    }

    public SortedCollection(Comparator comparator, boolean allowDuplicates) {
        if (comparator == null) {
            comparator = this.newComparator();
        }
        this.avlTree = new AVLTree(comparator, allowDuplicates);
        this.setComparator(comparator);
        this.setDuplicatesAllowed(allowDuplicates);
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "comparator"}, {"Short description", RB.getStringResource((String)"SortedCollection.comparator.pd.txt")}, {"Bound", "false"}, {"Linkable", "false"}, {"Compare value", "false"}, {"Constrained", "false"}, {"Expert", "true"}, {"Hidden", "true"}}, {{"Name", "duplicatesAllowed"}, {"Short description", RB.getStringResource((String)"SortedCollection.duplicatedAllowed.pd.txt")}, {"Bound", "false"}, {"Linkable", "false"}, {"Compare value", "false"}, {"Constrained", "false"}, {"Expert", "true"}, {"Hidden", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"description.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public void setDuplicatesAllowed(boolean duplicatesAllowed) {
        if (duplicatesAllowed != this.allowDuplicates) {
            this.allowDuplicates = duplicatesAllowed;
            if (!this.allowDuplicates) {
                this.sort();
            }
        }
    }

    public boolean isDuplicatesAllowed() {
        return this.allowDuplicates;
    }

    public void setComparator(Comparator newComparator) {
        if (newComparator == null) {
            newComparator = this.newComparator();
        }
        if (Util.unequal((Object)this.comparator, (Object)newComparator)) {
            this.comparator = newComparator;
            this.sort();
        }
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void sort() {
        int count = this.count();
        if (count == 0) {
            return;
        }
        try {
            this.disableEvents();
            AVLTree oldTree = this.avlTree;
            this.avlTree = new AVLTree(this.getComparator(), this.isDuplicatesAllowed());
            Enumeration e = oldTree.getItems();
            while (e.hasMoreElements()) {
                this.add(e.nextElement());
            }
        }
        finally {
            this.enableEvents();
        }
    }

    @Override
    public synchronized void removeAt(int index) {
        Object object = this.get(index);
        this.remove(object);
    }

    @Override
    public synchronized void add(Object item) {
        this.avlTree.add(item);
        this.invalidate();
        this.fireContentsChanged(new CollectionChangedInfo((Object)this, item, HowChanged.ADDED));
    }

    @Override
    public synchronized void addItems(Enumeration items) {
        this.invalidate();
        while (items.hasMoreElements()) {
            this.add(items.nextElement());
        }
    }

    @Override
    public synchronized boolean remove(Object element) {
        this.invalidate();
        boolean removed = this.avlTree.remove(element);
        if (removed) {
            this.fireContentsChanged(new CollectionChangedInfo((Object)this, element, HowChanged.REMOVED));
        }
        return removed;
    }

    @Override
    public synchronized void removeAll() {
        int count = this.count();
        if (count > 0) {
            this.invalidate();
            this.avlTree.removeAll();
            this.fireContentsChanged(new CollectionChangedInfo((Object)this, HowChanged.REMOVED, 0, count - 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int removeAll(Object element) {
        int count = 0;
        try {
            this.disableEvents();
            boolean found = true;
            while (found) {
                this.invalidate();
                found = this.remove(element);
                ++count;
            }
        }
        finally {
            if (count > 0) {
                this.enableEvents();
            } else {
                this.enableEvents(null);
            }
        }
        return 0;
    }

    @Override
    public synchronized boolean equals(StaticOrderedCollectionInterface orderedCollection) {
        return Util.equal((Enumeration)this.getItems(), (Enumeration)orderedCollection.getItems());
    }

    public boolean equals(Object object) {
        return object != null && object instanceof StaticOrderedCollectionInterface && this.equals((StaticOrderedCollectionInterface)object);
    }

    @Override
    public synchronized int getIndex(Object element, int startIndex) {
        try {
            Enumeration e = this.getItems(startIndex, this.count());
            int index = startIndex;
            Comparator c = this.getComparator();
            while (e.hasMoreElements()) {
                if (c.compare(e.nextElement(), element) == 0) {
                    return index;
                }
                ++index;
            }
        }
        catch (Exception e) {
            throw new NoSuchElementException();
        }
        return -1;
    }

    @Override
    public Enumeration getItems(int start, int end) {
        return this.avlTree.getItems(start, end);
    }

    @Override
    public int getLastIndex(Object element, int startIndex) {
        try {
            int endIndex = this.count() - 1;
            AVLNode.Cursor e = this.avlTree.getItems(true);
            if (startIndex != endIndex) {
                e = new IndexedEnumeration((Enumeration)e, endIndex - startIndex, this.count());
            }
            int index = startIndex;
            Comparator c = this.getComparator();
            while (e.hasMoreElements()) {
                if (c.compare(e.nextElement(), element) == 0) {
                    return index;
                }
                --index;
            }
        }
        catch (Exception e) {
            throw new NoSuchElementException();
        }
        return -1;
    }

    @Override
    public void apply(ApplyInterface action) {
        Enumeration e = this.getItems();
        while (e.hasMoreElements()) {
            if (action.apply(e.nextElement()) == 0) continue;
            break;
        }
    }

    @Override
    public boolean contains(Object element) {
        return this.avlTree.contains(element);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SortedCollection newCollection = (SortedCollection)super.clone();
        newCollection.avlTree = (AVLTree)this.avlTree.clone();
        return newCollection;
    }

    protected void invalidate() {
        this.cursor = null;
        this.currentItem = null;
    }

    @Override
    public synchronized Object get(int index) {
        int count = this.count();
        if (count == 0 || index < 0 || index > count) {
            throw new IndexOutOfBoundsException("" + index);
        }
        if (this.cursor != null) {
            try {
                if (index == this.currentIndex) {
                    return this.currentItem;
                }
                if (index > this.currentIndex && this.currentIndex - index <= count - index) {
                    while (this.currentIndex < index) {
                        this.currentItem = this.cursor.forwardElement();
                        ++this.currentIndex;
                    }
                    return this.currentItem;
                }
                if (index < this.currentIndex && this.currentIndex - index <= index) {
                    while (this.currentIndex > index) {
                        this.currentItem = this.cursor.backwardElement();
                        --this.currentIndex;
                    }
                    return this.currentItem;
                }
                this.invalidate();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IndexOutOfBoundsException("" + index);
            }
        }
        if (index > count - index) {
            this.cursor = this.avlTree.getItems(true);
            this.currentIndex = count;
            this.currentItem = null;
            return this.get(index);
        }
        this.cursor = this.avlTree.getItems(false);
        this.currentIndex = -1;
        this.currentItem = null;
        return this.get(index);
    }

    @Override
    public int count() {
        return this.avlTree.count();
    }

    @Override
    public Enumeration getItems() {
        return this.avlTree.getItems();
    }

    public String toString() {
        return (String)StaticOrderedCollectionInterfaceToStringTransform.defaultInstance.transform(this);
    }

    public synchronized Object[] toArray() {
        int n = this.count();
        Object[] items = new Object[n];
        for (int i = 0; i < n; ++i) {
            items[i] = this.get(i);
        }
        return items;
    }

    AVLTree getTree() {
        return this.avlTree;
    }
}

