/*
 * Decompiled with CFR 0.152.
 */
package com.sas.collection;

import com.sas.collection.OrderedCollectionEnumeration;
import com.sas.collection.OrderedListCollection;
import com.sas.util.Enumerator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.NoSuchElementException;

class OrderedListCollectionEnumeration
extends OrderedCollectionEnumeration {
    static final long serialVersionUID = 3013579630404544358L;
    transient OrderedListCollection.Node current;
    OrderedListCollection orderedList;
    transient int lastIndex;

    OrderedListCollectionEnumeration(OrderedListCollection orderedList) {
        this(orderedList, 0, -1);
    }

    protected OrderedListCollectionEnumeration(OrderedListCollection orderedList, int start) {
        this(orderedList, start, -1);
    }

    protected OrderedListCollectionEnumeration(OrderedListCollection orderedList, int start, int end) {
        super(orderedList, start, end);
        this.orderedList = orderedList;
        this.current = orderedList.nodeBefore(start);
        this.lastIndex = end;
    }

    @Override
    public Object nextElement() {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        if (this.current.next == null) {
            try {
                this.current = this.orderedList.nodeBefore(this.index);
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }
        this.current = this.current.next;
        ++this.index;
        return this.current.item;
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        int currentIndex = -1;
        out.writeInt(currentIndex);
        out.writeInt(this.lastIndex);
    }

    private synchronized void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.lastIndex = in.readInt();
        this.current = this.orderedList.items;
        this.current = this.orderedList.nodeBefore(this.index);
    }

    @Override
    public Enumerator finish() {
        this.orderedList = null;
        return super.finish();
    }
}

