/*
 * Decompiled with CFR 0.152.
 */
package com.sas.beans.editors;

import com.sas.RunningObjectTable;
import com.sas.beans.PropertyEditor;
import com.sas.beans.PropertyEditorBeanRequestor;
import com.sas.beans.PropertyEditorDescriptorRequestor;
import com.sas.text.Message;
import com.sas.util.Util;
import java.beans.PropertyDescriptor;
import java.util.Enumeration;

public class _InstanceEditor
extends PropertyEditor
implements PropertyEditorBeanRequestor,
PropertyEditorDescriptorRequestor {
    protected Object bean = null;
    protected PropertyDescriptor propertyDescriptor;
    protected Class[] implementedClasses;

    public PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    public void setPropertyDescriptor(PropertyDescriptor propDesc) {
        this.propertyDescriptor = propDesc;
        if (this.propertyDescriptor != null && this.implementedClasses == null) {
            this.implementedClasses = new Class[1];
            this.implementedClasses[0] = this.propertyDescriptor.getPropertyType();
        }
    }

    protected boolean instanceMatches(Object instance) {
        if (this.implementedClasses != null) {
            for (int i = 0; i < this.implementedClasses.length; ++i) {
                if (this.implementedClasses[i].isAssignableFrom(instance.getClass())) continue;
                return false;
            }
        }
        return true;
    }

    public String getAsText() {
        if (this.value == null) {
            return "null";
        }
        String componentName = RunningObjectTable.lookupComponentName(this.value);
        if (componentName == null) {
            String message = Util.getCommonStringResource((String)"InstanceOfClass.txt");
            componentName = Message.format((String)message, (Object)this.value.getClass().getName());
        }
        return componentName;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (text == "null") {
            this.value = null;
        } else {
            Object component = RunningObjectTable.lookupComponent(text);
            if (component != null) {
                this.value = component;
            }
        }
        this.firePropertyChange();
    }

    public String[] getTags() {
        String componentName;
        String frameName = null;
        if (this.bean != null && (componentName = RunningObjectTable.lookupComponentName(this.bean)) != null) {
            int dotIndex = componentName.indexOf(".");
            frameName = dotIndex > 0 ? componentName.substring(0, dotIndex) : componentName;
        }
        int count = 0;
        Enumeration componentNames = RunningObjectTable.getComponentNames();
        while (componentNames.hasMoreElements()) {
            String name = (String)componentNames.nextElement();
            Object component = RunningObjectTable.lookupComponent(name);
            if (!this.instanceMatches(component) || !this.inSameFrame(name, frameName)) continue;
            ++count;
        }
        ++count;
        if (this.value != null && RunningObjectTable.lookupComponentName(this.value) == null) {
            ++count;
        }
        String[] tags = new String[count];
        int nameIndex = 0;
        tags[nameIndex++] = "null";
        if (this.value != null && RunningObjectTable.lookupComponentName(this.value) == null) {
            String message = Util.getCommonStringResource((String)"InstanceOfClass.txt");
            tags[nameIndex++] = Message.format((String)message, (Object)this.value.getClass().getName());
        }
        componentNames = RunningObjectTable.getComponentNames();
        while (componentNames.hasMoreElements()) {
            String name = (String)componentNames.nextElement();
            Object component = RunningObjectTable.lookupComponent(name);
            if (!this.instanceMatches(component) || !this.inSameFrame(name, frameName)) continue;
            tags[nameIndex++] = name;
        }
        return tags;
    }

    public void setBeanContainingProperty(Object bean) {
        this.bean = bean;
    }

    protected boolean inSameFrame(String componentName, String frameName) {
        if (frameName == null) {
            return false;
        }
        return componentName.startsWith(frameName = frameName + ".");
    }

    public String getJavaInitializationString() {
        if (this.value == null) {
            return "null";
        }
        String componentName = RunningObjectTable.lookupComponentName(this.value);
        return componentName;
    }
}

