/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.metadata.profile;

import com.sas.batch.localsvc.LocalServicesBatchUtility2;
import com.sas.batch.metadata.profile.ProfileUtil;
import com.sas.batch.metadata.profile.RB;
import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.services.ServiceException;
import com.sas.services.connection.HostPortPair;
import com.sas.services.connection.HostPortSet;
import com.sas.services.information.OMIServer;
import com.sas.services.information.RepositoryInterface;
import com.sas.text.Message;
import com.sas.util.Encryption;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UpdateMetadataProfile
extends LocalServicesBatchUtility2 {
    public static final String XML_NAMESPACE_PREFIX = "http://www.sas.com/xml/schema/namespace/UpdateMetadataProfile";
    public static final String CURRENT_XML_NAMESPACE = "http://www.sas.com/xml/schema/namespace/UpdateMetadataProfile-9.4";
    private static final String ELEMENT_REDIRECT = "Redirect";
    private static final String DEFAULT_SERVER_NAME = "SASMeta";
    public static final String OPTION_CREATE = "create";
    public static final String OPTION_UPDATE = "update";
    public static final String OPTION_UPDATE_ALL = "updateAll";
    public static final String OPTION_PROFILE_NAME = "profileName";
    public static final String OPTION_PROFILE_USER = "profileUser";
    public static final String OPTION_PROFILE_PASSWORD = "profilePassword";
    public static final String OPTION_PROFILE_REPOSITORY = "profileRepository";
    private MdObjectStore store;
    private ProcessMode mode;
    private String filePath;
    private String profileName;
    private String profileUser;
    private String profilePassword;
    private String profileRepository;
    private Login login;
    private String connectedHost;
    private int connectedPort;

    public UpdateMetadataProfile() {
        this.utilityName = "sas-update-metadata-profile";
    }

    public void setProcessMode(ProcessMode mode, String filePath) {
        this.mode = mode;
        this.filePath = filePath;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public void setProfileUser(String profileUser) {
        this.profileUser = profileUser;
    }

    public void setProfilePassword(String profilePassword) {
        this.profilePassword = profilePassword;
    }

    public void setProfileRepository(String profileRepository) {
        this.profileRepository = profileRepository;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public String getProfileUser() {
        return this.profileUser;
    }

    public String getProfilePassword() {
        return this.profilePassword;
    }

    public String getProfileRepository() {
        return this.profileRepository;
    }

    protected void initialize() throws ServiceException {
        super.initialize();
        try {
            RepositoryInterface repos;
            MdFactory factory = ((OMIServer)this.metadataServer).getMdFactory();
            this.store = factory.createObjectStore(null, "UpdateMetadataProfileStore");
            this.connectedHost = this.metadataServer.getHost();
            this.connectedPort = this.metadataServer.getPort();
            if (this.profileRepository != null && (repos = this.metadataServer.getRepository(this.profileRepository)) == null) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"UpdateMetadataProfile.InvalidRepos.fmt.txt", (Object)this.profileRepository));
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int execute() throws Exception {
        try {
            HostPortSet set;
            this.initialize();
            if (this.profileUser != null) {
                this.login = ProfileUtil.getLogin(this.store, this.profileUser);
            }
            if ((set = ((OMIServer)this.metadataServer).getClusterConnections()) == null || set.isEmpty()) {
                this.logger.warn(RB.getStringResource("UpdateMetadataProfile.NoClusterDefinition.txt"));
                this.publishWarning();
            }
            switch (this.mode) {
                case CREATE: {
                    if (this.filePath == null) {
                        throw new IllegalArgumentException(RB.getStringResource("UpdateMetadataProfile.NoFilePath.txt"));
                    }
                    this.createServerProfile(this.filePath, set);
                    return this.returnCode;
                }
                case UPDATE: {
                    if (this.filePath == null) {
                        throw new IllegalArgumentException(RB.getStringResource("UpdateMetadataProfile.NoFilePath.txt"));
                    }
                    this.updateServerProfile(this.filePath, set);
                    return this.returnCode;
                }
                case UPDATE_ALL: {
                    if (this.filePath == null) {
                        throw new IllegalArgumentException(RB.getStringResource("UpdateMetadataProfile.NoDirectory.txt"));
                    }
                    this.updateAllServerProfiles(this.filePath, set);
                    return this.returnCode;
                }
            }
            return this.returnCode;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (this.store != null) {
                this.store.dispose();
            }
            this.terminate();
        }
    }

    private void updateAllServerProfiles(String directory, HostPortSet hostPortSet) throws TransformerConfigurationException, ParserConfigurationException, TransformerFactoryConfigurationError, TransformerException, IOException, SAXException, MdException, ServiceException {
        File dir = new File(directory);
        List<File> profiles = ProfileUtil.getMetaProfiles(dir);
        if (profiles == null || profiles.isEmpty()) {
            this.logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"UpdateMetadataProfile.NoProfilesFound.fmt.txt", (Object)dir.getAbsolutePath()));
            this.publishWarning();
        } else {
            for (File file : profiles) {
                try {
                    this.updateServerProfile(file, hostPortSet);
                }
                catch (Exception e) {
                    this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"UpdateMetadataProfile.UpdateError.fmt.txt", (Object)e.getLocalizedMessage()));
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Exception:", (Throwable)e);
                    }
                    this.publishError();
                }
            }
        }
    }

    private void updateServerProfile(String fileName, HostPortSet hostPortSet) throws Exception {
        this.updateServerProfile(new File(fileName), hostPortSet);
    }

    private void updateServerProfile(File profile, HostPortSet hostPortSet) throws Exception {
        if (!profile.exists()) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"UpdateMetadataProfile.FileDoesNotExist.fmt.txt", (Object)profile.getAbsolutePath()));
        }
        this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"UpdateMetadataProfile.Processing.fmt.txt", (Object)profile.getAbsolutePath()));
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder docBuilder = dbf.newDocumentBuilder();
        Document doc = docBuilder.parse(profile);
        this.validateProfile(doc);
        boolean modified = false;
        if (this.profileName != null && !this.profileName.isEmpty()) {
            XPath xpath = XPathFactory.newInstance().newXPath();
            try {
                Node node = (Node)xpath.evaluate("/Redirect/LogicalServer[@Name='" + this.profileName + "']", doc, XPathConstants.NODE);
                if (node instanceof Element) {
                    modified = this.replaceLogicalServerDefinition(hostPortSet, (Element)node, doc);
                }
                this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"UpdateMetadataProfile.ProfileNameNotFound.fmt.txt", (Object)this.profileName));
                this.addLogicalServerToProfile(hostPortSet, doc.getDocumentElement(), doc);
                modified = true;
            }
            catch (XPathExpressionException e) {
                this.logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"UpdateMetadataProfile.ProfileNameNotFound.fmt.txt", (Object)this.profileName));
                this.publishWarning();
                return;
            }
        } else {
            boolean merged;
            Element rootElement = doc.getDocumentElement();
            NodeList nodes = rootElement.getChildNodes();
            Element logicalServerElement = null;
            for (int index = 0; index < nodes.getLength(); ++index) {
                Node child = nodes.item(index);
                if (!"LogicalServer".equalsIgnoreCase(child.getLocalName())) continue;
                if (logicalServerElement == null && child instanceof Element) {
                    logicalServerElement = (Element)child;
                    continue;
                }
                throw new ServiceException(RB.getStringResource("UpdateMetadataProfile.NoUpdate.MultipleLogicalServers.txt"));
            }
            if (logicalServerElement != null && (merged = this.replaceLogicalServerDefinition(hostPortSet, logicalServerElement, doc))) {
                modified = true;
            }
        }
        if (modified) {
            File originalProfile = ProfileUtil.saveOriginalProfile(profile);
            String encoding = doc.getXmlEncoding();
            ProfileUtil.writeDocumentContents(profile, doc, encoding);
            this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"UpdateMetadataProfile.Updated.fmt.txt", (Object)originalProfile.getName()));
        } else {
            this.logger.info(RB.getStringResource("UpdateMetadataProfile.NoUpdate.txt"));
        }
    }

    private boolean replaceLogicalServerDefinition(HostPortSet hostPortSet, Element logicalServerElement, Document doc) throws RemoteException, MdException, ServiceException {
        NamedNodeMap lsAttrs = logicalServerElement.getAttributes();
        String entryName = lsAttrs == null || lsAttrs.getNamedItem("Name") == null ? "[Unknown]" : lsAttrs.getNamedItem("Name").getNodeValue();
        this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"UpdateMetadataProfile.ParsingEntry.fmt.txt", (Object)entryName));
        try {
            Node parent;
            XPath xpath = XPathFactory.newInstance().newXPath();
            Node loginNode = null;
            Node repositoryNode = null;
            ArrayList<Node> otherPropertyNodes = null;
            Node firstConnectionNode = (Node)xpath.evaluate("UsingComponents/ServerComponent/SourceConnections/TCPIPConnection", logicalServerElement, XPathConstants.NODE);
            if (firstConnectionNode != null) {
                NodeList list;
                if (this.profileUser == null && this.profilePassword == null) {
                    loginNode = (Node)xpath.evaluate("Domain/AuthenticationDomain/Logins/Login[@Name='Metadata Login']", firstConnectionNode, XPathConstants.NODE);
                }
                if (this.profileRepository == null) {
                    repositoryNode = (Node)xpath.evaluate("Properties/Property[@Name='Repository' and @PropertyName='Repository']", firstConnectionNode, XPathConstants.NODE);
                }
                if ((list = (NodeList)xpath.evaluate("Properties/Property", firstConnectionNode, XPathConstants.NODESET)) != null && list.getLength() > 0) {
                    for (int index = 0; index < list.getLength(); ++index) {
                        Node propNode = list.item(index);
                        if (propNode == repositoryNode) continue;
                        if (otherPropertyNodes == null) {
                            otherPropertyNodes = new ArrayList<Node>();
                        }
                        otherPropertyNodes.add(propNode);
                    }
                }
            }
            if ((parent = logicalServerElement.getParentNode()) instanceof Element) {
                logicalServerElement = this.addLogicalServerToProfile(hostPortSet, (Element)parent, doc, logicalServerElement);
            }
            if (loginNode != null || repositoryNode != null || otherPropertyNodes != null) {
                NodeList nodes;
                String userID = null;
                String password = null;
                if (loginNode != null) {
                    Node passwordNode;
                    NamedNodeMap attrs = loginNode.getAttributes();
                    Node userIDNode = attrs.getNamedItem("UserID");
                    if (userIDNode == null) {
                        userIDNode = attrs.getNamedItem("UserId");
                    }
                    if (userIDNode == null) {
                        userIDNode = attrs.getNamedItem("Userid");
                    }
                    if (userIDNode != null) {
                        userID = userIDNode.getNodeValue();
                    }
                    if ((passwordNode = attrs.getNamedItem("Password")) != null) {
                        password = passwordNode.getNodeValue();
                    }
                }
                String reposName = null;
                if (repositoryNode != null) {
                    RepositoryInterface repos;
                    NamedNodeMap attrs = repositoryNode.getAttributes();
                    Node defaultValueAttr = attrs.getNamedItem("DefaultValue");
                    if (defaultValueAttr != null) {
                        reposName = defaultValueAttr.getNodeValue();
                    }
                    if (reposName != null && (repos = this.metadataServer.getRepository(reposName)) == null) {
                        this.logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"UpdateMetadataProfile.ReposNotFound.fmt.txt", (Object)reposName));
                        this.publishWarning();
                    }
                }
                if ((nodes = (NodeList)xpath.evaluate("UsingComponents/ServerComponent", logicalServerElement, XPathConstants.NODESET)) != null && nodes.getLength() > 0) {
                    for (int index = 0; index < nodes.getLength(); ++index) {
                        Node serverComponentElement = nodes.item(index);
                        Node tcpipConnectionNode = (Node)xpath.evaluate("SourceConnections/TCPIPConnection", serverComponentElement, XPathConstants.NODE);
                        if (tcpipConnectionNode == null || !(tcpipConnectionNode instanceof Element)) continue;
                        if (userID != null && password != null) {
                            this.addLoginToProfile(userID, password, (Element)tcpipConnectionNode, doc);
                        }
                        if (reposName != null) {
                            this.addDefaultRepositoryToProfile(reposName, (Element)tcpipConnectionNode, doc);
                        }
                        if (otherPropertyNodes == null) continue;
                        this.addPropertiesToProfile(otherPropertyNodes, (Element)tcpipConnectionNode, doc);
                    }
                }
            }
        }
        catch (XPathExpressionException e) {
            throw new ServiceException(RB.getStringResource("UpdateMetadataProfile.ParseError.txt"));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createServerProfile(String fileName, HostPortSet hostPortSet) throws Exception {
        OutputStream fileStream = null;
        try {
            File profile = new File(fileName);
            if (profile.exists()) {
                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"UpdateMetadataProfile.FileExists.fmt.txt", (Object)fileName));
            }
            fileStream = new FileOutputStream(profile);
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            doc.appendChild(doc.createComment(RB.getStringResource("UpdateMetadataProfile.Profile.Description.txt")));
            Element rootElement = doc.createElement(ELEMENT_REDIRECT);
            doc.appendChild(rootElement);
            this.addLogicalServerToProfile(hostPortSet, rootElement, doc);
            ProfileUtil.writeDocumentContents(profile, doc);
            this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"UpdateMetadataProfile.Created.fmt.txt", (Object)profile.getAbsolutePath()));
        }
        finally {
            try {
                if (fileStream != null) {
                    fileStream.close();
                }
            }
            catch (Exception e) {
                this.logger.debug("Unable to close input/output streams.");
            }
        }
    }

    private Element addLogicalServerToProfile(HostPortSet hostPortSet, Element parentElement, Document doc) throws RemoteException, MdException {
        return this.addLogicalServerToProfile(hostPortSet, parentElement, doc, null);
    }

    private Element addLogicalServerToProfile(HostPortSet hostPortSet, Element parentElement, Document doc, Node nodeToReplace) throws RemoteException, MdException {
        Element logicalServerElement = doc.createElement("LogicalServer");
        logicalServerElement.setAttribute("Name", this.profileName == null ? DEFAULT_SERVER_NAME : this.profileName);
        logicalServerElement.setAttribute("ClassIdentifier", "0217e202-b560-11db-ad91-001083ff6836");
        if (nodeToReplace != null) {
            parentElement.replaceChild(logicalServerElement, nodeToReplace);
        } else {
            parentElement.appendChild(logicalServerElement);
        }
        Element usingCompElement = doc.createElement("UsingComponents");
        logicalServerElement.appendChild(usingCompElement);
        HostPortPair connectedHostPort = new HostPortPair(this.connectedHost, this.connectedPort);
        if (hostPortSet == null || hostPortSet.isEmpty() || !hostPortSet.contains((Object)connectedHostPort)) {
            this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"UpdateMetadataProfile.CreateWithConnectedValues.fmt.txt", (Object)this.connectedHost, (Object)String.valueOf(this.connectedPort)));
            this.addServerComponentToProfile(connectedHostPort, usingCompElement, doc);
        } else {
            for (HostPortPair pair : hostPortSet) {
                this.addServerComponentToProfile(pair, usingCompElement, doc);
            }
        }
        return logicalServerElement;
    }

    private void addServerComponentToProfile(HostPortPair pair, Element parentElement, Document doc) throws RemoteException, MdException {
        Element serverCompElement = doc.createElement("ServerComponent");
        serverCompElement.setAttribute("Name", "SAS Metadata Server");
        serverCompElement.setAttribute("ClassIdentifier", "0217e202-b560-11db-ad91-001083ff6836");
        parentElement.appendChild(serverCompElement);
        Element sourceConnectionsElement = doc.createElement("SourceConnections");
        serverCompElement.appendChild(sourceConnectionsElement);
        Element connectionElement = doc.createElement("TCPIPConnection");
        connectionElement.setAttribute("Name", "SAS Metadata Server");
        connectionElement.setAttribute("Port", String.valueOf(pair.getPort()));
        connectionElement.setAttribute("HostName", pair.getHost());
        connectionElement.setAttribute("CommunicationProtocol", "TCP");
        connectionElement.setAttribute("ApplicationProtocol", "Bridge");
        sourceConnectionsElement.appendChild(connectionElement);
        this.addLoginToProfile(connectionElement, doc);
        this.addDefaultRepositoryToProfile(connectionElement, doc);
    }

    private void addLoginToProfile(Element parentElement, Document doc) throws RemoteException, MdException {
        if (this.profileUser != null && this.profilePassword != null) {
            this.addLoginToProfile(this.profileUser, this.profilePassword, parentElement, doc);
        }
    }

    private void addLoginToProfile(String userID, String password, Element parentElement, Document doc) throws RemoteException, MdException {
        AuthenticationDomain domain;
        Element domainElement = ProfileUtil.createChildElement("Domain", parentElement, doc);
        String domainName = "DefaultAuth";
        if (this.login != null && (domain = this.login.getDomain()) != null) {
            domainName = domain.getName();
        }
        Element authDomainElement = ProfileUtil.createChildElement("AuthenticationDomain", domainElement, doc);
        authDomainElement.setAttribute("Name", domainName);
        Element loginsElement = ProfileUtil.createChildElement("Logins", authDomainElement, doc);
        Element loginElement = ProfileUtil.createChildElement("Login", loginsElement, doc);
        loginElement.setAttribute("Name", "Metadata Login");
        loginElement.setAttribute("UserID", userID);
        loginElement.setAttribute("Password", Encryption.encrypt((String)password));
    }

    private void addDefaultRepositoryToProfile(Element parentElement, Document doc) {
        if (this.profileRepository != null) {
            this.addDefaultRepositoryToProfile(this.profileRepository, parentElement, doc);
        }
    }

    private void addDefaultRepositoryToProfile(String reposName, Element parentElement, Document doc) {
        Element propertiesElement = ProfileUtil.createChildElement("Properties", parentElement, doc);
        Element propertyElement = ProfileUtil.createChildElement("Property", propertiesElement, doc);
        propertyElement.setAttribute("Name", "Repository");
        propertyElement.setAttribute("DefaultValue", reposName);
        propertyElement.setAttribute("PropertyName", "Repository");
    }

    private void addPropertiesToProfile(List<Node> propertyNodes, Element parentElement, Document doc) {
        Element propertiesElement = ProfileUtil.createChildElement("Properties", parentElement, doc);
        for (Node node : propertyNodes) {
            Node newNode = node.cloneNode(false);
            propertiesElement.appendChild(newNode);
        }
    }

    private void validateProfile(Document doc) throws SAXException, IOException {
        Element root = doc.getDocumentElement();
        if (!ELEMENT_REDIRECT.equalsIgnoreCase(root.getLocalName())) {
            throw new SAXException(RB.getStringResource("UpdateMetadataProfile.InvalidProfile.MissingRoot.txt"));
        }
    }

    protected Options getCommandLineOptions(boolean forHelpText) {
        Options commandLineOptions = super.getCommandLineOptions(forHelpText);
        Option option = new Option(OPTION_CREATE, true, RB.getStringResource("UpdateMetadataProfile.Option.Create.txt"));
        option.setArgName(RB.getStringResource("UpdateMetadataProfile.Option.Create.ArgName.txt"));
        commandLineOptions.addOption(option);
        option = new Option(OPTION_UPDATE, true, RB.getStringResource("UpdateMetadataProfile.Option.Update.txt"));
        option.setArgName(RB.getStringResource("UpdateMetadataProfile.Option.Update.ArgName.txt"));
        commandLineOptions.addOption(option);
        option = new Option(OPTION_UPDATE_ALL, true, RB.getStringResource("UpdateMetadataProfile.Option.UpdateAll.txt"));
        option.setArgName(RB.getStringResource("UpdateMetadataProfile.Option.UpdateAll.ArgName.txt"));
        commandLineOptions.addOption(option);
        option = new Option(OPTION_PROFILE_NAME, true, RB.getStringResource("UpdateMetadataProfile.Option.ProfileName.txt"));
        option.setArgName(RB.getStringResource("UpdateMetadataProfile.Option.ProfileName.ArgName.txt"));
        commandLineOptions.addOption(option);
        option = new Option(OPTION_PROFILE_USER, true, RB.getStringResource("UpdateMetadataProfile.Option.ProfileUser.txt"));
        option.setArgName(RB.getStringResource("UpdateMetadataProfile.Option.ProfileUser.ArgName.txt"));
        commandLineOptions.addOption(option);
        option = new Option(OPTION_PROFILE_PASSWORD, true, RB.getStringResource("UpdateMetadataProfile.Option.ProfilePassword.txt"));
        option.setArgName(RB.getStringResource("UpdateMetadataProfile.Option.ProfilePassword.ArgName.txt"));
        commandLineOptions.addOption(option);
        option = new Option(OPTION_PROFILE_REPOSITORY, true, RB.getStringResource("UpdateMetadataProfile.Option.ProfileRepository.txt"));
        option.setArgName(RB.getStringResource("UpdateMetadataProfile.Option.ProfileRepository.ArgName.txt"));
        commandLineOptions.addOption(option);
        return commandLineOptions;
    }

    protected boolean parse(String[] args) throws ParseException, MissingOptionException {
        String filePath;
        if (!super.parse(args)) {
            return false;
        }
        int modeOptionCount = 0;
        if (this.commandLine.hasOption(OPTION_CREATE)) {
            ++modeOptionCount;
            filePath = this.commandLine.getOptionValue(OPTION_CREATE);
            this.setProcessMode(ProcessMode.CREATE, filePath);
        }
        if (this.commandLine.hasOption(OPTION_UPDATE)) {
            ++modeOptionCount;
            filePath = this.commandLine.getOptionValue(OPTION_UPDATE);
            this.setProcessMode(ProcessMode.UPDATE, filePath);
        }
        if (this.commandLine.hasOption(OPTION_UPDATE_ALL)) {
            ++modeOptionCount;
            filePath = this.commandLine.getOptionValue(OPTION_UPDATE_ALL);
            this.setProcessMode(ProcessMode.UPDATE_ALL, filePath);
        }
        if (modeOptionCount == 0) {
            throw new ParseException(RB.getStringResource("UpdateMetadataProfile.NoModeOption.txt"));
        }
        if (modeOptionCount > 1) {
            throw new ParseException(RB.getStringResource("UpdateMetadataProfile.InvalidModeOption.txt"));
        }
        this.setProfileName(this.commandLine.getOptionValue(OPTION_PROFILE_NAME));
        this.setProfileUser(this.commandLine.getOptionValue(OPTION_PROFILE_USER));
        this.setProfilePassword(this.commandLine.getOptionValue(OPTION_PROFILE_PASSWORD));
        this.setProfileRepository(this.commandLine.getOptionValue(OPTION_PROFILE_REPOSITORY));
        if (this.profileUser == null && this.profilePassword != null || this.profileUser != null && this.profilePassword == null) {
            throw new ParseException(RB.getStringResource("UpdateMetadataProfile.InvalidUserAndPassword.txt"));
        }
        return true;
    }

    public static void main(String[] args) {
        UpdateMetadataProfile updateProfile = new UpdateMetadataProfile();
        updateProfile.executeBatch(args);
    }

    protected void displayHelp() {
        this.displayHelp(new String[]{RB.getStringResource("UpdateMetadataProfile.HelpUsage.txt")});
    }

    void publishWarning() {
        this.returnCode |= 4;
    }

    void publishError() {
        this.returnCode |= 8;
    }

    public static enum ProcessMode {
        CREATE,
        UPDATE,
        UPDATE_ALL;

    }
}

