/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.appmeta;

import com.sas.batch.appmeta.AppMetaException;
import com.sas.batch.appmeta.Application;
import com.sas.batch.appmeta.HubDirective;
import com.sas.batch.appmeta.RB;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.TextStore;
import com.sas.storage.editableproperties.MultiLocaleProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import com.sas.text.Message;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class HubIntegration
implements MultiLocaleProperties {
    private Application application = null;
    private Map<String, HubDirective> directives = new HashMap<String, HubDirective>();

    private HubIntegration() {
    }

    static HubIntegration create(Application application) {
        HubIntegration hubIntegration = new HubIntegration();
        hubIntegration.application = application;
        return hubIntegration;
    }

    Application getApplication() {
        return this.application;
    }

    void loadFromXML(Element xml) throws AppMetaException {
        NodeList nodes = xml.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element;
            String tagName;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !(tagName = (element = (Element)node).getTagName()).equals("HubDirective")) continue;
            HubDirective directive = HubDirective.create(this);
            directive.loadFromXML(element);
            if (this.directives.containsKey(directive.getName())) {
                throw new AppMetaException(Message.format((ResourceBundle)RB.getResources(), (String)"Application.DuplicateHubDirective.fmt.log", (Object)directive.getName()));
            }
            this.directives.put(directive.getName(), directive);
        }
    }

    void loadFromMetadata(Element parent) throws MdException {
        Element hub = parent.getOwnerDocument().createElement("Hub");
        try {
            AssociationList notes = this.application.getJomaObject().getNotes();
            for (TextStore note : notes) {
                if (!note.getTextRole().equalsIgnoreCase("HubDirective")) continue;
                HubDirective directive = HubDirective.create(this);
                directive.loadFromMetadata(note, hub);
                if (this.directives.containsKey(directive.getName())) {
                    this.application.getContext().getLogger().warn(Message.format((ResourceBundle)RB.getResources(), (String)"Application.DuplicateHubDirectiveExtract.fmt.log", (Object)directive.getName()));
                    continue;
                }
                this.directives.put(directive.getName(), directive);
            }
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
        if (!this.directives.isEmpty()) {
            parent.appendChild(hub);
        }
    }

    void mergeToMetadata() throws MdException {
        for (HubDirective directive : this.directives.values()) {
            directive.mergeToMetadata();
        }
    }

    public PropertyList getLocalizableProperties() throws UnexpectedLocalizationException {
        PropertyList list = new PropertyList();
        for (HubDirective directive : this.directives.values()) {
            list.addProperty("Directive." + directive.getName(), directive.getLocalizableProperties());
        }
        return list;
    }

    public void setLocalizableProperties(PropertyMap map) throws UnexpectedLocalizationException {
        for (HubDirective directive : this.directives.values()) {
            String propertyName = "Directive." + directive.getName();
            if (!map.containsNestedProperty(propertyName)) continue;
            directive.setLocalizableProperties(map.getNestedProperties(propertyName));
        }
    }

    public void beginLocalization() throws UnexpectedLocalizationException {
        for (HubDirective directive : this.directives.values()) {
            directive.beginLocalization();
        }
    }

    public void setLocalizableProperties(Locale locale, PropertyMap map) throws UnexpectedLocalizationException {
        for (HubDirective directive : this.directives.values()) {
            String propertyName = "Directive." + directive.getName();
            if (!map.containsNestedProperty(propertyName)) continue;
            directive.setLocalizableProperties(locale, map.getNestedProperties(propertyName));
        }
    }

    public void endLocalization() throws UnexpectedLocalizationException {
        for (HubDirective directive : this.directives.values()) {
            directive.endLocalization();
        }
    }

    public PropertyList getLocalizableProperties(Locale locale) throws UnexpectedLocalizationException {
        PropertyList list = new PropertyList();
        for (HubDirective directive : this.directives.values()) {
            list.addProperty("Directive." + directive.getName(), directive.getLocalizableProperties(locale));
        }
        return list;
    }

    public Collection<Locale> getLocales() throws UnexpectedLocalizationException {
        HashSet<Locale> locales = new HashSet<Locale>();
        for (HubDirective directive : this.directives.values()) {
            locales.addAll(directive.getLocales());
        }
        return locales;
    }
}

