/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.appmeta;

import com.sas.batch.appmeta.ApplicationMetadataUtility;
import com.sas.batch.appmeta.MetadataBase;
import com.sas.batch.appmeta.RB;
import com.sas.batch.appmeta.UserGroup;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.IdentityGroup;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Person;
import com.sas.storage.editableproperties.LocalizableProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import com.sas.text.Message;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class GroupOrRole
extends MetadataBase
implements LocalizableProperties {
    String _publicType = null;
    String _displayName = null;
    String _action = null;
    List<IdentityReference> _members = null;

    GroupOrRole(ApplicationMetadataUtility context, String publicType) {
        super(context);
        this._publicType = publicType;
        this._members = new ArrayList<IdentityReference>();
    }

    @Override
    String getName() {
        return this._name;
    }

    void getCommonAttributes(Element xml) {
        this._name = xml.getAttribute("Name");
        if (xml.hasAttribute("DisplayName")) {
            this._displayName = xml.getAttribute("DisplayName");
        }
        if (xml.hasAttribute("Desc")) {
            this._desc = xml.getAttribute("Desc");
        }
        if (xml.hasAttribute("_Action")) {
            this._action = xml.getAttribute("_Action");
        }
    }

    void processMembers(Element members) {
        NodeList nodes = members.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element;
            String tagName;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !(tagName = (element = (Element)node).getTagName()).equals("User") && !tagName.equals("UserGroup")) continue;
            this._members.add(new IdentityReference(element.getAttribute("Name"), tagName));
        }
    }

    void loadMembersFromMetadata(IdentityGroup group, Element membersElement) throws DOMException, MdException {
        try {
            for (Object item : group.getMemberIdentities()) {
                Identity member = (Identity)item;
                if (!member.getPublicType().equals("User") && !member.getPublicType().equals("UserGroup")) continue;
                this._members.add(new IdentityReference(member.getName(), member.getPublicType()));
                Element memberElement = this._context.sourceDocument.createElement(member.getPublicType());
                memberElement.setAttribute("Name", member.getName());
                membersElement.appendChild(memberElement);
            }
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    void mergeToMetadata(MdObjectStore store) throws RemoteException, MdException {
        List objects;
        MdOMIUtil omiUtil = store.getFactory().getOMIUtil();
        IdentityGroup identity = null;
        if (this._name.length() > 0 && (objects = omiUtil.getMetadataObjectsSubset((MdStore)store, omiUtil.getFoundationReposID(), "IdentityGroup", 8584, "<XMLSelect search=\"IdentityGroup[@Name='" + this._name + "']\"/>")).size() >= 1 && !(identity = (IdentityGroup)objects.get(0)).getPublicType().equals(this._publicType)) {
            String objType = identity.getPublicType();
            if (objType.length() == 0) {
                objType = "IdentityGroup";
            }
            this._context.getLogger().error(Message.format((ResourceBundle)RB.getResources(), (String)"GroupOrRole.IdentityTypeMismatch.fmt.log", (Object)this._publicType, (Object)this._name, (Object)objType));
            this._context.declareError();
            return;
        }
        if ("Delete".equals(this._action)) {
            if (identity != null) {
                identity.delete();
            }
            return;
        }
        if (identity == null) {
            if ("Update".equals(this._action)) {
                this._context.getLogger().warn(Message.format((ResourceBundle)RB.getResources(), (String)"GroupOrRole.IdentityGroupNotFound.fmt.log", (Object)this._publicType, (Object)this._name));
                this._context.declareWarning();
                return;
            }
            identity = (IdentityGroup)store.getFactory().createComplexMetadataObject(store, this._name, "IdentityGroup", omiUtil.getFoundationReposID().substring(9));
            if (this._desc != null) {
                identity.setDesc(this._desc);
            }
            if (this._displayName == null) {
                this._displayName = this._name;
            }
            identity.setDisplayName(this._displayName);
            identity.setPublicType(this._publicType);
            identity.setUsageVersion(1000000.0);
            if (this._publicType.equals("Role")) {
                identity.setGroupType("ROLE");
            }
            this._context.getLogger().info(Message.format((ResourceBundle)RB.getResources(), (String)"GroupOrRole.IdentityGroupCreate.fmt.log", (Object)this._publicType, (Object)this._name));
        } else {
            if ("Create".equals(this._action)) {
                return;
            }
            if (this._desc != null && !identity.getDesc().equals(this._desc)) {
                identity.setDesc(this._desc);
            }
            if (this._displayName != null && !identity.getDisplayName().equals(this._displayName)) {
                identity.setDisplayName(this._displayName);
            }
            this._context.getLogger().info(Message.format((ResourceBundle)RB.getResources(), (String)"GroupOrRole.IdentityGroupUpdate.fmt.log", (Object)this._publicType, (Object)this._name));
        }
        this._jomaObject = identity;
    }

    void addExternalReferences() throws MdException {
        if (this._jomaObject == null) {
            return;
        }
        try {
            MdOMIUtil omiUtil = this._jomaObject.getObjectStore().getFactory().getOMIUtil();
            IdentityGroup identityGroup = (IdentityGroup)this._jomaObject;
            ArrayList<IdentityReference> membersCopy = new ArrayList<IdentityReference>(this._members);
            AssociationList members = identityGroup.getMemberIdentities();
            if (!identityGroup.isNewObject()) {
                block2: for (Object item : members) {
                    Identity member = (Identity)item;
                    for (IdentityReference memberRef : membersCopy) {
                        if ((!(member instanceof Person) || !memberRef.matches(member.getName(), "User")) && (!(member instanceof IdentityGroup) || !memberRef.matches(member.getName(), "UserGroup"))) continue;
                        membersCopy.remove(memberRef);
                        continue block2;
                    }
                }
            }
            for (IdentityReference memberRef : membersCopy) {
                String objectType = memberRef._type.equalsIgnoreCase("User") ? "Person" : "IdentityGroup";
                List identities = omiUtil.getMetadataObjectsSubset(this._jomaObject.getObjectStore(), omiUtil.getFoundationReposID(), objectType, 8584, "<XMLSelect search=\"*[@Name='" + memberRef._name + "']\"/>");
                if (identities.size() == 1) {
                    members.add(identities.get(0));
                    continue;
                }
                if (identities.size() != 0) continue;
                UserGroup desiredUserGroup = this._context.getGroups().get(memberRef._name);
                if (desiredUserGroup != null) {
                    if (desiredUserGroup.getJomaObject() != null) {
                        members.add((Object)desiredUserGroup.getJomaObject());
                        continue;
                    }
                    this._context.getLogger().error(Message.format((ResourceBundle)RB.getResources(), (String)"GroupOrRole.RefNotCreated.fmt.log", (Object)memberRef._type, (Object)memberRef._name, (Object)this._publicType, (Object)this._name));
                    this._context.declareError();
                    continue;
                }
                this._context.getLogger().warn(Message.format((ResourceBundle)RB.getResources(), (String)"GroupOrRole.MemberNotFound.fmt.log", (Object)memberRef._type, (Object)memberRef._name, (Object)this._publicType, (Object)this._name));
                this._context.declareWarning();
            }
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public PropertyList getLocalizableProperties() throws UnexpectedLocalizationException {
        PropertyList list = new PropertyList();
        if (this._displayName != null) {
            list.addProperty("DisplayName", this._displayName);
        }
        if (this._desc != null) {
            list.addProperty("Desc", this._desc);
        }
        return list;
    }

    public void setLocalizableProperties(PropertyMap map) throws UnexpectedLocalizationException {
        if (map.containsProperty("DisplayName")) {
            this._displayName = map.getProperty("DisplayName");
        }
        if (map.containsProperty("Desc")) {
            this._desc = map.getProperty("Desc");
        }
    }

    class IdentityReference {
        String _name = null;
        String _type = null;

        IdentityReference(String name, String type) {
            this._name = name;
            this._type = type;
        }

        boolean matches(String name, String type) {
            return name.equalsIgnoreCase(this._name) && type.equalsIgnoreCase(this._type);
        }
    }
}

