/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.appmeta;

import com.sas.batch.appmeta.AppMetaException;
import com.sas.batch.appmeta.ApplicationMetadataUtility;
import com.sas.batch.appmeta.Capability;
import com.sas.batch.appmeta.CapabilityCategory;
import com.sas.batch.appmeta.ConfigurableObject;
import com.sas.batch.appmeta.Configuration;
import com.sas.batch.appmeta.Directives;
import com.sas.batch.appmeta.HubIntegration;
import com.sas.batch.appmeta.RB;
import com.sas.batch.appmeta.Services;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIServer;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.storage.editableproperties.MultiLocaleProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import com.sas.text.Message;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.ParseException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class Application
extends ConfigurableObject
implements MultiLocaleProperties {
    private String productName = null;
    private String classIdentifier = null;
    private int major = -1;
    private int minor = -1;
    private String platform = null;
    private String productIdentifier = null;
    private String softwareVersion = null;
    private String specVendor = null;
    private String specVersion = null;
    private String vendor = null;
    private String vendorIdentifier = null;
    private String associatedApplication = null;
    private String isDefaultInstance = null;
    private String isGridCapable = null;
    private String isSoap = null;
    private boolean registeredSASApplication = false;
    private String uriProtocol = null;
    private String uriHost = null;
    private int uriPort = 0;
    private String uriService = null;
    private String folderPath = null;
    private String parentComponent = null;
    private CapabilityCategory rootCategory = null;
    private Directives directives = null;
    private Services services = null;
    private Map<String, Capability> capabilities = new HashMap<String, Capability>();
    private HubIntegration hubIntegration = null;

    private Application(ApplicationMetadataUtility context) {
        super(context);
    }

    CapabilityCategory getCapabilityCategories() {
        return this.rootCategory;
    }

    Capability getCapability(String id) {
        return this.capabilities.get(id);
    }

    Directives getDirectives() {
        return this.directives;
    }

    static Application create(ApplicationMetadataUtility context) {
        Application app = new Application(context);
        return app;
    }

    String getProductName() {
        return this.productName;
    }

    void loadFromXML(Element xml) throws AppMetaException {
        String minorVersion;
        String majorVersion;
        if (xml.hasAttribute("Name")) {
            this._name = xml.getAttribute("Name");
        }
        if (xml.hasAttribute("ProductName")) {
            this.productName = xml.getAttribute("ProductName");
        }
        if (xml.hasAttribute("ClassIdentifier")) {
            this.classIdentifier = xml.getAttribute("ClassIdentifier");
        }
        if (xml.hasAttribute("Desc")) {
            this._desc = xml.getAttribute("Desc");
        }
        if (xml.hasAttribute("Major") && (majorVersion = xml.getAttribute("Major")).length() > 0) {
            this.major = Integer.parseInt(majorVersion);
        }
        if (xml.hasAttribute("Minor") && (minorVersion = xml.getAttribute("Minor")).length() > 0) {
            this.minor = Integer.parseInt(minorVersion);
        }
        if (xml.hasAttribute("Platform")) {
            this.platform = xml.getAttribute("Platform");
        }
        if (xml.hasAttribute("ProductIdentifier")) {
            this.productIdentifier = xml.getAttribute("ProductIdentifier");
        }
        if (xml.hasAttribute("SoftwareVersion")) {
            this.softwareVersion = xml.getAttribute("SoftwareVersion");
        }
        if (xml.hasAttribute("SpecVendor")) {
            this.specVendor = xml.getAttribute("SpecVendor");
        }
        if (xml.hasAttribute("SpecVersion")) {
            this.specVersion = xml.getAttribute("SpecVersion");
        }
        if (xml.hasAttribute("Vendor")) {
            this.vendor = xml.getAttribute("Vendor");
        }
        if (xml.hasAttribute("VendorIdentifier")) {
            this.vendorIdentifier = xml.getAttribute("VendorIdentifier");
        }
        if (xml.hasAttribute("AssociatedApplication")) {
            this.associatedApplication = xml.getAttribute("AssociatedApplication");
        }
        if (xml.hasAttribute("IsDefaultInstance")) {
            this.isDefaultInstance = xml.getAttribute("IsDefaultInstance");
        }
        if (xml.hasAttribute("IsGridCapable")) {
            this.isGridCapable = xml.getAttribute("IsGridCapable");
        }
        if (xml.hasAttribute("IsSoap")) {
            this.isSoap = xml.getAttribute("IsSoap");
            this._context.getLogger().warn("IsSoap attribute on Application objects is deprecated.  Use ServiceType attribute on Service objects instead.");
            this._context.declareWarning();
        }
        if (xml.hasAttribute("Folder")) {
            this.folderPath = xml.getAttribute("Folder");
        }
        if (xml.hasAttribute("ParentComponent")) {
            this.parentComponent = xml.getAttribute("ParentComponent");
        }
        if (this._name == null || this._name.length() == 0) {
            this._name = this.productName;
        }
        this.rootCategory = null;
        this.directives = null;
        this._configuration = null;
        this.uriProtocol = null;
        this.services = null;
        NodeList nodes = xml.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String tagName = element.getTagName();
            if (tagName.equals("Capabilities")) {
                if (this.rootCategory != null) {
                    throw new AppMetaException(Message.format((ResourceBundle)RB.getResources(), (String)"Application.TooManyElements.fmt.log", (Object)"Capabilities"));
                }
                this.rootCategory = CapabilityCategory.create(this, null);
                this.rootCategory.loadFromXML(element);
                continue;
            }
            if (tagName.equals("Directives")) {
                if (this.directives != null) {
                    throw new AppMetaException(Message.format((ResourceBundle)RB.getResources(), (String)"Application.TooManyElements.fmt.log", (Object)"Directives"));
                }
                this.directives = Directives.create(this);
                this.directives.loadFromXML(element);
                continue;
            }
            if (tagName.equals("Configuration")) {
                if (this._configuration != null) {
                    throw new AppMetaException(Message.format((ResourceBundle)RB.getResources(), (String)"Application.TooManyElements.fmt.log", (Object)"Configuration"));
                }
                this._configuration = Configuration.create(this);
                this._configuration.loadFromXML(element);
                continue;
            }
            if (tagName.equals("ApplicationUri")) {
                String port;
                if (this.registeredSASApplication) {
                    throw new AppMetaException(Message.format((ResourceBundle)RB.getResources(), (String)"Application.TooManyElements.fmt.log", (Object)"ApplicationUri"));
                }
                this.registeredSASApplication = true;
                if (element.hasAttribute("Protocol")) {
                    this.uriProtocol = element.getAttribute("Protocol");
                }
                if (element.hasAttribute("Host")) {
                    this.uriHost = element.getAttribute("Host");
                }
                if (element.hasAttribute("Port") && (port = element.getAttribute("Port")).length() > 0) {
                    this.uriPort = Integer.parseInt(port);
                }
                if (!element.hasAttribute("Service")) continue;
                this.uriService = element.getAttribute("Service");
                if (!this.uriService.startsWith("//")) continue;
                this._context.getLogger().warn(Message.format((ResourceBundle)RB.getResources(), (String)"Application.TrimServiceValue.fmt.log", (Object)this.uriService));
                this._context.declareWarning();
                this.uriService = this.uriService.substring(1);
                continue;
            }
            if (tagName.equals("Services")) {
                if (this.services != null) {
                    throw new AppMetaException(Message.format((ResourceBundle)RB.getResources(), (String)"Application.TooManyElements.fmt.log", (Object)"Services"));
                }
                this.services = Services.create(this);
                this.services.loadFromXML(element);
                continue;
            }
            if (!tagName.equals("Hub")) continue;
            if (this.hubIntegration != null) {
                throw new AppMetaException(Message.format((ResourceBundle)RB.getResources(), (String)"Application.TooManyElements.fmt.log", (Object)"Hub"));
            }
            this.hubIntegration = HubIntegration.create(this);
            this.hubIntegration.loadFromXML(element);
        }
    }

    boolean addCapability(Capability capability) {
        if (this.capabilities.containsKey(capability.getId())) {
            return false;
        }
        this.capabilities.put(capability.getId(), capability);
        return true;
    }

    void createNewApplication(MetadataServerInterface server) throws MdException, ParseException, AppMetaException, ServiceException, IllegalStateException, RemoteException {
        MdObjectStore store = ((OMIServer)server).getObjectStore();
        MdOMIUtil omiUtil = store.getFactory().getOMIUtil();
        if (this._context.getApplicationName() != null) {
            this._name = this._context.getApplicationName();
        }
        if (this._context.getFolder() != null) {
            this.folderPath = this._context.getFolder();
        }
        if (this.folderPath == null || this.folderPath.length() == 0) {
            throw new AppMetaException(RB.getStringResource("Application.NoFolder.log"));
        }
        List objects = omiUtil.getMetadataObjectsSubset((MdStore)store, omiUtil.getFoundationReposID(), "SoftwareComponent", 8584, "<XMLSelect search=\"SoftwareComponent[@Name='" + this._name + "' and @PublicType='Application']\"/>");
        if (objects.size() >= 1) {
            this._context.declareError(9);
            throw new AppMetaException(Message.format((ResourceBundle)RB.getResources(), (String)"Application.ApplicationAlreadyExists.fmt.log", (Object)this._name));
        }
        SoftwareComponent jomaObject = (SoftwareComponent)store.getFactory().createComplexMetadataObject(store, this._name, "SoftwareComponent", omiUtil.getFoundationReposID().substring(9));
        jomaObject.setPublicType("Application");
        jomaObject.setUsageVersion(1000000.0);
        if (this.classIdentifier != null) {
            jomaObject.setClassIdentifier(this.classIdentifier);
        }
        if (this._desc != null) {
            jomaObject.setDesc(this._desc);
        }
        if (this.major >= 0) {
            jomaObject.setMajor(this.major);
        }
        if (this.minor >= 0) {
            jomaObject.setMinor(this.minor);
        }
        if (this.platform != null) {
            jomaObject.setPlatform(this.platform);
        }
        if (this.productIdentifier != null) {
            jomaObject.setProductIdentifier(this.productIdentifier);
        }
        if (this.productName != null) {
            jomaObject.setProductName(this.productName);
        }
        if (this.softwareVersion != null) {
            jomaObject.setSoftwareVersion(this.softwareVersion);
        }
        if (this.specVendor != null) {
            jomaObject.setSpecVendor(this.specVendor);
        }
        if (this.specVersion != null) {
            jomaObject.setSpecVersion(this.specVersion);
        }
        if (this.vendor != null) {
            jomaObject.setVendor(this.vendor);
        }
        if (this.vendorIdentifier != null) {
            jomaObject.setVendorIdentifier(this.vendorIdentifier);
        }
        this.makeApplicationProperty(store, omiUtil, jomaObject, "AssociatedApplication", this.associatedApplication, "");
        this.makeApplicationProperty(store, omiUtil, jomaObject, "IsDefaultInstance", this.isDefaultInstance, "false");
        this.makeApplicationProperty(store, omiUtil, jomaObject, "IsGridCapable", this.isGridCapable, "false");
        this.makeApplicationProperty(store, omiUtil, jomaObject, "IsSoap", this.isSoap, "false");
        this.makeRegisteredSASApplicationComponent(store, omiUtil, jomaObject);
        this.setParentComponent(store, omiUtil, jomaObject);
        this._jomaObject = jomaObject;
        this._context.getLogger().info(Message.format((ResourceBundle)RB.getResources(), (String)"Application.CreatingApplication.fmt.log", (Object)this.productName));
        this.setParentFolder(server, jomaObject);
        this.mergeComponents();
    }

    void updateExistingApplication(OMIServer server) throws RemoteException, MdException, ParseException, AppMetaException, ServiceException, IllegalStateException {
        SoftwareComponent jomaObject;
        MdObjectStore store = server.getObjectStore();
        MdOMIUtil omiUtil = store.getFactory().getOMIUtil();
        try {
            jomaObject = (SoftwareComponent)omiUtil.getMetadataAllDepths((MdStore)store, "SoftwareComponent", this._context.getApplicationId(), null, null, null, 8);
        }
        catch (MdException e) {
            this._context.declareError(10);
            throw new AppMetaException(Message.format((ResourceBundle)RB.getResources(), (String)"Application.ApplicationNotFound.fmt.log", (Object)this._context.getApplicationId()), e);
        }
        if (jomaObject == null) {
            this._context.declareError(10);
            throw new AppMetaException(Message.format((ResourceBundle)RB.getResources(), (String)"Application.ApplicationNotFound.fmt.log", (Object)this._context.getApplicationId()));
        }
        this._name = this._context.getApplicationName() != null ? this._context.getApplicationName() : null;
        this.folderPath = this._context.getFolder() != null ? this._context.getFolder() : null;
        jomaObject.setPublicType("Application");
        jomaObject.setUsageVersion(1000000.0);
        if (this._name != null && !jomaObject.getName().equals(this._name)) {
            jomaObject.setName(this._name);
        }
        if (this.classIdentifier != null && !jomaObject.getClassIdentifier().equals(this.classIdentifier)) {
            jomaObject.setClassIdentifier(this.classIdentifier);
        }
        if (this._desc != null && !jomaObject.getDesc().equals(this._desc)) {
            jomaObject.setDesc(this._desc);
        }
        if (this.major >= 0 && jomaObject.getMajor() != this.major) {
            jomaObject.setMajor(this.major);
        }
        if (this.minor >= 0 && jomaObject.getMinor() != this.minor) {
            jomaObject.setMinor(this.minor);
        }
        if (this.platform != null && !jomaObject.getPlatform().equals(this.platform)) {
            jomaObject.setPlatform(this.platform);
        }
        if (this.productIdentifier != null && !jomaObject.getProductIdentifier().equals(this.productIdentifier)) {
            jomaObject.setProductIdentifier(this.productIdentifier);
        }
        if (this.productName != null && !jomaObject.getProductName().equals(this.productName)) {
            jomaObject.setProductName(this.productName);
        }
        if (this.softwareVersion != null && !jomaObject.getSoftwareVersion().equals(this.softwareVersion)) {
            jomaObject.setSoftwareVersion(this.softwareVersion);
        }
        if (this.specVendor != null && !jomaObject.getSpecVendor().equals(this.specVendor)) {
            jomaObject.setSpecVendor(this.specVendor);
        }
        if (this.specVersion != null && !jomaObject.getSpecVersion().equals(this.specVersion)) {
            jomaObject.setSpecVersion(this.specVersion);
        }
        if (this.vendor != null && !jomaObject.getVendor().equals(this.vendor)) {
            jomaObject.setVendor(this.vendor);
        }
        if (this.vendorIdentifier != null && !jomaObject.getVendorIdentifier().equals(this.vendorIdentifier)) {
            jomaObject.setVendorIdentifier(this.vendorIdentifier);
        }
        this.makeApplicationProperty(store, omiUtil, jomaObject, "AssociatedApplication", this.associatedApplication, "");
        this.makeApplicationProperty(store, omiUtil, jomaObject, "IsDefaultInstance", this.isDefaultInstance, "false");
        this.makeApplicationProperty(store, omiUtil, jomaObject, "IsGridCapable", this.isGridCapable, "false");
        this.makeApplicationProperty(store, omiUtil, jomaObject, "IsSoap", this.isSoap, "false");
        this.makeRegisteredSASApplicationComponent(store, omiUtil, jomaObject);
        this.setParentComponent(store, omiUtil, jomaObject);
        this._jomaObject = jomaObject;
        this._context.getLogger().info(Message.format((ResourceBundle)RB.getResources(), (String)"Application.UpdatingApplication.fmt.log", (Object)this.productName));
        this.setParentFolder((MetadataServerInterface)server, jomaObject);
        this.mergeComponents();
    }

    private void setParentComponent(MdObjectStore store, MdOMIUtil omiUtil, SoftwareComponent object) throws RemoteException, MdException {
        if (this.parentComponent == null || this.parentComponent.length() == 0) {
            return;
        }
        List components = omiUtil.getMetadataObjectsSubset((MdStore)store, omiUtil.getFoundationReposID(), "SoftwareComponent", 8584, "<XMLSelect search=\"SoftwareComponent[@Name='" + this.parentComponent + "' and @PublicType='Application']\"/>");
        if (components.size() > 1) {
            this._context.getLogger().warn(Message.format((ResourceBundle)RB.getResources(), (String)"Application.MultipleParentComponents.fmt.log", (Object)this.parentComponent));
            this._context.declareWarning();
        } else if (components.size() == 0) {
            this._context.getLogger().warn(Message.format((ResourceBundle)RB.getResources(), (String)"Application.MissingParentComponent.fmt.log", (Object)this.parentComponent));
            this._context.declareWarning();
        } else {
            SoftwareComponent parentComp = (SoftwareComponent)components.get(0);
            object.getImplementedObjects().set(0, (Object)parentComp);
        }
    }

    private void makeApplicationProperty(MdObjectStore store, MdOMIUtil omiUtil, SoftwareComponent object, String propertyName, String propertyValue, String defaultValue) throws RemoteException, MdException {
        AssociationList properties = object.getProperties();
        for (Object item : properties) {
            Property property = (Property)item;
            if (!property.getName().equalsIgnoreCase(propertyName)) continue;
            property.delete();
            break;
        }
        if (propertyValue != null && !propertyValue.equalsIgnoreCase(defaultValue)) {
            Property applicationProperty = (Property)store.getFactory().createComplexMetadataObject(store, propertyName, "Property", omiUtil.getFoundationReposID().substring(9));
            applicationProperty.setAssociatedObject((Root)object);
            applicationProperty.setPropertyName(propertyName);
            applicationProperty.setSQLType(12);
            applicationProperty.setDefaultValue(propertyValue);
        }
    }

    private void makeRegisteredSASApplicationComponent(MdObjectStore store, MdOMIUtil omiUtil, SoftwareComponent object) throws RemoteException, MdException {
        if (!this.registeredSASApplication) {
            return;
        }
        String COMPONENT_NAME = "Registered SAS Application";
        String CONNECTION_URI_NAME = "Connection URI";
        String EXTERNAL_URI_NAME = "External URI";
        DeployedComponent regSASApp = null;
        TCPIPConnection connectionUri = null;
        TCPIPConnection externalUri = null;
        AssociationList deployedComponents = object.getDeployedComponents();
        for (DeployedComponent component : deployedComponents) {
            if (!component.getName().equals("Registered SAS Application")) continue;
            regSASApp = component;
            ArrayList<Connection> oldConnections = new ArrayList<Connection>();
            AssociationList connections = regSASApp.getSourceConnections();
            for (Connection connection : connections) {
                if (connection instanceof TCPIPConnection) {
                    if (connection.getName().equals("Connection URI")) {
                        connectionUri = (TCPIPConnection)connection;
                        continue;
                    }
                    if (connection.getName().equals("External URI")) {
                        externalUri = (TCPIPConnection)connection;
                        continue;
                    }
                    oldConnections.add(connection);
                    continue;
                }
                oldConnections.add(connection);
            }
            for (Connection connection : oldConnections) {
                connection.delete();
            }
        }
        if (regSASApp == null) {
            regSASApp = (DeployedComponent)store.getFactory().createComplexMetadataObject(store, "Registered SAS Application", "DeployedComponent", omiUtil.getFoundationReposID().substring(9));
            regSASApp.setDescriptiveComponent(object);
        }
        if (this.uriProtocol != null && !this.uriProtocol.isEmpty() || this.uriHost != null && !this.uriHost.isEmpty() || this.uriService != null && !this.uriService.isEmpty()) {
            if (connectionUri == null) {
                connectionUri = (TCPIPConnection)store.getFactory().createComplexMetadataObject(store, "Connection URI", "TCPIPConnection", omiUtil.getFoundationReposID().substring(9));
                connectionUri.setSource(regSASApp);
                connectionUri.setCommunicationProtocol("http");
            }
            boolean uriChanged = false;
            if (this.uriProtocol != null && !this.uriProtocol.equals(connectionUri.getCommunicationProtocol())) {
                connectionUri.setCommunicationProtocol(this.uriProtocol);
                uriChanged = true;
            }
            if (this.uriHost != null && !this.uriHost.equals(connectionUri.getHostName())) {
                connectionUri.setHostName(this.uriHost);
                uriChanged = true;
            }
            if (this.uriPort != connectionUri.getPort()) {
                connectionUri.setPort(this.uriPort);
                uriChanged = true;
            }
            if (this.uriService != null && !this.uriService.equals(connectionUri.getService())) {
                connectionUri.setService(this.uriService);
                uriChanged = true;
            }
            if (uriChanged && externalUri != null) {
                externalUri.delete();
            }
        } else {
            if (connectionUri != null) {
                connectionUri.delete();
            }
            if (externalUri != null) {
                externalUri.delete();
            }
        }
    }

    void setParentFolder(MetadataServerInterface server, SoftwareComponent object) throws RemoteException, MdException, AppMetaException {
        if (this.folderPath == null || this.folderPath.length() == 0) {
            return;
        }
        try {
            FolderInterface newFolder;
            Tree newFolderObject;
            AssociationList oldTrees = this._jomaObject.getTrees();
            Tree oldFolderObject = null;
            if (oldTrees.size() > 0) {
                oldFolderObject = (Tree)oldTrees.get(0);
            }
            if ((newFolderObject = (Tree)(newFolder = this._context.makeFolder(server, this.folderPath)).getRepositoryEntity()) != oldFolderObject) {
                this._jomaObject.getTrees().set(0, (Object)newFolderObject);
                this._context.getLogger().info(Message.format((ResourceBundle)RB.getResources(), (String)"Application.MovingApplication.fmt.log", (Object)this.folderPath));
            } else {
                this._context.getLogger().info(Message.format((ResourceBundle)RB.getResources(), (String)"Application.InFolder.fmt.log", (Object)this.folderPath));
            }
        }
        catch (ServiceException e) {
            throw new AppMetaException(Message.format((ResourceBundle)RB.getResources(), (String)"Application.FolderCreateError.fmt.log", (Object)this.folderPath), e);
        }
    }

    private void mergeComponents() throws MdException {
        if (this.rootCategory != null) {
            this.rootCategory.mergeToMetadata();
        }
        if (this.directives != null) {
            this.directives.mergeToMetadata();
        }
        if (this._configuration != null) {
            this._configuration.mergeToMetadata();
        }
        if (this.services != null) {
            this.services.mergeToMetadata();
        }
        if (this.hubIntegration != null) {
            this.hubIntegration.mergeToMetadata();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void loadFromMetadata(MetadataServerInterface metadataServer) throws MdException, MissingOptionException, AppMetaException, ServiceException, IllegalStateException {
        MdObjectStore store = ((OMIServer)metadataServer).getObjectStore();
        SoftwareComponent sc = null;
        try {
            AssociationList implObjects;
            MdOMIUtil omiUtil = store.getFactory().getOMIUtil();
            String id = this._context.getApplicationId();
            String name = this._context.getApplicationName();
            if (id != null && id.length() > 0) {
                sc = (SoftwareComponent)omiUtil.getMetadataAllDepths((MdStore)store, "SoftwareComponent", id, null, null, null, 8);
                if (sc == null) {
                    throw new AppMetaException(Message.format((ResourceBundle)RB.getResources(), (String)"Application.ApplicationNotFound.fmt.log", (Object)id));
                }
            } else {
                if (name == null || name.length() <= 0) throw new MissingOptionException("You must identify the application with the -applicationId or -applicationName option.");
                List objects = omiUtil.getMetadataObjectsSubset((MdStore)store, omiUtil.getFoundationReposID(), "SoftwareComponent", 8584, "<XMLSelect search=\"SoftwareComponent[@Name='" + name + "' and @PublicType='Application']\"/>");
                if (objects.size() < 1) throw new AppMetaException(Message.format((ResourceBundle)RB.getResources(), (String)"Application.ApplicationNotFound.fmt.log", (Object)name));
                sc = (SoftwareComponent)objects.get(0);
            }
            this._jomaObject = sc;
            this._name = sc.getName();
            this.classIdentifier = sc.getClassIdentifier();
            this._desc = sc.getDesc();
            this.major = sc.getMajor();
            this.minor = sc.getMinor();
            this.platform = sc.getPlatform();
            this.productIdentifier = sc.getProductIdentifier();
            this.productName = sc.getProductName();
            this.softwareVersion = sc.getSoftwareVersion();
            this.specVendor = sc.getSpecVendor();
            this.specVersion = sc.getSpecVersion();
            this.vendor = sc.getVendor();
            this.vendorIdentifier = sc.getVendorIdentifier();
            for (Object item : sc.getProperties()) {
                Property property = (Property)item;
                if (property.getPropertyName().equalsIgnoreCase("AssociatedApplication")) {
                    this.associatedApplication = property.getDefaultValue();
                    continue;
                }
                if (property.getPropertyName().equalsIgnoreCase("IsDefaultInstance")) {
                    this.isDefaultInstance = property.getDefaultValue();
                    continue;
                }
                if (property.getPropertyName().equalsIgnoreCase("IsGridCapable")) {
                    this.isGridCapable = property.getDefaultValue();
                    continue;
                }
                if (!property.getPropertyName().equalsIgnoreCase("IsSoap")) continue;
                this.isSoap = property.getDefaultValue();
            }
            block5: for (Object item : sc.getDeployedComponents()) {
                DeployedComponent comp;
                if (!(item instanceof DeployedComponent) || !(comp = (DeployedComponent)item).getName().equals("Registered SAS Application")) continue;
                this.registeredSASApplication = true;
                for (Object conn : comp.getSourceConnections()) {
                    TCPIPConnection tcp;
                    if (!(conn instanceof TCPIPConnection) || !(tcp = (TCPIPConnection)conn).getName().equals("Connection URI")) continue;
                    this.uriProtocol = tcp.getCommunicationProtocol();
                    this.uriHost = tcp.getHostName();
                    this.uriPort = tcp.getPort();
                    this.uriService = tcp.getService();
                    break block5;
                }
            }
            if (!sc.getTrees().isEmpty()) {
                Tree folderObject = (Tree)sc.getTrees().get(0);
                FolderInterface folder = (FolderInterface)metadataServer.factoryProcess((Object)folderObject);
                this.folderPath = folder.getPathUrl().getDisplayPath();
            }
            if ((implObjects = sc.getImplementedObjects()).size() == 1) {
                try {
                    this.parentComponent = ((SoftwareComponent)implObjects.get(0)).getName();
                }
                catch (ClassCastException e) {
                    this._context.getLogger().warn("ImplementedObjects association object is not a SoftwareComponent.  Unable to extract ParentComponent.");
                    this._context.declareWarning();
                }
            } else if (implObjects.size() > 1) {
                this._context.getLogger().warn("Multiple ImplementedObjects association objects.  Unable to extract ParentComponent.");
                this._context.declareWarning();
            }
            Element app = this._context.sourceDocument.createElement("Application");
            if (this._name != null) {
                app.setAttribute("Name", this._name);
            }
            if (this.productName != null) {
                app.setAttribute("ProductName", this.productName);
            }
            if (this.classIdentifier != null) {
                app.setAttribute("ClassIdentifier", this.classIdentifier);
            }
            if (this._desc != null) {
                app.setAttribute("Desc", this._desc);
            }
            if (this.major >= 0) {
                app.setAttribute("Major", Integer.toString(this.major));
            }
            if (this.minor >= 0) {
                app.setAttribute("Minor", Integer.toString(this.minor));
            }
            if (this.platform != null) {
                app.setAttribute("Platform", this.platform);
            }
            if (this.productIdentifier != null) {
                app.setAttribute("ProductIdentifier", this.productIdentifier);
            }
            if (this.softwareVersion != null) {
                app.setAttribute("SoftwareVersion", this.softwareVersion);
            }
            if (this.specVendor != null) {
                app.setAttribute("SpecVendor", this.specVendor);
            }
            if (this.specVersion != null) {
                app.setAttribute("SpecVersion", this.specVersion);
            }
            if (this.vendor != null) {
                app.setAttribute("Vendor", this.vendor);
            }
            if (this.vendorIdentifier != null) {
                app.setAttribute("VendorIdentifier", this.vendorIdentifier);
            }
            if (this.associatedApplication != null) {
                app.setAttribute("AssociatedApplication", this.associatedApplication);
            }
            if (this.isDefaultInstance != null) {
                app.setAttribute("IsDefaultInstance", this.isDefaultInstance);
            }
            if (this.isGridCapable != null) {
                app.setAttribute("IsGridCapable", this.isGridCapable);
            }
            if (this.isSoap != null) {
                this._context.getLogger().warn("IsSoap attribute on Application objects is deprecated and will be ignored.");
                this._context.declareWarning();
            }
            if (this.folderPath != null && this.folderPath.length() > 0) {
                app.setAttribute("Folder", this.folderPath);
            }
            if (this.parentComponent != null && this.parentComponent.length() > 0) {
                app.setAttribute("ParentComponent", this.parentComponent);
            }
            app.getOwnerDocument().getLastChild().appendChild(app);
            if (this.registeredSASApplication) {
                Element appUri = this._context.sourceDocument.createElement("ApplicationUri");
                if (this.uriProtocol != null) {
                    appUri.setAttribute("Protocol", this.uriProtocol);
                }
                if (this.uriHost != null) {
                    appUri.setAttribute("Host", this.uriHost);
                }
                if (this.uriPort > 0) {
                    appUri.setAttribute("Port", Integer.toString(this.uriPort));
                }
                if (this.uriService != null) {
                    appUri.setAttribute("Service", this.uriService);
                }
                app.appendChild(appUri);
            }
            for (Object item : ((SoftwareComponent)this._jomaObject).getSoftwareTrees()) {
                Tree tree = (Tree)item;
                if (tree.getName().equals("ApplicationActions") && this.rootCategory == null) {
                    this.rootCategory = CapabilityCategory.create(this, null);
                    this.rootCategory.loadFromMetadata(tree, app);
                    continue;
                }
                if (!tree.getName().equals("Directives") || this.directives != null) continue;
                this.directives = Directives.create(this);
                this.directives.loadFromMetadata(tree, app);
            }
            for (Object item : this._jomaObject.getPropertySets()) {
                PropertySet set = (PropertySet)item;
                if (!set.getName().equals("Application Configuration")) continue;
                this._configuration = Configuration.create(this);
                this._configuration.loadFromMetadata(set, app);
                break;
            }
            this.services = Services.create(this);
            this.services.loadFromMetadata(sc, app);
            this.hubIntegration = HubIntegration.create(this);
            this.hubIntegration.loadFromMetadata(app);
            return;
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    void removeAllCapabilities() {
        this.rootCategory = null;
    }

    void removeCapabilities(Capability capability) {
        this.capabilities.remove(capability.getId());
    }

    public PropertyList getLocalizableProperties() throws UnexpectedLocalizationException {
        PropertyList list = new PropertyList();
        list.addProperty("Desc", this._desc);
        if (this.rootCategory != null) {
            list.addProperty("Capabilities", this.rootCategory.getLocalizableProperties());
        }
        PropertyList capList = new PropertyList();
        ArrayList<String> capabilitiesList = new ArrayList<String>(this.capabilities.keySet().size());
        capabilitiesList.addAll(this.capabilities.keySet());
        Collections.sort(capabilitiesList);
        for (String capabilityId : capabilitiesList) {
            capList.addProperty(capabilityId, this.capabilities.get(capabilityId).getLocalizableProperties());
        }
        list.addProperty("Capability", capList);
        if (this.directives != null) {
            list.addProperty("Directives", this.directives.getLocalizableProperties());
        }
        if (this._configuration != null) {
            list.addProperty("Configuration", this._configuration.getLocalizableProperties());
        }
        if (this.services != null) {
            list.addProperty("Services", this.services.getLocalizableProperties());
        }
        if (this.hubIntegration != null) {
            list.addProperty("Hub", this.hubIntegration.getLocalizableProperties());
        }
        return list;
    }

    public void setLocalizableProperties(PropertyMap map) throws UnexpectedLocalizationException {
        PropertyMap capsMap;
        if (map.containsProperty("Desc")) {
            this._desc = map.getProperty("Desc");
        }
        if (this.rootCategory != null && map.containsNestedProperty("Capabilities")) {
            this.rootCategory.setLocalizableProperties(map.getNestedProperties("Capabilities"));
        }
        if ((capsMap = map.getNestedProperties("Capability")) != null) {
            for (String capabilityId : this.capabilities.keySet()) {
                PropertyMap capMap = capsMap.getNestedProperties(capabilityId);
                if (capMap == null) continue;
                this.capabilities.get(capabilityId).setLocalizableProperties(capMap);
            }
        }
        if (this.directives != null && map.containsNestedProperty("Directives")) {
            this.directives.setLocalizableProperties(map.getNestedProperties("Directives"));
        }
        if (this._configuration != null && map.containsNestedProperty("Configuration")) {
            this._configuration.setLocalizableProperties(map.getNestedProperties("Configuration"));
        }
        if (this.services != null && map.containsNestedProperty("Services")) {
            this.services.setLocalizableProperties(map.getNestedProperties("Services"));
        }
        if (this.hubIntegration != null && map.containsNestedProperty("Hub")) {
            this.hubIntegration.setLocalizableProperties(map.getNestedProperties("Hub"));
        }
    }

    public void beginLocalization() throws UnexpectedLocalizationException {
        if (this._configuration != null) {
            this._configuration.beginLocalization();
        }
        if (this.hubIntegration != null) {
            this.hubIntegration.beginLocalization();
        }
    }

    public void endLocalization() throws UnexpectedLocalizationException {
        if (this._configuration != null) {
            this._configuration.endLocalization();
        }
        if (this.hubIntegration != null) {
            this.hubIntegration.endLocalization();
        }
    }

    public Collection<Locale> getLocales() throws UnexpectedLocalizationException {
        HashSet<Locale> locales = new HashSet<Locale>();
        if (this._configuration != null) {
            locales.addAll(this._configuration.getLocales());
        }
        if (this.hubIntegration != null) {
            locales.addAll(this.hubIntegration.getLocales());
        }
        return locales;
    }

    public PropertyList getLocalizableProperties(Locale locale) throws UnexpectedLocalizationException {
        PropertyList list = new PropertyList();
        if (this._configuration != null) {
            list.addProperty("Configuration", this._configuration.getLocalizableProperties(locale));
        }
        if (this.hubIntegration != null) {
            list.addProperty("Hub", this.hubIntegration.getLocalizableProperties(locale));
        }
        return list;
    }

    public void setLocalizableProperties(Locale locale, PropertyMap map) throws UnexpectedLocalizationException {
        if (this._configuration != null && map.containsNestedProperty("Configuration")) {
            this._configuration.setLocalizableProperties(locale, map.getNestedProperties("Configuration"));
        }
        if (this.services != null && map.containsNestedProperty("Services")) {
            this.services.setLocalizableProperties(locale, map.getNestedProperties("Services"));
        }
        if (this.hubIntegration != null && map.containsNestedProperty("Hub")) {
            this.hubIntegration.setLocalizableProperties(locale, map.getNestedProperties("Hub"));
        }
    }
}

