/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDCompositeNode;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.scheduler.model.TimeEventInfo;
import com.sas.scheduler.pfd.FlowPort;
import com.sas.scheduler.pfd.PropertyAction;
import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.scheduler.visuals.swing.TimeEventPanel;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class Time
extends PFDCompositeNode {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private TimeEventInfo m_info;
    private transient Frame m_frame;
    private transient ActionListener m_timePropertiesListener;

    public Time(TimeEventInfo time, Frame frame) {
        this.m_info = time;
        this.m_frame = frame;
        this.setTitleText(time.toString());
        this.setNodeType("Time");
        this.setSupportedFromNodeTypes(new String[0]);
        this.setToolTipText(time.toString());
        this.setNodeStyleContext("NodeStyle1");
        this.setNodeIcon((Icon)IconUtil.getIcon((String)time.getIconName()));
        this.getInputPort().setValidToPort(false);
        this.removeAllOutputPorts();
        this.addOutputPort(new FlowPort());
    }

    public void setPropertiesListener(ActionListener actL) {
        this.m_timePropertiesListener = actL;
    }

    public void setFrame(Frame frame) {
        this.m_frame = frame;
    }

    public TimeEventInfo getInfo() {
        return this.m_info;
    }

    public void setInfo(TimeEventInfo info) {
        this.m_info = info;
        this.setTitleText(this.m_info.toString());
        try {
            PFDLink link = (PFDLink)this.getOutputPort().getFromLinks().get(0);
            if (link != null) {
                link.setMiddleLabel(this.m_info.toString());
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void updateInfo(TimeEventInfo info) {
        if (!this.m_info.equals(info)) {
            this.m_info.setName(info.getName());
            this.m_info.setRecurrence(info.getRecurrence());
            this.m_info.setHours(info.getHours());
            this.m_info.setMinutes(info.getMinutes());
            this.m_info.setDuration(info.getDuration());
            this.m_info.setUser(info.getUser());
            this.m_info.setScheduler(info.getScheduler());
            this.m_info.setTimezone(info.getTimezone());
            this.m_info.setDescription(info.getDescription());
        }
        this.setTitleText(this.m_info.toString());
        try {
            PFDLink link = (PFDLink)this.getOutputPort().getFromLinks().get(0);
            if (link != null) {
                link.setMiddleLabel(this.m_info.toString());
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void customize(PFDView view) {
        if (this.m_timePropertiesListener != null) {
            this.m_timePropertiesListener.actionPerformed(new ActionEvent((Object)this, 1001, null));
        } else {
            TimeEventPanel panel = new TimeEventPanel(this.m_frame, true);
            if (this.m_info != null) {
                panel.setEvent(this.m_info);
            }
            StandardDialog dlg = new StandardDialog(this.m_frame, m_bundle.getString("Time.Properties.Title.txt"), true);
            dlg.setMainPanel((StandardPanel)panel);
            dlg.setHelpProduct("scheduler");
            dlg.setHelpTopic("window_new_time_event");
            dlg.makeVisible();
            this.setInfo(panel.getEvent());
        }
    }

    public List<JComponent> getMenuItems() {
        List supers = super.getMenuItems();
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>(supers.size() + 2);
        menuItems.addAll(supers);
        menuItems.add(new JPopupMenu.Separator());
        PropertyAction action = new PropertyAction((PFDAbstractNode)this, null);
        JMenuItem item = new JMenu().add(action);
        item.setToolTipText(null);
        menuItems.add(item);
        return menuItems;
    }

    public Object cloneObject(Hashtable table) {
        TimeEventInfo i = new TimeEventInfo(this.m_info.getRecurrence(), this.m_info.getUser(), this.m_info.getHours(), this.m_info.getMinutes(), this.m_info.getDuration(), this.m_info.getOccur(), this.m_info.getTimezone());
        Time clone = new Time(i, this.m_frame);
        clone.setPropertiesListener(this.m_timePropertiesListener);
        table.put(this, clone);
        this.copyObject(clone);
        FlowPort oldPort = (FlowPort)this.getOutputPort();
        FlowPort newPort = (FlowPort)((Object)oldPort.cloneObject(table));
        clone.setOutputPort(newPort);
        return clone;
    }

    static {
        String strClassName = Time.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }
}

