/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.swing.visuals.util.Util;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;

public class PropertyAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private PFDAbstractNode m_node;
    private PFDLink m_link;
    private ActionListener m_action;
    private PFDView m_view;

    public PropertyAction(PFDAbstractNode node, PFDView view) {
        this(node, null, null, view);
    }

    public PropertyAction(PFDLink link, PFDView view) {
        this(null, link, null, view);
    }

    public PropertyAction(ActionListener action, PFDView view) {
        this(null, null, action, view);
    }

    private PropertyAction(PFDAbstractNode node, PFDLink link, ActionListener action, PFDView view) {
        super("properties");
        this.m_node = node;
        this.m_link = link;
        this.m_action = action;
        this.m_view = view;
        String nameString = m_bundle.getString("PropertyAction.Name.txt");
        this.putValue("Name", Util.getLabelWithoutMnemonic((String)nameString));
        this.putValue("MnemonicKey", Util.getDisplayedMnemonic((String)nameString));
        this.putValue("SmallIcon", IconUtil.getIcon((String)IconUtil.ACTION_Properties));
        this.putValue("ShortDescription", m_bundle.getString("PropertyAction.ShortDescription.txt"));
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (this.m_node != null) {
            this.m_node.customize(this.m_view);
        } else if (this.m_link != null) {
            this.m_link.customize(this.m_view);
        } else if (this.m_action != null) {
            this.m_action.actionPerformed(new ActionEvent(this.m_view, 1001, null));
        }
    }

    static {
        String strClassName = PropertyAction.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }
}

