/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.interfaces.PFDLinkValidator;
import java.io.Serializable;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class JobEventLinkValidator
implements PFDLinkValidator,
Serializable {
    private static final long serialVersionUID = 1L;
    private Boolean m_rc = null;
    private PFDPort m_from = null;
    private PFDPort m_to = null;

    public boolean validateLink(PFDLink link, PFDPort from, PFDPort to) {
        if (this.m_rc != null && this.m_from.equals(from) && this.m_to.equals(to)) {
            return this.m_rc;
        }
        this.m_rc = null;
        this.m_from = from;
        this.m_to = to;
        HashMap<PFDAbstractNode, List<PFDAbstractNode>> processedNodes = new HashMap<PFDAbstractNode, List<PFDAbstractNode>>();
        PFDAbstractNode fromNode = (PFDAbstractNode)link.getFromNode();
        PFDAbstractNode toNode = to.getParentNode();
        Vector joblinks = toNode != null ? toNode.getOutputLinks() : new Vector();
        for (int i = 0; i < joblinks.size(); ++i) {
            PFDLink jlink = (PFDLink)joblinks.get(i);
            PFDAbstractNode currentNode = (PFDAbstractNode)jlink.getToNode();
            try {
                List<PFDAbstractNode> successorObjects = this.processNode(currentNode, new ArrayList<PFDAbstractNode>(), processedNodes);
                if (!successorObjects.contains(fromNode)) continue;
                this.m_rc = Boolean.FALSE;
                return false;
            }
            catch (InvalidParameterException ex) {
                this.m_rc = Boolean.FALSE;
                return false;
            }
        }
        this.m_rc = Boolean.TRUE;
        return true;
    }

    private List<PFDAbstractNode> processNode(PFDAbstractNode tnode, List<PFDAbstractNode> successorObjects, HashMap<PFDAbstractNode, List<PFDAbstractNode>> processedNodes) throws InvalidParameterException {
        if (processedNodes.containsKey(tnode)) {
            return processedNodes.get(tnode);
        }
        ArrayList<PFDAbstractNode> successorTemp = new ArrayList<PFDAbstractNode>(successorObjects);
        successorObjects.add(tnode);
        if (successorTemp.contains(tnode)) {
            InvalidParameterException ex = new InvalidParameterException();
            throw ex;
        }
        Vector joblinks = tnode.getOutputLinks();
        for (int i = 0; i < joblinks.size(); ++i) {
            PFDLink jlink = (PFDLink)joblinks.get(i);
            PFDAbstractNode currentNode = (PFDAbstractNode)jlink.getToNode();
            if (currentNode == null) continue;
            successorObjects.addAll(this.processNode(currentNode, new ArrayList<PFDAbstractNode>(), processedNodes));
        }
        processedNodes.put(tnode, successorObjects);
        return successorObjects;
    }

    public String getInvalidLinkMessage(PFDLink link, PFDAbstractNode fromNode, PFDPort fromPort, PFDAbstractNode toNode, PFDPort toPort) {
        return null;
    }
}

