/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.pfd;

import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.JobEventInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.pfd.FlowEventLink;
import com.sas.scheduler.pfd.JobEventLinkValidator;
import com.sas.scheduler.pfd.PropertyAction;
import com.sas.scheduler.visuals.swing.JobEventPanel;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.StandardPanel;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class JobEventLink
extends FlowEventLink {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private JobEventInfo m_info;
    private FlowInfo m_flow;
    private DisplayInfo m_targetJob;
    private transient Frame m_frame;

    public JobEventLink() {
        super(null, null);
        this.addValidator(new JobEventLinkValidator());
    }

    public JobEventLink(PFDPort from, PFDPort to, JobEventInfo info, FlowInfo flow, JobInfo job, Frame frame) {
        this(from, to, info, flow, (DisplayInfo)job, frame);
    }

    public JobEventLink(PFDPort from, PFDPort to, JobEventInfo info, FlowInfo flow, FlowInfo subflow, Frame frame) {
        this(from, to, info, flow, (DisplayInfo)subflow, frame);
    }

    public JobEventLink(PFDPort from, PFDPort to, JobEventInfo info, FlowInfo flow, DisplayInfo job, Frame frame) {
        super(from, to);
        this.addValidator(new JobEventLinkValidator());
        this.m_info = info;
        this.m_flow = flow;
        this.m_targetJob = job;
        this.m_frame = frame;
    }

    public void setFrame(Frame frame) {
        this.m_frame = frame;
    }

    public JobEventInfo getInfo() {
        return this.m_info;
    }

    public void setFlow(FlowInfo flow) {
        this.m_flow = flow;
    }

    public void setInfo(JobEventInfo info) {
        this.m_info = info;
        boolean reset = this.isMiddleLabelVisible();
        this.setMiddleLabelVisible(false);
        this.setMiddleLabel(this.m_info.toString());
        this.setMiddleLabelVisible(reset);
    }

    public void updateInfo(JobEventInfo info) {
        if (this.m_info.equals(info)) {
            return;
        }
        this.m_info.setEventType(info.getEventType());
        this.m_info.setOperator(info.getOperator());
        this.m_info.setValue(info.getValue());
        this.m_info.setJobInfo(info.getJobInfo());
        this.m_info.setDescription(info.getDescription());
        boolean reset = this.isMiddleLabelVisible();
        this.setMiddleLabelVisible(false);
        this.setMiddleLabel(this.m_info.toString());
        this.setMiddleLabelVisible(reset);
    }

    public void setTargetJob(JobInfo job) {
        this.m_targetJob = job;
    }

    public void setTargetJob(FlowInfo subflow) {
        this.m_targetJob = subflow;
    }

    public void setTargetJob(DisplayInfo target) {
        this.m_targetJob = target;
    }

    @Override
    public void customize(PFDView view) {
        this.setMiddleLabelVisible(false);
        JobInfo fromInfo = this.m_info.getJobInfo();
        JobEventPanel panel = new JobEventPanel(this.m_frame, this.m_info, fromInfo, this.m_flow, this.m_flow.getEvents(this.m_targetJob));
        StandardDialog dia = new StandardDialog(this.m_frame, m_bundle.getString("JobEventLink.EditJobEvent.Title.txt"), true);
        dia.setMainPanel((StandardPanel)panel);
        dia.setHelpProduct("scheduler");
        dia.setHelpTopic("window_newjob");
        dia.makeVisible();
        if (dia.getReturnValue() == 1) {
            this.updateInfo(panel.getJobEvent());
        }
    }

    @Override
    public List<JComponent> getMenuItems() {
        List<?> supers = super.getSuperMenuItems();
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>(supers.size() + 2);
        menuItems.addAll(supers);
        menuItems.add(new JPopupMenu.Separator());
        PropertyAction action = new PropertyAction(this, null);
        JMenuItem item = new JMenu().add(action);
        item.setToolTipText(null);
        menuItems.add(item);
        return menuItems;
    }

    @Override
    public Object cloneObject(Hashtable table) {
        JobEventLink clone = new JobEventLink();
        table.put(this, clone);
        this.copyObject(clone);
        return clone;
    }

    static {
        String strClassName = JobEventLink.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }
}

