/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDControlNode;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDLogicalOperatorNode;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.scheduler.model.GroupingEventInfo;
import com.sas.scheduler.pfd.FlowPort;
import com.sas.scheduler.pfd.PropertyAction;
import com.sas.scheduler.visuals.swing.GroupingPanel;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.StandardPanel;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class Gate
extends PFDLogicalOperatorNode {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private GroupingEventInfo m_info;
    private transient Frame m_frame;

    public Gate(GroupingEventInfo grouping, Frame frame) {
        super(grouping.getEventType() == 0 ? 0 : 1);
        this.setNodeType("Gate");
        this.setSupportedFromNodeTypes(new String[]{"File", "Time", "Job", "Gate", "Subflow"});
        FlowPort inputPort = new FlowPort();
        inputPort.setMaxNumLinks(Integer.MAX_VALUE);
        this.setInputPort(inputPort);
        this.setOutputPort(new FlowPort());
        this.setInfo(grouping);
        this.setFrame(frame);
    }

    public void setFrame(Frame frame) {
        this.m_frame = frame;
    }

    public GroupingEventInfo getInfo() {
        return this.m_info;
    }

    public boolean setInfo(GroupingEventInfo info) {
        this.m_info = info;
        int type = 1;
        if (this.m_info.getEventType() == 0) {
            type = 0;
        }
        this.setOperatorType(type);
        this.setTitleText(this.m_info.toString());
        this.setToolTipText(this.m_info.toString());
        try {
            PFDLink link = (PFDLink)this.getOutputPort().getFromLinks().get(0);
            if (link != null) {
                link.setMiddleLabel(this.m_info.toString());
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return true;
    }

    public void customize(PFDView view) {
        GroupingPanel panel = new GroupingPanel(this.m_info.getEventType());
        StandardDialog dlg = new StandardDialog(this.m_frame, m_bundle.getString("Gate.Properties.Title.txt"), true);
        dlg.setMainPanel((StandardPanel)panel);
        dlg.setHelpProduct("scheduler");
        dlg.setHelpTopic("window_grouping_node");
        dlg.makeVisible();
        switch (panel.getGroupingType()) {
            case 31: {
                this.m_info.setEventType(0);
                this.setOperatorType(0);
                break;
            }
            case 32: {
                this.m_info.setEventType(1);
                this.setOperatorType(1);
            }
        }
        this.setTitleText(this.m_info.toString());
        this.setToolTipText(this.m_info.toString());
        try {
            PFDLink link = (PFDLink)this.getOutputPort().getFromLinks().get(0);
            if (link != null) {
                link.setMiddleLabel(this.m_info.toString());
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public List<JComponent> getMenuItems() {
        List supers = super.getMenuItems();
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>(supers.size() + 2);
        menuItems.addAll(supers);
        menuItems.add(new JPopupMenu.Separator());
        PropertyAction action = new PropertyAction((PFDAbstractNode)this, null);
        JMenuItem item = new JMenu().add(action);
        item.setToolTipText(null);
        menuItems.add(item);
        return menuItems;
    }

    public Object cloneObject(Hashtable table) {
        GroupingEventInfo i = new GroupingEventInfo(null, this.m_info.getEventType());
        Gate clone = new Gate(i, this.m_frame);
        table.put(this, clone);
        this.copyObject(clone);
        this.clonePorts(table, (PFDControlNode)clone);
        return clone;
    }

    static {
        String strClassName = Gate.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }
}

