/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDCollapsableNodeGroup;
import com.sas.graphics.components.pfd.PFDCompositeNode;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDModel;
import com.sas.graphics.components.pfd.PFDModelEvent;
import com.sas.graphics.components.pfd.PFDModelListener;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.PFDViewEvent;
import com.sas.graphics.components.pfd.PFDViewListener;
import com.sas.graphics.components.util.layout.LayeredLayoutStrategy;
import com.sas.graphics.interfaces.LayoutStrategyInterface;
import com.sas.graphics.interfaces.LinkLayoutInterface;
import com.sas.scheduler.model.AbstractEventInfo;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FileEventInfo;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.FlowPFD;
import com.sas.scheduler.model.GroupingEventInfo;
import com.sas.scheduler.model.JobEventInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.model.TimeEventInfo;
import com.sas.scheduler.pfd.ActionAddFileEvent;
import com.sas.scheduler.pfd.ActionAddGroupingEvent;
import com.sas.scheduler.pfd.ActionAddItemByFolder;
import com.sas.scheduler.pfd.ActionAddJob;
import com.sas.scheduler.pfd.ActionAddSubflow;
import com.sas.scheduler.pfd.ActionAddTimeEvent;
import com.sas.scheduler.pfd.ActionDeleteFlow;
import com.sas.scheduler.pfd.ActionFindNode;
import com.sas.scheduler.pfd.ActionSave;
import com.sas.scheduler.pfd.ActionSaveAndClose;
import com.sas.scheduler.pfd.ActionSchedule;
import com.sas.scheduler.pfd.AddItemActionListener;
import com.sas.scheduler.pfd.File;
import com.sas.scheduler.pfd.FlowEventActionListener;
import com.sas.scheduler.pfd.FlowEventLink;
import com.sas.scheduler.pfd.Gate;
import com.sas.scheduler.pfd.Job;
import com.sas.scheduler.pfd.JobEventLink;
import com.sas.scheduler.pfd.PropertyAction;
import com.sas.scheduler.pfd.Subflow;
import com.sas.scheduler.pfd.Time;
import com.sas.scheduler.visuals.swing.JobEventPanel;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.StandardPanel;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class FlowPFDView
extends PFDView {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    public static final String LAYOUT_DIRECTION_RIGHT = "Right";
    public static final String LAYOUT_DIRECTION_DOWN = "Down";
    public static final String LAYOUT_DIRECTION_LEFT = "Left";
    public static final String LAYOUT_DIRECTION_UP = "Up";
    public static final String NODETYPE_File = "File";
    public static final String NODETYPE_Gate = "Gate";
    public static final String NODETYPE_Job = "Job";
    public static final String NODETYPE_Subflow = "Subflow";
    public static final String NODETYPE_Time = "Time";
    private PFDModel m_pfdModel;
    private transient Frame m_frame;
    private FlowInfo m_flow;
    private List<JobInfo> m_jobList;
    private List<JobInfo> m_flowList;
    private ActionListener m_schListener;
    private ActionListener m_saveListener;
    private ActionListener m_closeListener;
    private ActionListener m_deleteListener;
    private ActionListener m_jobPropertiesListener;
    private FlowEventActionListener m_timeEventListener;
    private ActionListener m_timePropertiesListener;
    private FlowEventActionListener m_fileEventListener;
    private ActionListener m_filePropertiesListener;
    private ActionListener m_flowPropertiesListener;
    private ArrayList<ActionListener> m_actionList = null;
    private ActionAddSubflow m_addSubflowAction = null;
    private boolean m_dirty;
    private myPFDModelListener m_pfdModellistener;
    private AddItemActionListener m_addItemListener;
    private boolean m_stupidUserOption = false;

    public FlowPFDView(Frame frame, FlowInfo flow, List<JobInfo> jobList, List<JobInfo> flowList, ActionListener scheduleListener, ActionListener saveListener, ActionListener closeListener, ActionListener deleteListener) {
        this(frame, flow, jobList, flowList, scheduleListener, saveListener, closeListener, deleteListener, null, null, null, null, null);
    }

    public FlowPFDView(Frame frame, FlowInfo flow, List<JobInfo> jobList, List<JobInfo> flowList, ActionListener scheduleListener, ActionListener saveListener, ActionListener closeListener, ActionListener deleteListener, ActionListener jobPropertiesListener, FlowEventActionListener timeEventListener, ActionListener timePropertiesListener, FlowEventActionListener fileEventListener, ActionListener filePropertiesListener) {
        this.m_frame = frame;
        this.m_flow = flow;
        this.m_jobList = jobList;
        this.m_flowList = flowList;
        this.m_schListener = scheduleListener;
        this.m_saveListener = saveListener;
        this.m_closeListener = closeListener;
        this.m_deleteListener = deleteListener;
        this.m_jobPropertiesListener = jobPropertiesListener;
        this.m_timeEventListener = timeEventListener;
        this.m_timePropertiesListener = timePropertiesListener;
        this.m_fileEventListener = fileEventListener;
        this.m_filePropertiesListener = filePropertiesListener;
        try {
            LayeredLayoutStrategy layout = new LayeredLayoutStrategy();
            layout.setFlowDirection(LAYOUT_DIRECTION_RIGHT);
            this.setPFDLayout((LayoutStrategyInterface)layout);
            this.addPFDViewListener(new myPFDViewListener());
            this.addMouseListener(new myMouseListener());
            this.m_pfdModellistener = new myPFDModelListener();
            this._initializePFD(this.m_pfdModellistener);
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
        this.m_dirty = false;
    }

    public FlowPFDView(Frame frame, FlowInfo flow, AddItemActionListener addItemListener, ActionListener scheduleListener, ActionListener saveListener, ActionListener closeListener, ActionListener deleteListener) {
        this(frame, flow, addItemListener, scheduleListener, saveListener, closeListener, deleteListener, null, null, null, null, null);
    }

    public FlowPFDView(Frame frame, FlowInfo flow, AddItemActionListener addItemListener, ActionListener scheduleListener, ActionListener saveListener, ActionListener closeListener, ActionListener deleteListener, ActionListener jobPropertiesListener, FlowEventActionListener timeEventListener, ActionListener timePropertiesListener, FlowEventActionListener fileEventListener, ActionListener filePropertiesListener) {
        this.m_frame = frame;
        this.m_flow = flow;
        this.m_stupidUserOption = true;
        this.m_jobList = null;
        this.m_flowList = null;
        this.m_addItemListener = addItemListener;
        this.m_schListener = scheduleListener;
        this.m_saveListener = saveListener;
        this.m_closeListener = closeListener;
        this.m_deleteListener = deleteListener;
        this.m_jobPropertiesListener = jobPropertiesListener;
        this.m_timeEventListener = timeEventListener;
        this.m_timePropertiesListener = timePropertiesListener;
        this.m_fileEventListener = fileEventListener;
        this.m_filePropertiesListener = filePropertiesListener;
        try {
            LayeredLayoutStrategy layout = new LayeredLayoutStrategy();
            layout.setFlowDirection(LAYOUT_DIRECTION_RIGHT);
            this.setPFDLayout((LayoutStrategyInterface)layout);
            this.addPFDViewListener(new myPFDViewListener());
            this.addMouseListener(new myMouseListener());
            this.m_pfdModellistener = new myPFDModelListener();
            this._initializePFD(this.m_pfdModellistener);
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
        this.m_dirty = false;
    }

    public void setJobPropertyListener(ActionListener jobPropertiesListener) {
        this.m_jobPropertiesListener = jobPropertiesListener;
    }

    public void setTimeEventListener(FlowEventActionListener timeEventListener) {
        this.m_timeEventListener = timeEventListener;
    }

    public void setTimePropertyListener(ActionListener timePropertiesListener) {
        this.m_timePropertiesListener = timePropertiesListener;
    }

    public void setFileEventListener(FlowEventActionListener fileEventListener) {
        this.m_fileEventListener = fileEventListener;
    }

    public void setFilePropertyListener(ActionListener filePropertiesListener) {
        this.m_filePropertiesListener = filePropertiesListener;
    }

    public void setFlowPropertyListener(ActionListener flowPropertiesListener) {
        this.m_flowPropertiesListener = flowPropertiesListener;
    }

    public void setFrame(Frame frame) {
        this.m_frame = frame;
    }

    public void saveSettingsAndCleanUp() {
        this.dispose();
        this.m_pfdModel = null;
        this.m_frame = null;
        this.m_flow = null;
        this.m_actionList = null;
        this.m_jobList = null;
        this.m_flowList = null;
        this.m_addItemListener = null;
        this.m_schListener = null;
        this.m_saveListener = null;
        this.m_closeListener = null;
        this.m_deleteListener = null;
    }

    public FlowPFD saveModel() {
        if (this.m_flow.saveLayout()) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                this.saveModel(out);
                this.m_flow.setPFD(new FlowPFD(out));
            }
            catch (IOException ioe) {
                this.m_flow.setPFD(null);
            }
        }
        return this.m_flow.getPFD();
    }

    public boolean areOrphanEvents() {
        for (PFDPrimitive node : this.m_pfdModel.getAllNodes()) {
            if (node instanceof Time) {
                int count = ((Time)node).getChildCount();
                if (count != 0) continue;
                return true;
            }
            if (node instanceof File) {
                int count = ((File)node).getChildCount();
                if (count != 0) continue;
                return true;
            }
            if (!(node instanceof Gate)) continue;
            Gate gnode = (Gate)node;
            int ccount = gnode.getChildCount();
            int pcount = gnode.getParentCount();
            if (ccount != 0 && pcount != 0) continue;
            return true;
        }
        return false;
    }

    public boolean removeOrphanEvents() {
        for (PFDPrimitive node : this.m_pfdModel.getAllNodes()) {
            PFDLink link;
            if (node instanceof Time) {
                int count = ((Time)node).getChildCount();
                if (count != 0) continue;
                this.m_pfdModel.removePrimitive(node);
                continue;
            }
            if (node instanceof File) {
                int count = ((File)node).getChildCount();
                if (count != 0) continue;
                this.m_pfdModel.removePrimitive(node);
                continue;
            }
            if (!(node instanceof Gate)) continue;
            Gate gnode = (Gate)node;
            int ccount = gnode.getChildCount();
            int pcount = gnode.getParentCount();
            if (ccount == 0) {
                if (pcount == 1 && (link = gnode.getInputPort().getLink(0)) != null) {
                    this.m_pfdModel.removePrimitive((PFDPrimitive)link);
                }
                this.m_pfdModel.removePrimitive(node);
                continue;
            }
            if (pcount != 0) continue;
            if (ccount == 1 && (link = gnode.getOutputPort().getLink(0)) != null) {
                this.m_pfdModel.removePrimitive((PFDPrimitive)link);
            }
            this.m_pfdModel.removePrimitive(node);
        }
        return true;
    }

    public List<ActionListener> getToolBarActions() {
        return this.getContextMenuActions();
    }

    private void resetActions(FlowInfo flow) {
        if (this.m_actionList == null) {
            this.getContextMenuActions();
        } else {
            SchedulerServerInfo scheduler = flow.getScheduler();
            if (scheduler == null) {
                scheduler = new SchedulerServerInfo("BOGUS");
            }
            boolean timeEventsAllowed = scheduler.isTimeEventSupported();
            boolean fileEventsAllowed = scheduler.isFileEventSupported();
            boolean subflowsAllowed = scheduler.isSubflowSupported();
            boolean timeEventsFound = false;
            boolean fileEventsFound = false;
            boolean subflowsFound = false;
            int numActions = this.m_actionList.size();
            ArrayList<ActionListener> actionList = new ArrayList<ActionListener>(this.m_actionList);
            for (int i = 0; i < numActions; ++i) {
                ActionListener action = actionList.get(i);
                if (action instanceof ActionAddFileEvent) {
                    fileEventsFound = true;
                    if (fileEventsAllowed) {
                        ((ActionAddFileEvent)action).setInfo(flow);
                        continue;
                    }
                    this.m_actionList.remove(action);
                    continue;
                }
                if (action instanceof ActionAddGroupingEvent) {
                    ((ActionAddGroupingEvent)action).setInfo(flow);
                    continue;
                }
                if (action instanceof ActionAddJob) {
                    ((ActionAddJob)action).setInfo(flow);
                    continue;
                }
                if (action instanceof ActionAddSubflow) {
                    subflowsFound = true;
                    if (subflowsAllowed) {
                        ((ActionAddSubflow)action).setInfo(flow);
                        continue;
                    }
                    this.m_actionList.remove(action);
                    continue;
                }
                if (action instanceof ActionAddItemByFolder) {
                    subflowsFound = true;
                    ((ActionAddItemByFolder)action).setInfo(flow);
                    continue;
                }
                if (action instanceof ActionAddTimeEvent) {
                    timeEventsFound = true;
                    if (timeEventsAllowed) {
                        ((ActionAddTimeEvent)action).setInfo(flow);
                        continue;
                    }
                    this.m_actionList.remove(action);
                    continue;
                }
                if (action instanceof ActionDeleteFlow) {
                    ((ActionDeleteFlow)action).setInfo(flow);
                    continue;
                }
                if (action instanceof ActionSave) {
                    ((ActionSave)action).setInfo(flow);
                    continue;
                }
                if (action instanceof ActionSaveAndClose) {
                    ((ActionSaveAndClose)action).setInfo(flow);
                    continue;
                }
                if (!(action instanceof ActionSchedule)) continue;
                ((ActionSchedule)action).setInfo(flow);
            }
            if (timeEventsAllowed && !timeEventsFound) {
                this.m_actionList.add(1, new ActionAddTimeEvent(this.m_frame, this, flow, this.m_timeEventListener, this.m_timePropertiesListener));
            }
            if (fileEventsAllowed && !fileEventsFound) {
                this.m_actionList.add(1, new ActionAddFileEvent(this.m_frame, this, flow, this.m_fileEventListener, this.m_filePropertiesListener));
            }
            if (subflowsAllowed && !subflowsFound) {
                this.m_addSubflowAction = new ActionAddSubflow(this.m_frame, this, flow, this.m_flowList);
                this.m_actionList.add(this.m_addSubflowAction);
            }
        }
    }

    public void refresh(FlowInfo flow) throws SchedulerException {
        this.m_flow = flow;
        this.resetActions(flow);
        this.m_pfdModel.removePFDModelListener((PFDModelListener)this.m_pfdModellistener);
        this._initializePFD(this.m_pfdModellistener);
    }

    public List<Object> getJobs() {
        Vector<Object> nodes = new Vector<Object>();
        for (Object obj : this.m_pfdModel.getAllNodes()) {
            if (!(obj instanceof Job) && !(obj instanceof Subflow)) continue;
            nodes.add(obj);
        }
        return nodes;
    }

    public boolean removeJob(PFDCompositeNode node) {
        if (node instanceof Job) {
            Job job = (Job)node;
            this.m_flow.removeJob((DisplayInfo)job.getInfo());
            return this.m_pfdModel.removePrimitive((PFDPrimitive)job);
        }
        if (node instanceof Subflow) {
            Subflow subflow = (Subflow)node;
            this.m_flow.removeJob((DisplayInfo)subflow.getInfo());
            return this.m_pfdModel.removePrimitive((PFDPrimitive)subflow);
        }
        return false;
    }

    public void updateLists(List<JobInfo> joblist, List<JobInfo> flowlist) {
        this.m_jobList = joblist;
        this.m_flowList = flowlist;
        this.resetActions(this.m_flow);
    }

    public List<ActionListener> getContextMenuActions() {
        if (this.m_actionList == null) {
            SchedulerServerInfo scheduler = this.m_flow.getScheduler();
            if (scheduler == null) {
                scheduler = new SchedulerServerInfo("BOGUS");
            }
            boolean timeEventsAllowed = scheduler.isTimeEventSupported();
            boolean fileEventsAllowed = scheduler.isFileEventSupported();
            boolean subflowsAllowed = scheduler.isSubflowSupported();
            this.m_actionList = new ArrayList();
            if (this.m_stupidUserOption) {
                this.m_actionList.add(new ActionAddItemByFolder(this.m_frame, this, this.m_flow, this.m_addItemListener, this.m_jobPropertiesListener));
            } else {
                this.m_actionList.add(new ActionAddJob(this.m_frame, this, this.m_flow, this.m_jobList, this.m_jobPropertiesListener));
                if (subflowsAllowed) {
                    this.m_addSubflowAction = new ActionAddSubflow(this.m_frame, this, this.m_flow, this.m_flowList);
                    this.m_actionList.add(this.m_addSubflowAction);
                }
            }
            if (fileEventsAllowed) {
                this.m_actionList.add(new ActionAddFileEvent(this.m_frame, this, this.m_flow, this.m_fileEventListener, this.m_filePropertiesListener));
            }
            if (timeEventsAllowed) {
                this.m_actionList.add(new ActionAddTimeEvent(this.m_frame, this, this.m_flow, this.m_timeEventListener, this.m_timePropertiesListener));
            }
            this.m_actionList.add(new ActionAddGroupingEvent(this.m_frame, this, this.m_flow));
            this.m_actionList.add(new ActionSchedule(this.m_frame, this, this.m_flow, this.m_schListener, this.m_saveListener));
            this.m_actionList.add(new ActionFindNode(this.m_frame, this, this.m_flow));
            ActionSave mysaveAction = new ActionSave(this.m_frame, this, this.m_flow, this.m_saveListener);
            this.m_actionList.add(mysaveAction);
            this.m_actionList.add(new ActionSaveAndClose(this.m_frame, this, this.m_flow, mysaveAction, this.m_closeListener));
            this.m_actionList.add(new ActionDeleteFlow(this.m_flow, this.m_deleteListener));
        }
        return this.m_actionList;
    }

    public List getMenuItems() {
        JMenuItem item;
        List<ActionListener> actions = this.getContextMenuActions();
        List supers = super.getMenuItems();
        ArrayList<JComponent> list = new ArrayList<JComponent>(supers.size() + actions.size() + 1);
        list.addAll(supers);
        list.add(new JPopupMenu.Separator());
        Iterator<ActionListener> i = actions.iterator();
        while (i.hasNext()) {
            item = new JMenuItem((AbstractAction)i.next());
            item.setToolTipText(null);
            list.add(item);
        }
        if (this.m_flowPropertiesListener != null) {
            item = new JMenuItem(new PropertyAction(this.m_flowPropertiesListener, (PFDView)this));
            item.setToolTipText(null);
            list.add(item);
        }
        return list;
    }

    public void setCircularListener(ActionListener al) {
        if (this.m_actionList == null) {
            this.getContextMenuActions();
        }
        if (this.m_addSubflowAction != null) {
            this.m_addSubflowAction.setCircularCallbackListener(al);
        }
    }

    public boolean addNode(PFDAbstractNode node) {
        boolean rc = this.m_pfdModel.addPrimitive((PFDPrimitive)node);
        this.m_dirty = true;
        return rc;
    }

    public void moveToNode(PFDAbstractNode node) {
        this.selectPrimitive((PFDPrimitive)node);
        this.panToPrimitive((PFDPrimitive)node);
    }

    public boolean isDirty() {
        return this.m_dirty;
    }

    public void markDirty() {
        this.m_dirty = true;
    }

    public void clearDirty() {
        this.m_dirty = false;
    }

    private void _initializePFD(myPFDModelListener modelListener) throws SchedulerException {
        boolean restore = false;
        if (this.m_flow.saveLayout() && this.m_flow.getPFD() != null) {
            ByteArrayInputStream in = this.m_flow.getPFD().getData();
            try {
                if (in != null) {
                    restore = this.restoreModel(in);
                } else {
                    this.m_flow.setPFD(null);
                    restore = false;
                }
            }
            catch (Exception ex) {
                this.m_flow.setPFD(null);
                restore = false;
            }
        }
        if (restore) {
            this.m_pfdModel = this.getModel();
            this.m_pfdModel.disableChangeUpdate();
            for (PFDPrimitive node : this.m_pfdModel.getAllNodes()) {
                JobInfo jobinfo;
                if (node instanceof Job) {
                    Job jobnode = (Job)node;
                    jobnode.setFrame(this.m_frame);
                    jobinfo = this.m_flow.getJob(jobnode.getInfo().getId());
                    if (jobinfo == null) continue;
                    this.m_pfdModel.enableChangeUpdate();
                    jobnode.setInfo(jobinfo);
                    this.m_pfdModel.disableChangeUpdate();
                    continue;
                }
                if (node instanceof Subflow) {
                    Subflow sflownode = (Subflow)node;
                    sflownode.setFrame(this.m_frame);
                    jobinfo = this.m_flow.getJob(sflownode.getInfo().getId());
                    if (jobinfo == null) continue;
                    this.m_pfdModel.enableChangeUpdate();
                    sflownode.setInfo(jobinfo);
                    this.m_pfdModel.disableChangeUpdate();
                    continue;
                }
                if (node instanceof Gate) {
                    GroupingEventInfo ginfo;
                    Gate gnode = (Gate)node;
                    gnode.setFrame(this.m_frame);
                    String id = gnode.getInfo().getId();
                    if (id == null) {
                        try {
                            id = gnode.getInfo().getTarget().getId();
                        }
                        catch (NullPointerException npe) {
                            id = null;
                        }
                    }
                    if ((ginfo = this.m_flow.getLogicalGrouping(id)) == null) continue;
                    this.m_pfdModel.enableChangeUpdate();
                    gnode.setInfo(ginfo);
                    this.m_pfdModel.disableChangeUpdate();
                    continue;
                }
                if (node instanceof Time) {
                    Time tnode = (Time)node;
                    tnode.setFrame(this.m_frame);
                    AbstractEventInfo tinfo = this.m_flow.getEvent(tnode.getInfo().getId());
                    if (tinfo == null || !(tinfo instanceof TimeEventInfo)) continue;
                    this.m_pfdModel.enableChangeUpdate();
                    tnode.setInfo((TimeEventInfo)tinfo);
                    this.m_pfdModel.disableChangeUpdate();
                    continue;
                }
                if (!(node instanceof File)) continue;
                File fnode = (File)node;
                fnode.setFrame(this.m_frame);
                AbstractEventInfo finfo = this.m_flow.getEvent(fnode.getInfo().getId());
                if (finfo == null || !(finfo instanceof FileEventInfo)) continue;
                this.m_pfdModel.enableChangeUpdate();
                fnode.setInfo((FileEventInfo)finfo);
                this.m_pfdModel.disableChangeUpdate();
            }
            for (PFDPrimitive node : this.getModel().getAllLinks()) {
                if (!(node instanceof JobEventLink)) continue;
                JobEventLink jlink = (JobEventLink)node;
                jlink.setFrame(this.m_frame);
                AbstractEventInfo jinfo = this.m_flow.getEvent(jlink.getInfo().getId());
                if (jinfo == null || !(jinfo instanceof JobEventInfo)) continue;
                this.m_pfdModel.enableChangeUpdate();
                jlink.setInfo((JobEventInfo)jinfo);
                this.m_pfdModel.disableChangeUpdate();
            }
            this.m_pfdModel.addPFDModelListener((PFDModelListener)modelListener);
            this.m_pfdModel.enableChangeUpdate();
        } else {
            this.m_pfdModel = new PFDModel();
            this.m_pfdModel.disableChangeUpdate();
            HashMap<String, PFDAbstractNode> nodes = new HashMap<String, PFDAbstractNode>();
            ArrayList<JobInfo> jobs = new ArrayList<JobInfo>();
            for (DisplayInfo info : this.m_flow.getJobs()) {
                PFDCompositeNode jnode;
                JobInfo job = null;
                if (info instanceof FlowInfo) {
                    job = new JobInfo(info.getName(), info.getId(), null);
                    job.setAsSubflow();
                    String folder = info.getLocation();
                    if (folder != null) {
                        job.setLocation(folder);
                    }
                } else {
                    if (!(info instanceof JobInfo)) continue;
                    job = (JobInfo)info;
                }
                jobs.add(job);
                if (job.isSubflow()) {
                    jnode = new Subflow(job, this.m_frame);
                    this.m_pfdModel.addPrimitive((PFDPrimitive)jnode);
                    nodes.put(job.getId(), (PFDAbstractNode)jnode);
                    continue;
                }
                jnode = new Job(job, this.m_frame);
                if (this.m_jobPropertiesListener != null) {
                    jnode.setPropertiesListener(this.m_jobPropertiesListener);
                }
                this.m_pfdModel.addPrimitive((PFDPrimitive)jnode);
                nodes.put(job.getId(), (PFDAbstractNode)jnode);
            }
            for (JobInfo job : jobs) {
                DisplayInfo dinfo = this.m_flow.getEvent(job);
                this.processFlowEventInfo(dinfo, (DisplayInfo)job, nodes);
            }
            try {
                this.m_pfdModel.addPFDModelListener((PFDModelListener)modelListener);
                this.m_pfdModel.enableChangeUpdate();
                this.setModel(this.m_pfdModel);
                this.doPFDLayout(!restore);
            }
            catch (Exception ex) {
                SchedulerException se = new SchedulerException();
                se.initCause((Throwable)ex);
                throw se;
            }
        }
    }

    private void processFlowEventInfo(DisplayInfo pinfo, DisplayInfo sinfo, HashMap<String, PFDAbstractNode> nodes) {
        if (pinfo == null) {
            return;
        }
        if (pinfo instanceof GroupingEventInfo) {
            PFDAbstractNode snode = nodes.get(sinfo.getId());
            Gate gnode = new Gate((GroupingEventInfo)pinfo, this.m_frame);
            this.m_pfdModel.addPrimitive((PFDPrimitive)gnode);
            nodes.put(pinfo.getId(), (PFDAbstractNode)gnode);
            FlowEventLink link = new FlowEventLink(gnode.getOutputPort(), snode.getInputPort());
            link.setMiddleLabelVisible(false);
            link.setMiddleLabel(pinfo.toString());
            this.m_pfdModel.addPrimitive((PFDPrimitive)link);
            GroupingEventInfo ginfo = (GroupingEventInfo)pinfo;
            List list = ginfo.getDependencies();
            int numEvents = list.size();
            for (int x = 0; x < numEvents; ++x) {
                DisplayInfo ai = (DisplayInfo)list.get(x);
                if (ai instanceof GroupingEventInfo) {
                    this.processFlowEventInfo(ai, pinfo, nodes);
                } else if (ai instanceof JobEventInfo) {
                    PFDAbstractNode temp;
                    JobEventInfo jei = (JobEventInfo)ai;
                    JobInfo pjob = jei.getJobInfo();
                    PFDAbstractNode jnode = nodes.get(pjob.getId());
                    if (jnode instanceof Gate && (temp = jnode.getOutputPort().getLink(0).getToPort().getParentNode()) != null) {
                        jnode = temp;
                    }
                    if (jnode != null) {
                        if (sinfo instanceof JobInfo) {
                            link = new JobEventLink(jnode.getOutputPort(), gnode.getInputPort(), jei, this.m_flow, (JobInfo)sinfo, this.m_frame);
                        } else if (sinfo instanceof GroupingEventInfo) {
                            DisplayInfo dinfo = ((GroupingEventInfo)sinfo).getTarget();
                            link = new JobEventLink(jnode.getOutputPort(), gnode.getInputPort(), jei, this.m_flow, dinfo, this.m_frame);
                        }
                        if (link != null) {
                            link.setMiddleLabelVisible(false);
                            link.setMiddleLabel(ai.toString());
                            this.m_pfdModel.addPrimitive((PFDPrimitive)link);
                        }
                    }
                } else if (ai instanceof TimeEventInfo) {
                    Time tnode = new Time((TimeEventInfo)ai, this.m_frame);
                    if (this.m_timePropertiesListener != null) {
                        tnode.setPropertiesListener(this.m_timePropertiesListener);
                    }
                    this.m_pfdModel.addPrimitive((PFDPrimitive)tnode);
                    link = new FlowEventLink(tnode.getOutputPort(), gnode.getInputPort());
                    if (link != null) {
                        link.setMiddleLabelVisible(false);
                        link.setMiddleLabel(ai.toString());
                        this.m_pfdModel.addPrimitive((PFDPrimitive)link);
                    }
                } else if (ai instanceof FileEventInfo) {
                    File fnode = new File((FileEventInfo)ai, this.m_frame);
                    if (this.m_filePropertiesListener != null) {
                        fnode.setPropertiesListener(this.m_filePropertiesListener);
                    }
                    this.m_pfdModel.addPrimitive((PFDPrimitive)fnode);
                    link = new FlowEventLink(fnode.getOutputPort(), gnode.getInputPort());
                    if (link != null) {
                        link.setMiddleLabelVisible(false);
                        link.setMiddleLabel(ai.toString());
                        this.m_pfdModel.addPrimitive((PFDPrimitive)link);
                    }
                }
                this.m_dirty = true;
            }
        } else if (pinfo instanceof JobEventInfo) {
            PFDAbstractNode temp;
            JobEventInfo jei = (JobEventInfo)pinfo;
            JobInfo pjob = jei.getJobInfo();
            PFDAbstractNode jnode = nodes.get(pjob.getId());
            if (jnode instanceof Gate && (temp = jnode.getOutputPort().getLink(0).getToPort().getParentNode()) != null) {
                jnode = temp;
            }
            JobEventLink link = null;
            if (jnode != null) {
                DisplayInfo dinfo;
                PFDAbstractNode snode = nodes.get(sinfo.getId());
                if (sinfo instanceof JobInfo) {
                    link = new JobEventLink(jnode.getOutputPort(), snode.getInputPort(), jei, this.m_flow, (JobInfo)sinfo, this.m_frame);
                } else if (sinfo instanceof GroupingEventInfo && (dinfo = ((GroupingEventInfo)sinfo).getTarget()) instanceof JobInfo) {
                    link = new JobEventLink(jnode.getOutputPort(), snode.getInputPort(), jei, this.m_flow, (JobInfo)dinfo, this.m_frame);
                }
            }
            if (link != null) {
                link.setMiddleLabelVisible(false);
                link.setMiddleLabel(pinfo.toString());
                this.m_pfdModel.addPrimitive(link);
                this.m_dirty = true;
            }
        } else if (pinfo instanceof TimeEventInfo) {
            Time tnode = new Time((TimeEventInfo)pinfo, this.m_frame);
            if (this.m_timePropertiesListener != null) {
                tnode.setPropertiesListener(this.m_timePropertiesListener);
            }
            this.m_pfdModel.addPrimitive((PFDPrimitive)tnode);
            PFDAbstractNode snode = nodes.get(sinfo.getId());
            FlowEventLink link = new FlowEventLink(tnode.getOutputPort(), snode.getInputPort());
            link.setMiddleLabelVisible(false);
            link.setMiddleLabel(pinfo.toString());
            this.m_pfdModel.addPrimitive((PFDPrimitive)link);
            this.m_dirty = true;
        } else if (pinfo instanceof FileEventInfo) {
            File fnode = new File((FileEventInfo)pinfo, this.m_frame);
            if (this.m_filePropertiesListener != null) {
                fnode.setPropertiesListener(this.m_filePropertiesListener);
            }
            this.m_pfdModel.addPrimitive((PFDPrimitive)fnode);
            PFDAbstractNode snode = nodes.get(sinfo.getId());
            FlowEventLink link = new FlowEventLink(fnode.getOutputPort(), snode.getInputPort());
            link.setMiddleLabelVisible(false);
            link.setMiddleLabel(pinfo.toString());
            this.m_pfdModel.addPrimitive((PFDPrimitive)link);
            this.m_dirty = true;
        }
    }

    private DisplayInfo getTargetInfo(PFDAbstractNode node) {
        if (node instanceof Job) {
            return ((Job)node).getInfo();
        }
        if (node instanceof Subflow) {
            return ((Subflow)node).getInfo();
        }
        if (node instanceof Gate) {
            return ((Gate)node).getInfo().getTarget();
        }
        return null;
    }

    private boolean createNewJobEvent(JobEventLink link, JobInfo fromInfo, PFDAbstractNode toNode) {
        JobInfo toInfo = null;
        List events = null;
        if (toNode instanceof Job) {
            toInfo = ((Job)toNode).getInfo();
            events = this.m_flow.getEvents((DisplayInfo)toInfo);
        } else if (toNode instanceof Gate) {
            PFDLink tlink;
            toInfo = ((Gate)toNode).getInfo();
            Vector vector = ((Gate)toNode).getOutputPort().getFromLinks();
            if (vector.size() > 0 && (tlink = (PFDLink)vector.get(0)) != null) {
                PFDAbstractNode tNode = (PFDAbstractNode)tlink.getToNode();
                if (tNode instanceof Job) {
                    events = this.m_flow.getEvents((DisplayInfo)((Job)tlink.getToNode()).getInfo());
                } else if (tNode instanceof Subflow) {
                    events = this.m_flow.getEvents((DisplayInfo)((Subflow)tlink.getToNode()).getInfo());
                } else if (tNode instanceof Gate) {
                    events = this.m_flow.getEvents(((Gate)tlink.getToNode()).getInfo().getTarget());
                }
            }
        } else if (toNode instanceof Subflow) {
            toInfo = ((Subflow)toNode).getInfo();
            events = this.m_flow.getEvents((DisplayInfo)toInfo);
        }
        JobEventPanel panel = null;
        panel = new JobEventPanel(this.m_frame, fromInfo, this.m_flow, events);
        StandardDialog dia = new StandardDialog(this.m_frame, m_bundle.getString("FlowPFDView.NewJobEvent.Title.txt"), true);
        dia.setMainPanel((StandardPanel)panel);
        dia.setHelpProduct("scheduler");
        dia.setHelpTopic("window_newjob");
        dia.makeVisible();
        JobEventInfo info = null;
        if (dia.getReturnValue() == 1) {
            info = panel.getJobEvent();
            this.m_flow.addEvent((DisplayInfo)toInfo, (AbstractEventInfo)info);
            try {
                this.m_flow.checkCircularDependencies();
                link.setInfo(info);
                link.setFlow(this.m_flow);
                link.setFrame(this.m_frame);
                return true;
            }
            catch (InvalidParameterException ipe) {
                this.m_flow.removeEvent((DisplayInfo)toInfo, (AbstractEventInfo)info);
                try {
                    String message = FlowInfo.createCircularDependencyMessage(null, (String)ipe.getMessage(), (FlowInfo)this.m_flow);
                    String title = m_bundle.getString("FlowPFDView.Title.txt");
                    MessageUtil.displayMessage((Frame)this.m_frame, (String)message, (String)title, (int)2);
                }
                catch (SchedulerException e) {
                    e.printStackTrace();
                }
                return false;
            }
        }
        return false;
    }

    private JobEventLink createNewJobEvent(PFDPort fromPort, PFDPort toPort, JobInfo fromInfo, PFDAbstractNode toNode) {
        PFDLink tlink;
        Vector vector;
        JobInfo toInfo = null;
        JobInfo target = null;
        if (toNode instanceof Job) {
            toInfo = ((Job)toNode).getInfo();
        } else if (toNode instanceof Subflow) {
            toInfo = ((Subflow)toNode).getInfo();
        } else if (toNode instanceof Gate && (vector = ((Gate)toNode).getOutputPort().getFromLinks()).size() > 0 && (tlink = (PFDLink)vector.get(0)) != null) {
            PFDAbstractNode tNode = (PFDAbstractNode)tlink.getToNode();
            if (tNode instanceof Job) {
                target = toInfo = ((Job)tlink.getToNode()).getInfo();
            } else if (tNode instanceof Subflow) {
                target = toInfo = ((Subflow)tlink.getToNode()).getInfo();
            } else if (tNode instanceof Gate) {
                toInfo = ((Gate)tlink.getToNode()).getInfo();
                target = ((Gate)tlink.getToNode()).getInfo().getTarget();
            }
        }
        JobEventPanel panel = null;
        panel = new JobEventPanel(this.m_frame, fromInfo, this.m_flow, this.m_flow.getEvents(target));
        StandardDialog dia = new StandardDialog(this.m_frame, m_bundle.getString("FlowPFDView.NewJobEvent.Title.txt"), true);
        dia.setMainPanel((StandardPanel)panel);
        dia.setHelpProduct("scheduler");
        dia.setHelpTopic("window_newjob");
        dia.makeVisible();
        JobEventInfo info = null;
        if (dia.getReturnValue() == 1) {
            info = panel.getJobEvent();
            this.m_flow.addEvent((DisplayInfo)toInfo, (AbstractEventInfo)info);
            try {
                this.m_flow.checkCircularDependencies();
                JobEventLink neolink = new JobEventLink(fromPort, toPort, info, this.m_flow, (DisplayInfo)target, this.m_frame);
                return neolink;
            }
            catch (InvalidParameterException ipe) {
                this.m_flow.removeEvent((DisplayInfo)toInfo, (AbstractEventInfo)info);
                try {
                    FlowInfo.createCircularDependencyMessage(null, (String)ipe.getMessage(), (FlowInfo)this.m_flow);
                }
                catch (SchedulerException e) {
                    e.printStackTrace();
                }
                return null;
            }
        }
        return null;
    }

    private boolean setLabelOnFlowEventLink(FlowEventLink link, PFDAbstractNode fromNode) {
        String label = null;
        label = fromNode instanceof Time ? ((Time)fromNode).getInfo().toString() : (fromNode instanceof File ? ((File)fromNode).getInfo().toString() : (fromNode instanceof Gate ? ((Gate)fromNode).getInfo().toString() : ""));
        link.setMiddleLabelVisible(false);
        link.setMiddleLabel(label);
        return true;
    }

    private FlowEventLink createNewFlowEventLink(PFDPort fromPort, PFDPort toPort, PFDAbstractNode fromNode) {
        String label = null;
        label = fromNode instanceof Time ? ((Time)fromNode).getInfo().toString() : (fromNode instanceof File ? ((File)fromNode).getInfo().toString() : (fromNode instanceof Gate ? ((Gate)fromNode).getInfo().toString() : ""));
        FlowEventLink newLink = new FlowEventLink(fromPort, toPort);
        newLink.setMiddleLabelVisible(false);
        newLink.setMiddleLabel(label);
        return newLink;
    }

    private void checkToNodeForGrouping(PFDAbstractNode node) {
        Vector toLinks;
        if ((node instanceof Job || node instanceof Subflow) && (toLinks = node.getInputPort().getToLinks()).size() > 1) {
            DisplayInfo tinfo = this.getTargetInfo(node);
            GroupingEventInfo info = null;
            if (tinfo instanceof JobInfo) {
                info = new GroupingEventInfo((JobInfo)tinfo, 1);
            } else {
                info = new GroupingEventInfo((FlowInfo)tinfo);
                info.setEventType(1);
            }
            Gate gnode = new Gate(info, this.m_frame);
            this.m_pfdModel.addPrimitive((PFDPrimitive)gnode);
            for (int x = 0; x < toLinks.size(); ++x) {
                PFDLink temp = (PFDLink)toLinks.get(x);
                if (temp instanceof FlowEventLink) {
                    temp.setToPort(gnode.getInputPort());
                    continue;
                }
                this.m_pfdModel.removeLink((LinkLayoutInterface)temp);
            }
            node.getInputPort().removeAllLinks();
            FlowEventLink addLink = new FlowEventLink(gnode.getOutputPort(), node.getInputPort());
            addLink.setMiddleLabelVisible(false);
            addLink.setMiddleLabel(info.toString());
            this.m_pfdModel.addPrimitive((PFDPrimitive)addLink);
        }
    }

    private void removeEvent(PFDAbstractNode targetNode, AbstractEventInfo event) {
        if (targetNode != null) {
            if (targetNode instanceof Job) {
                this.m_flow.removeEvent((DisplayInfo)((Job)targetNode).getInfo(), event);
            } else if (targetNode instanceof Subflow) {
                this.m_flow.removeEvent((DisplayInfo)((Subflow)targetNode).getInfo(), event);
            } else if (targetNode instanceof Gate) {
                this.m_flow.removeEvent((DisplayInfo)((Gate)targetNode).getInfo(), event);
            } else if (targetNode instanceof Time) {
                this.m_flow.removeEvent((DisplayInfo)((Time)targetNode).getInfo(), event);
            } else if (targetNode instanceof File) {
                this.m_flow.removeEvent((DisplayInfo)((File)targetNode).getInfo(), event);
            }
        }
    }

    static /* synthetic */ boolean access$300(FlowPFDView x0, JobEventLink x1, JobInfo x2, PFDAbstractNode x3) {
        return x0.createNewJobEvent(x1, x2, x3);
    }

    static /* synthetic */ PFDModel access$400(FlowPFDView x0) {
        return x0.m_pfdModel;
    }

    static /* synthetic */ ResourceBundle access$600() {
        return m_bundle;
    }

    static /* synthetic */ Frame access$700(FlowPFDView x0) {
        return x0.m_frame;
    }

    static /* synthetic */ boolean access$800(FlowPFDView x0, FlowEventLink x1, PFDAbstractNode x2) {
        return x0.setLabelOnFlowEventLink(x1, x2);
    }

    static /* synthetic */ void access$900(FlowPFDView x0, PFDAbstractNode x1) {
        x0.checkToNodeForGrouping(x1);
    }

    static /* synthetic */ FlowEventLink access$1000(FlowPFDView x0, PFDPort x1, PFDPort x2, PFDAbstractNode x3) {
        return x0.createNewFlowEventLink(x1, x2, x3);
    }

    static /* synthetic */ JobEventLink access$1100(FlowPFDView x0, PFDPort x1, PFDPort x2, JobInfo x3, PFDAbstractNode x4) {
        return x0.createNewJobEvent(x1, x2, x3, x4);
    }

    static {
        String strClassName = FlowPFDView.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }

    private class myMouseListener
    implements MouseListener {
        private myMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                // empty if block
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            PFDPrimitive object;
            if (SwingUtilities.isRightMouseButton(e) && (object = FlowPFDView.this.pickPrimitive(e.getPoint().x, e.getPoint().y)) instanceof FlowEventLink) {
                ((FlowEventLink)object).setMiddleLabelVisible(false);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            PFDPrimitive object;
            if ((e.getClickCount() != 2 || !SwingUtilities.isLeftMouseButton(e)) && e.getClickCount() == 1 && (object = FlowPFDView.this.pickPrimitive(e.getPoint().x, e.getPoint().y)) instanceof FlowEventLink) {
                ((FlowEventLink)object).setMiddleLabelVisible(true);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            PFDPrimitive object = FlowPFDView.this.pickPrimitive(e.getPoint().x, e.getPoint().y);
            if (object instanceof FlowEventLink) {
                ((FlowEventLink)object).setMiddleLabelVisible(false);
            }
        }
    }

    private class myPFDModelListener
    implements PFDModelListener {
        private myPFDModelListener() {
        }

        public void modelChanged(PFDModelEvent e) {
            switch (e.getType()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    FlowPFDView.this.m_dirty = true;
                    break;
                }
                case 5: 
                case 6: 
                case 10: {
                    break;
                }
                case 9: {
                    FlowPFDView.this.m_dirty = true;
                    break;
                }
                case 4: {
                    FlowPFDView.this.m_dirty = true;
                    if (!(e.getPrimitive() instanceof Job)) break;
                    break;
                }
                case 11: {
                    FlowPFDView.this.m_dirty = true;
                    List primatives = null;
                    if (e.getPrimitive() instanceof PFDCollapsableNodeGroup) {
                        PFDCollapsableNodeGroup group = (PFDCollapsableNodeGroup)e.getPrimitive();
                        primatives = group.getNestedGroupPrimitives();
                    } else {
                        primatives = new ArrayList<PFDPrimitive>();
                        primatives.add(e.getPrimitive());
                    }
                    for (PFDPrimitive object : primatives) {
                        Gate node;
                        if (object instanceof JobEventLink) {
                            JobEventLink jel = (JobEventLink)object;
                            JobEventInfo jei = jel.getInfo();
                            PFDAbstractNode node2 = (PFDAbstractNode)jel.getToNode();
                            if (node2 instanceof Job) {
                                FlowPFDView.this.m_flow.removeEvent((DisplayInfo)((Job)node2).getInfo(), (AbstractEventInfo)jei);
                            }
                            if (node2 instanceof Subflow) {
                                FlowPFDView.this.m_flow.removeEvent((DisplayInfo)((Subflow)node2).getInfo(), (AbstractEventInfo)jei);
                            }
                            if (!(node2 instanceof Gate)) continue;
                            FlowPFDView.this.m_flow.removeEvent((DisplayInfo)((Gate)node2).getInfo(), (AbstractEventInfo)jei);
                            continue;
                        }
                        if (object instanceof Job) {
                            Job job = (Job)object;
                            JobInfo jobInfo = job.getInfo();
                            FlowPFDView.this.m_flow.removeJob((DisplayInfo)jobInfo);
                            if (FlowPFDView.this.m_jobList == null) {
                                FlowPFDView.this.m_jobList = new ArrayList();
                            }
                            FlowPFDView.this.m_jobList.add(jobInfo);
                            continue;
                        }
                        if (object instanceof Subflow) {
                            Subflow subflow = (Subflow)object;
                            JobInfo sflowInfo = subflow.getInfo();
                            FlowPFDView.this.m_flow.removeJob((DisplayInfo)sflowInfo);
                            FlowPFDView.this.m_flowList.add(sflowInfo);
                            continue;
                        }
                        if (object instanceof Time) {
                            node = null;
                            Time time = (Time)object;
                            if (time.getChildCount() > 0) {
                                node = time.getChildAt(0);
                            }
                            FlowPFDView.this.removeEvent((PFDAbstractNode)node, (AbstractEventInfo)time.getInfo());
                            continue;
                        }
                        if (object instanceof File) {
                            node = null;
                            File file = (File)object;
                            if (file.getChildCount() > 0) {
                                node = file.getChildAt(0);
                            }
                            FlowPFDView.this.removeEvent((PFDAbstractNode)node, (AbstractEventInfo)file.getInfo());
                            continue;
                        }
                        if (object instanceof Gate) {
                            node = (Gate)object;
                            GroupingEventInfo gei = node.getInfo();
                            List deps = gei.getDependencies();
                            int num = deps.size();
                            for (int i = num - 1; i >= 0; --i) {
                                AbstractEventInfo x = (AbstractEventInfo)deps.get(i);
                                FlowPFDView.this.m_flow.removeEvent((DisplayInfo)gei, x);
                            }
                            continue;
                        }
                        if (!(object instanceof FlowEventLink)) continue;
                        FlowEventLink link = (FlowEventLink)object;
                        PFDAbstractNode eventNode = (PFDAbstractNode)link.getFromNode();
                        FileEventInfo info = null;
                        if (eventNode instanceof File) {
                            info = ((File)eventNode).getInfo();
                        } else if (eventNode instanceof Time) {
                            info = ((Time)eventNode).getInfo();
                        } else if (eventNode instanceof Gate) {
                            info = ((Gate)eventNode).getInfo();
                        }
                        PFDAbstractNode node3 = (PFDAbstractNode)link.getToNode();
                        FlowPFDView.this.removeEvent(node3, (AbstractEventInfo)info);
                    }
                    break;
                }
            }
        }
    }

    private class myPFDViewListener
    implements PFDViewListener {
        private myPFDViewListener() {
        }

        /*
         * Unable to fully structure code
         */
        public void viewChanged(PFDViewEvent e) {
            switch (e.getType()) {
                case 11: {
                    break;
                }
                case 8: {
                    break;
                }
                case 5: {
                    break;
                }
                case 4: {
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    break;
                }
                case 7: {
                    break;
                }
                case 3: {
                    break;
                }
                case 9: {
                    link = e.getLink();
                    toNode = (PFDAbstractNode)link.getToNode();
                    fromNode = (PFDAbstractNode)link.getFromNode();
                    if (fromNode == null) {
                        return;
                    }
                    if (link instanceof JobEventLink) {
                        fromInfo = null;
                        fromInfo = fromNode instanceof Subflow != false ? ((Subflow)fromNode).getInfo() : ((Job)fromNode).getInfo();
                        okay = FlowPFDView.access$300(FlowPFDView.this, (JobEventLink)link, fromInfo, toNode);
                        if (!okay) {
                            FlowPFDView.access$400(FlowPFDView.this).removeLink((LinkLayoutInterface)link);
                            return;
                        }
                    } else if (link instanceof FlowEventLink) {
                        info = null;
                        if (toNode instanceof Gate) {
                            info = ((Gate)toNode).getInfo();
                        } else if (toNode instanceof Job) {
                            info = ((Job)toNode).getInfo();
                        } else if (toNode instanceof Subflow) {
                            info = ((Subflow)toNode).getInfo();
                        }
                        if (fromNode instanceof Time) {
                            FlowPFDView.access$500(FlowPFDView.this).addEvent((DisplayInfo)info, (AbstractEventInfo)((Time)fromNode).getInfo());
                        } else if (fromNode instanceof File) {
                            FlowPFDView.access$500(FlowPFDView.this).addEvent((DisplayInfo)info, (AbstractEventInfo)((File)fromNode).getInfo());
                        } else if (fromNode instanceof Gate) {
                            gNode = (Gate)fromNode;
                            if (info instanceof GroupingEventInfo) {
                                temp = info.getTarget();
                                if (temp instanceof JobInfo) {
                                    gNode.getInfo().setTarget((JobInfo)temp);
                                } else {
                                    gNode.getInfo().setTarget((FlowInfo)temp);
                                }
                            } else if (info instanceof JobInfo) {
                                gNode.getInfo().setTarget((JobInfo)info);
                            }
                            FlowPFDView.access$500(FlowPFDView.this).addEvent((DisplayInfo)info, (AbstractEventInfo)gNode.getInfo());
                            try {
                                FlowPFDView.access$500(FlowPFDView.this).checkCircularDependencies();
                            }
                            catch (InvalidParameterException ipe) {
                                FlowPFDView.access$500(FlowPFDView.this).removeEvent((DisplayInfo)info, (AbstractEventInfo)gNode.getInfo());
                                gNode.getInfo().setTarget((JobInfo)null);
                                FlowPFDView.access$400(FlowPFDView.this).removeLink((LinkLayoutInterface)link);
                                try {
                                    message = FlowInfo.createCircularDependencyMessage(null, (String)ipe.getMessage(), (FlowInfo)FlowPFDView.access$500(FlowPFDView.this));
                                    title = FlowPFDView.access$600().getString("FlowPFDView.Title.txt");
                                    MessageUtil.displayMessage((Frame)FlowPFDView.access$700(FlowPFDView.this), (String)message, (String)title, (int)2);
                                }
                                catch (SchedulerException se) {
                                    se.printStackTrace();
                                }
                                break;
                            }
                        }
                        FlowPFDView.access$800(FlowPFDView.this, (FlowEventLink)link, fromNode);
                    }
                    if ((node = (PFDAbstractNode)link.getToNode()) == null) break;
                    FlowPFDView.access$900(FlowPFDView.this, node);
                    break;
                }
                case 10: {
                    link = e.getLink();
                    newfrom = e.getNewFromNode();
                    newto = e.getNewToNode();
                    oldfrom = e.getOldFromNode();
                    oldto = e.getOldToNode();
                    v0 = newto != null ? !newto.equals(oldto) : (newTo = false);
                    v1 = newfrom != null ? !newfrom.equals(oldfrom) : (newFrom = false);
                    if (!(link instanceof JobEventLink)) ** GOTO lbl218
                    if (!newFrom || newfrom == null || newto == null || newfrom instanceof Job || newfrom instanceof Subflow) ** GOTO lbl158
                    newLink = FlowPFDView.access$1000(FlowPFDView.this, newfrom.getOutputPort(), newto.getInputPort(), newfrom);
                    FlowPFDView.access$400(FlowPFDView.this).disableChangeUpdate();
                    FlowPFDView.access$400(FlowPFDView.this).removeLink((LinkLayoutInterface)link);
                    FlowPFDView.access$400(FlowPFDView.this).addPrimitive((PFDPrimitive)newLink);
                    FlowPFDView.access$800(FlowPFDView.this, newLink, newfrom);
                    FlowPFDView.access$400(FlowPFDView.this).enableChangeUpdate();
                    if (!(newfrom instanceof Gate)) ** GOTO lbl189
                    info = null;
                    if (newto instanceof Gate) {
                        info = ((Gate)newto).getInfo();
                    } else if (newto instanceof Job) {
                        info = ((Job)newto).getInfo();
                    } else if (newto instanceof Subflow) {
                        info = ((Subflow)newto).getInfo();
                    }
                    gNode = (Gate)newfrom;
                    hold = gNode.getInfo().getTarget();
                    if (info instanceof GroupingEventInfo) {
                        temp = info.getTarget();
                        if (temp instanceof JobInfo) {
                            gNode.getInfo().setTarget((JobInfo)temp);
                        } else {
                            gNode.getInfo().setTarget((FlowInfo)temp);
                        }
                    } else if (info instanceof JobInfo) {
                        gNode.getInfo().setTarget((JobInfo)info);
                    }
                    v2 = old = info != null ? FlowPFDView.access$500(FlowPFDView.this).getEvent(info.getId()) : null;
                    if (old != null) {
                        FlowPFDView.access$500(FlowPFDView.this).removeEvent((DisplayInfo)info, old);
                    }
                    FlowPFDView.access$500(FlowPFDView.this).addEvent((DisplayInfo)info, (AbstractEventInfo)gNode.getInfo());
                    try {
                        FlowPFDView.access$500(FlowPFDView.this).checkCircularDependencies();
                        ** GOTO lbl189
                    }
                    catch (InvalidParameterException ipe) {
                        FlowPFDView.access$500(FlowPFDView.this).removeEvent((DisplayInfo)info, (AbstractEventInfo)gNode.getInfo());
                        if (hold instanceof JobInfo) {
                            gNode.getInfo().setTarget((JobInfo)hold);
                        } else {
                            gNode.getInfo().setTarget((FlowInfo)hold);
                        }
                        FlowPFDView.access$400(FlowPFDView.this).removeLink((LinkLayoutInterface)newLink);
                        try {
                            message = FlowInfo.createCircularDependencyMessage(null, (String)ipe.getMessage(), (FlowInfo)FlowPFDView.access$500(FlowPFDView.this));
                            title = FlowPFDView.access$600().getString("FlowPFDView.Title.txt");
                            MessageUtil.displayMessage((Frame)FlowPFDView.access$700(FlowPFDView.this), (String)message, (String)title, (int)2);
                        }
                        catch (SchedulerException se) {
                            se.printStackTrace();
                        }
                        break;
                    }
lbl158:
                    // 1 sources

                    if (newFrom) {
                        info = null;
                        if (newfrom instanceof Job) {
                            info = ((Job)newfrom).getInfo();
                        } else if (newfrom instanceof Subflow) {
                            info = ((Subflow)newfrom).getInfo();
                        }
                        if (oldfrom instanceof Job && newfrom instanceof Subflow || oldfrom instanceof Subflow && newfrom instanceof Job) {
                            oldinfo = null;
                            if (oldto instanceof Job) {
                                oldinfo = ((Job)oldto).getInfo();
                            } else if (oldto instanceof Subflow) {
                                oldinfo = ((Subflow)oldto).getInfo();
                            } else if (oldto instanceof Gate) {
                                oldinfo = ((Gate)oldto).getInfo();
                            }
                            jeinfo = ((JobEventLink)link).getInfo();
                            FlowPFDView.access$500(FlowPFDView.this).removeEvent((DisplayInfo)oldinfo, (AbstractEventInfo)jeinfo);
                            neolink = FlowPFDView.access$1100(FlowPFDView.this, link.getFromPort(), link.getToPort(), info, newto);
                            FlowPFDView.access$400(FlowPFDView.this).disableChangeUpdate();
                            FlowPFDView.access$400(FlowPFDView.this).removeLink((LinkLayoutInterface)link);
                            FlowPFDView.access$400(FlowPFDView.this).addPrimitive((PFDPrimitive)neolink);
                            FlowPFDView.access$400(FlowPFDView.this).enableChangeUpdate();
                        } else {
                            jeinfo = ((JobEventLink)link).getInfo();
                            jeinfo.setJobInfo(info);
                            ((JobEventLink)link).setInfo(jeinfo);
                        }
                    }
lbl189:
                    // 6 sources

                    if (newTo) {
                        newinfo = null;
                        oldinfo = null;
                        job = null;
                        if (newto instanceof Job) {
                            job = newinfo = ((Job)newto).getInfo();
                        } else if (newto instanceof Subflow) {
                            job = newinfo = ((Subflow)newto).getInfo();
                        } else if (newto instanceof Gate) {
                            gnode = (Gate)newto;
                            newinfo = gnode.getInfo();
                            job = gnode.getInfo().getTarget();
                        }
                        ((JobEventLink)link).setTargetJob((DisplayInfo)job);
                        if (oldto instanceof Gate) {
                            oldinfo = ((Gate)oldto).getInfo();
                        } else if (oldto instanceof Job) {
                            oldinfo = ((Job)oldto).getInfo();
                        } else if (oldto instanceof Subflow) {
                            oldinfo = ((Subflow)oldto).getInfo();
                        }
                        event = ((JobEventLink)link).getInfo();
                        FlowPFDView.access$500(FlowPFDView.this).removeEvent((DisplayInfo)oldinfo, (AbstractEventInfo)event);
                        FlowPFDView.access$500(FlowPFDView.this).addEvent((DisplayInfo)newinfo, (AbstractEventInfo)event);
                    }
                    ** GOTO lbl330
lbl218:
                    // 1 sources

                    if (link instanceof FlowEventLink) {
                        if (newFrom && !(newfrom instanceof Time) && !(newfrom instanceof File) && !(newfrom instanceof Gate)) {
                            oldinfo = null;
                            oldevent = null;
                            info = null;
                            if (newfrom instanceof Job) {
                                info = ((Job)newfrom).getInfo();
                            } else if (newfrom instanceof Subflow) {
                                info = ((Subflow)newfrom).getInfo();
                            }
                            if (oldto instanceof Gate) {
                                oldinfo = ((Gate)oldto).getInfo();
                            } else if (oldto instanceof Job) {
                                oldinfo = ((Job)oldto).getInfo();
                            } else if (oldto instanceof Subflow) {
                                oldinfo = ((Subflow)oldto).getInfo();
                            }
                            if (oldfrom instanceof Gate) {
                                oldevent = ((Gate)oldfrom).getInfo();
                            } else if (oldfrom instanceof Time) {
                                oldevent = ((Time)oldfrom).getInfo();
                            } else if (oldfrom instanceof File) {
                                oldevent = ((File)oldfrom).getInfo();
                            }
                            FlowPFDView.access$500(FlowPFDView.this).removeEvent((DisplayInfo)oldinfo, (AbstractEventInfo)oldevent);
                            neolink = FlowPFDView.access$1100(FlowPFDView.this, link.getFromPort(), link.getToPort(), info, newto);
                            FlowPFDView.access$400(FlowPFDView.this).disableChangeUpdate();
                            FlowPFDView.access$400(FlowPFDView.this).removeLink((LinkLayoutInterface)link);
                            FlowPFDView.access$400(FlowPFDView.this).addPrimitive((PFDPrimitive)neolink);
                            FlowPFDView.access$400(FlowPFDView.this).enableChangeUpdate();
                        } else if (newFrom) {
                            node = null;
                            newinfo = null;
                            oldinfo = null;
                            if (oldto instanceof Job) {
                                if (newto != null) {
                                    node = ((Job)newto).getInfo();
                                }
                            } else if (oldto instanceof Subflow) {
                                if (newto != null) {
                                    node = ((Subflow)newto).getInfo();
                                }
                            } else if (oldto instanceof Gate && newto != null) {
                                node = ((Gate)newto).getInfo();
                            }
                            if (newfrom instanceof Gate) {
                                newinfo = ((Gate)newfrom).getInfo();
                            } else if (newfrom instanceof Time) {
                                newinfo = ((Time)newfrom).getInfo();
                            } else if (newfrom instanceof File) {
                                newinfo = ((File)newfrom).getInfo();
                            }
                            if (oldfrom instanceof Gate) {
                                oldinfo = ((Gate)oldfrom).getInfo();
                            } else if (oldfrom instanceof Time) {
                                oldinfo = ((Time)oldfrom).getInfo();
                            } else if (oldfrom instanceof File) {
                                oldinfo = ((File)oldfrom).getInfo();
                            }
                            FlowPFDView.access$500(FlowPFDView.this).removeEvent((DisplayInfo)node, (AbstractEventInfo)oldinfo);
                            FlowPFDView.access$500(FlowPFDView.this).addEvent((DisplayInfo)node, (AbstractEventInfo)newinfo);
                        }
                        if (newTo) {
                            newinfo = null;
                            oldinfo = null;
                            event = null;
                            temp = null;
                            if (newto instanceof Job) {
                                temp = newinfo = ((Job)newto).getInfo();
                            } else if (newto instanceof Subflow) {
                                temp = newinfo = ((Subflow)newto).getInfo();
                            } else if (newto instanceof Gate) {
                                newinfo = ((Gate)newto).getInfo();
                                temp = ((GroupingEventInfo)newinfo).getTarget();
                            }
                            if (oldto instanceof Gate) {
                                oldinfo = ((Gate)oldto).getInfo();
                                node = (PFDAbstractNode)link.getFromNode();
                                if (node instanceof Time) {
                                    event = ((Time)node).getInfo();
                                } else if (node instanceof File) {
                                    event = ((File)node).getInfo();
                                } else if (node instanceof Gate) {
                                    event = ((Gate)node).getInfo();
                                    if (temp instanceof JobInfo) {
                                        ((GroupingEventInfo)event).setTarget(temp);
                                    } else {
                                        ((GroupingEventInfo)event).setTarget((FlowInfo)temp);
                                    }
                                }
                            } else if (oldto instanceof Job) {
                                oldinfo = ((Job)oldto).getInfo();
                                event = FlowPFDView.access$500(FlowPFDView.this).getEvent(oldinfo.getId());
                            } else if (oldto instanceof Subflow) {
                                oldinfo = ((Subflow)oldto).getInfo();
                                event = FlowPFDView.access$500(FlowPFDView.this).getEvent(oldinfo.getId());
                            }
                            FlowPFDView.access$500(FlowPFDView.this).removeEvent((DisplayInfo)oldinfo, event);
                            FlowPFDView.access$500(FlowPFDView.this).addEvent((DisplayInfo)newinfo, event);
                        }
                    }
lbl330:
                    // 6 sources

                    FlowPFDView.access$900(FlowPFDView.this, newto);
                    break;
                }
                case 6: {
                    value = e.getValue();
                    if (!(value instanceof Enumeration)) break;
                    while (((Enumeration)value).hasMoreElements()) {
                        obj = ((Enumeration)value).nextElement();
                        if (!(obj instanceof FlowEventLink)) continue;
                        link = (FlowEventLink)obj;
                        toNode = (PFDAbstractNode)link.getToNode();
                        fromNode = (PFDAbstractNode)link.getFromNode();
                        if (!(toNode instanceof Gate)) continue;
                        info = ((Gate)toNode).getInfo();
                        if (fromNode instanceof Time) {
                            timeInfo = ((Time)fromNode).getInfo();
                            info.addDependency((AbstractEventInfo)timeInfo);
                        } else if (fromNode instanceof File) {
                            fileInfo = ((File)fromNode).getInfo();
                            info.addDependency((AbstractEventInfo)fileInfo);
                        } else if (fromNode instanceof Gate) {
                            gateInfo = ((Gate)fromNode).getInfo();
                            info.addDependency((AbstractEventInfo)gateInfo);
                        }
                        FlowPFDView.access$800(FlowPFDView.this, link, fromNode);
                    }
                    break;
                }
            }
        }
    }
}

