/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.pfd;

import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.pfd.FlowPFDView;
import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.swing.visuals.util.Util;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;

public class ActionSaveAndClose
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private transient Frame m_frame;
    private FlowInfo m_flow;
    private FlowPFDView m_panel;
    private ActionListener m_saveListener;
    private ActionListener m_closeListener;
    private ActionEvent m_closeEvent;

    public ActionSaveAndClose(Frame frame, FlowPFDView panel, FlowInfo flow, ActionListener saveListener, ActionListener closeListener) {
        this.m_frame = frame;
        this.m_flow = flow;
        this.m_panel = panel;
        this.m_saveListener = saveListener;
        this.m_closeListener = closeListener;
        this.m_closeEvent = new ActionEvent((Object)panel, 1001, null);
        String nameString = m_bundle.getString("ActionSaveAndClose.Name.txt");
        this.putValue("Name", Util.getLabelWithoutMnemonic((String)nameString));
        this.putValue("MnemonicKey", Util.getDisplayedMnemonic((String)nameString));
        this.putValue("SmallIcon", IconUtil.getIcon((String)IconUtil.ACTION_Close));
        this.putValue("ShortDescription", m_bundle.getString("ActionSaveAndClose.ShortDescription.txt"));
    }

    public FlowInfo getInfo() {
        return this.m_flow;
    }

    public boolean setInfo(FlowInfo flow) {
        this.m_flow = flow;
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (this.m_panel.isDirty()) {
            String title;
            String message = m_bundle.getString("ActionSaveAndClose.SaveChanges.Msg.txt");
            int rc = MessageUtil.displayMessage((Frame)this.m_frame, (String)message, (String)(title = m_bundle.getString("ActionSaveAndClose.Title.txt")), (int)1, (int)0);
            if (rc == 1) {
                this.m_saveListener.actionPerformed(ae);
                if (!this.m_panel.isDirty()) {
                    this.m_closeListener.actionPerformed(this.m_closeEvent);
                } else {
                    message = m_bundle.getString("ActionSaveAndClose.SaveChanges.Failed.Msg.txt");
                    MessageUtil.displayMessage((Frame)this.m_frame, (String)message, (String)title, (int)1, (int)-1);
                }
            } else {
                this.m_closeListener.actionPerformed(this.m_closeEvent);
            }
        } else {
            this.m_closeListener.actionPerformed(this.m_closeEvent);
        }
    }

    static {
        String strClassName = ActionSaveAndClose.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }
}

