/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.pfd;

import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.pfd.FlowPFDView;
import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.swing.visuals.util.Util;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.InvalidParameterException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;

public class ActionSave
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private transient Frame m_frame;
    private FlowPFDView m_panel;
    private FlowInfo m_flow;
    private ActionListener m_saveListener;

    public ActionSave(Frame frame, FlowPFDView panel, FlowInfo flow, ActionListener saveListener) {
        this.m_frame = frame;
        this.m_panel = panel;
        this.m_flow = flow;
        this.m_saveListener = saveListener;
        String nameString = m_bundle.getString("ActionSave.Name.txt");
        this.putValue("Name", Util.getLabelWithoutMnemonic((String)nameString));
        this.putValue("MnemonicKey", Util.getDisplayedMnemonic((String)nameString));
        this.putValue("SmallIcon", IconUtil.getIcon((String)IconUtil.ACTION_Save));
        this.putValue("ShortDescription", m_bundle.getString("ActionSave.ShortDescription.txt"));
    }

    public FlowInfo getInfo() {
        return this.m_flow;
    }

    public boolean setInfo(FlowInfo flow) {
        this.m_flow = flow;
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (this.m_panel.isDirty()) {
            ActionEvent actionevent = new ActionEvent(this.m_flow, 1001, null);
            if (this.handleOrphanEvents()) {
                try {
                    this.m_panel.clearDirty();
                    this.m_flow.setPFD(this.m_panel.saveModel());
                    this.m_saveListener.actionPerformed(actionevent);
                }
                catch (InvalidParameterException ex) {
                    this.m_panel.markDirty();
                    String title = m_bundle.getString("ActionSave.Title.txt");
                    Object[] args = new Object[]{ex.getMessage()};
                    String message = MessageFormat.format(m_bundle.getString("ActionSave.SaveChanges.Failed.Msg.fmt"), args);
                    MessageUtil.displayMessage((Frame)this.m_frame, (String)message, (String)title, (int)1, (int)-1);
                }
            }
        }
    }

    private boolean handleOrphanEvents() {
        if (this.m_panel.areOrphanEvents()) {
            String title;
            String message = m_bundle.getString("ActionSave.RemoveOrphans.Msg.txt");
            int rc = MessageUtil.displayMessage((Frame)this.m_frame, (String)message, (String)(title = m_bundle.getString("ActionSave.Title.txt")), (int)1, (int)0);
            if (rc == 1) {
                this.m_panel.removeOrphanEvents();
                return true;
            }
            return false;
        }
        return true;
    }

    static {
        String strClassName = ActionSave.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }
}

