/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.TimeEventInfo;
import com.sas.scheduler.pfd.FlowEventActionListener;
import com.sas.scheduler.pfd.FlowPFDView;
import com.sas.scheduler.pfd.Time;
import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.scheduler.visuals.swing.TimeEventDialog;
import com.sas.swing.visuals.util.Util;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;

public class ActionAddTimeEvent
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private transient Frame m_frame;
    private FlowPFDView m_panel;
    private FlowInfo m_flow;
    private FlowEventActionListener m_timeEventListener;
    private ActionListener m_timePropertiesListener;

    public ActionAddTimeEvent(Frame frame, FlowPFDView panel, FlowInfo flow, FlowEventActionListener timeEventListener, ActionListener timePropertiesListener) {
        this.m_frame = frame;
        this.m_panel = panel;
        this.m_flow = flow;
        this.m_timeEventListener = timeEventListener;
        this.m_timePropertiesListener = timePropertiesListener;
        String nameString = m_bundle.getString("ActionAddTimeEvent.Name.txt");
        this.putValue("Name", Util.getLabelWithoutMnemonic((String)nameString));
        this.putValue("MnemonicKey", Util.getDisplayedMnemonic((String)nameString));
        this.putValue("SmallIcon", IconUtil.getIcon((String)IconUtil.NODE_TimeEvent));
        this.putValue("ShortDescription", m_bundle.getString("ActionAddTimeEvent.ShortDescription.txt"));
    }

    public void setFrame(Frame frame) {
        this.m_frame = frame;
    }

    public FlowInfo getInfo() {
        return this.m_flow;
    }

    public boolean setInfo(FlowInfo flow) {
        this.m_flow = flow;
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        TimeEventInfo time = null;
        Time node = null;
        if (this.m_timeEventListener != null) {
            time = new TimeEventInfo();
            node = new Time(time, this.m_frame);
            this.m_timeEventListener.actionPerformed(new ActionEvent((Object)node, 1001, null));
            if (this.m_timeEventListener.getReturnValue() == 1) {
                node.setPropertiesListener(this.m_timePropertiesListener);
                this.m_panel.addNode((PFDAbstractNode)node);
            }
        } else {
            TimeEventDialog dlg = new TimeEventDialog(this.m_frame, m_bundle.getString("ActionAddTimeEvent.Title.txt"));
            dlg.makeVisible();
            if (dlg.getReturnValue() == 1) {
                time = dlg.getTimeEvent();
                node = new Time(time, this.m_frame);
                this.m_panel.addNode((PFDAbstractNode)node);
            }
        }
    }

    static {
        String strClassName = ActionAddTimeEvent.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }
}

