/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.pfd.FlowPFDView;
import com.sas.scheduler.pfd.Subflow;
import com.sas.scheduler.visuals.swing.AddJobPanel;
import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.visuals.util.Util;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.InvalidParameterException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;

public class ActionAddSubflow
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private transient Frame m_frame;
    private FlowPFDView m_panel;
    private FlowInfo m_flow;
    private List<?> m_flowList;
    private ActionListener m_circularcheckListener = null;

    public ActionAddSubflow(Frame frame, FlowPFDView panel, FlowInfo flow, List<?> allAvailableFlows) {
        this.m_frame = frame;
        this.m_panel = panel;
        this.m_flow = flow;
        this.m_flowList = allAvailableFlows;
        String nameString = m_bundle.getString("ActionAddSubflow.Name.txt");
        this.putValue("Name", Util.getLabelWithoutMnemonic((String)nameString));
        this.putValue("MnemonicKey", Util.getDisplayedMnemonic((String)nameString));
        this.putValue("SmallIcon", IconUtil.getIcon((String)IconUtil.NODE_Flow));
        this.putValue("ShortDescription", m_bundle.getString("ActionAddSubflow.ShortDescription.txt"));
    }

    public void setFrame(Frame frame) {
        this.m_frame = frame;
    }

    public void setCircularCallbackListener(ActionListener listener) {
        this.m_circularcheckListener = listener;
    }

    public FlowInfo getInfo() {
        return this.m_flow;
    }

    public boolean setInfo(FlowInfo flow) {
        this.m_flow = flow;
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        AddJobPanel panel = new AddJobPanel(this.m_frame, this.m_flow, this.m_flowList, false);
        StandardDialog dlg = new StandardDialog(this.m_frame, m_bundle.getString("ActionAddSubflow.Title.txt"), true);
        dlg.setMainPanel((StandardPanel)panel);
        dlg.setHelpProduct("scheduler");
        dlg.setHelpTopic("window_addsubflow");
        dlg.makeVisible();
        List addedJobs = panel.getAddedJobs();
        if (addedJobs != null && addedJobs.size() > 0) {
            for (int i = 0; i < addedJobs.size(); ++i) {
                JobInfo subflow = (JobInfo)addedJobs.get(i);
                String rc = this.hasCircularLogic(this.m_flow, subflow);
                if (rc == null) {
                    this.m_panel.addNode((PFDAbstractNode)new Subflow(subflow, this.m_frame));
                    this.m_flowList.remove(subflow);
                    continue;
                }
                this.m_flow.removeJob((DisplayInfo)subflow);
                String title = m_bundle.getString("ActionAddSubflow.Title.txt");
                Object[] args = new Object[]{subflow.getName(), rc};
                String message = MessageFormat.format(m_bundle.getString("ActionAddSubflow.CircularLogic.FailedToAdd.Msg.fmt"), args);
                MessageUtil.displayMessage((Frame)this.m_frame, (String)message, (String)title, (int)1, (int)-1);
            }
        }
    }

    private String hasCircularLogic(FlowInfo flow, JobInfo subflow) {
        if (this.m_circularcheckListener != null) {
            try {
                this.m_circularcheckListener.actionPerformed(new ActionEvent(this.m_flow, 1001, subflow.getId()));
            }
            catch (InvalidParameterException e) {
                return e.getMessage();
            }
        } else {
            List ids = subflow.getSubflowJobIDs();
            if (ids != null && ids.contains(flow.getId())) {
                return flow.getId() + ":" + subflow.getId();
            }
        }
        return null;
    }

    static {
        String strClassName = ActionAddSubflow.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }
}

